# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
"""Gibbs sampling inference for structural time series models."""

from tensorflow_probability.substrates.numpy.experimental.sts_gibbs.gibbs_sampler import build_model_for_gibbs_fitting
from tensorflow_probability.substrates.numpy.experimental.sts_gibbs.gibbs_sampler import fit_with_gibbs_sampling
from tensorflow_probability.substrates.numpy.experimental.sts_gibbs.gibbs_sampler import get_seasonal_latents_shape
from tensorflow_probability.substrates.numpy.experimental.sts_gibbs.gibbs_sampler import GibbsSamplerState
from tensorflow_probability.substrates.numpy.experimental.sts_gibbs.gibbs_sampler import one_step_predictive


__all__ = [
    'GibbsSamplerState',
    'build_model_for_gibbs_fitting',
    'fit_with_gibbs_sampling',
    'get_seasonal_latents_shape',
    'one_step_predictive',
]


# @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
# This file is auto-generated by substrates/meta/rewrite.py
# It will be surfaced by the build system as a symlink at:
#   `tensorflow_probability/substrates/numpy/experimental/sts_gibbs/__init__.py`
# For more info, see substrate_runfiles_symlinks in build_defs.bzl
# @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
