#
# POPULAR CONSTANTS
#
from __future__ import annotations

import math

# Error computation
MACHINE_EPSILON_DOUBLE_PRECISION = 2.2204460493e-16
MACHINE_EPSILON_SINGLE_PRECISION = 1.1920928955e-07

# Math
PI = math.pi
E = math.e

# Physics
SPEED_OF_LIGHT = 299792458
PLANCK_CONSTANT = 6.62607004e-34
GRAVITATIONAL_CONSTANT = 6.67408e-11
ELEMENTARY_CHARGE = 1.6021766208e-19
BOLTZMANN_CONSTANT = 1.38064852e-23
AVOGADRO_CONSTANT = 6.022140857e23

# Computation
MAX_INT32 = 2147483647
MAX_INT64 = 9223372036854775807
MAX_UINT32 = 4294967295
MAX_UINT64 = 18446744073709551615
MAX_FLOAT32 = 3.40282347e38
MAX_FLOAT64 = 1.7976931348623157e308

# All consts
CONSTANTS_BY_NAME = {
    "Machine Epsilon (Double Precision)": MACHINE_EPSILON_DOUBLE_PRECISION,
    "Machine Epsilon (Single Precision)": MACHINE_EPSILON_SINGLE_PRECISION,
    "Planck Constant": PLANCK_CONSTANT,
    "Gravitational Constant": GRAVITATIONAL_CONSTANT,
    "Avogadro Constant": AVOGADRO_CONSTANT,
    "Speed of Light": SPEED_OF_LIGHT,
    "Pi": PI,
    "E": E,
}
