# WAFv2 Web ACL
resource "aws_wafv2_web_acl" "pass_1" {
  name        = "example-waf-acl"
  description = "Example WAF Web ACL"
  scope       = "REGIONAL"

  default_action {
    allow {}
  }

  rule {
    name     = "example-rule"
    priority = 1

    override_action {
      none {}
    }

    statement {
      managed_rule_group_statement {
        name        = "AWSManagedRulesKnownBadInputsRuleSet"
        vendor_name = "AWS"
      }
    }

    visibility_config {
      cloudwatch_metrics_enabled = true
      metric_name               = "example-rule-metric"
      sampled_requests_enabled  = true
    }
  }

  rule {
    name     = "example-rule2"
    priority = 1

    override_action {
      none {}
    }

    statement {
      managed_rule_group_statement {
        name        = "AWSManagedRulesAnonymousIpList"
        vendor_name = "AWS"
      }
    }

    visibility_config {
      cloudwatch_metrics_enabled = true
      metric_name               = "example-rule-metric"
      sampled_requests_enabled  = true
    }
  }

  visibility_config {
    cloudwatch_metrics_enabled = true
    metric_name               = "example-web-acl-metric"
    sampled_requests_enabled  = true
  }
}

# Application Load Balancer
resource "aws_lb" "pass_1" {
  name               = "example-alb"
  internal           = false
  load_balancer_type = "application"
  security_groups    = [aws_security_group.pass_1.id]
  subnets            = [aws_subnet.pass_1.id, aws_subnet.pass_1.id]
}

# WAF to ALB Association
resource "aws_wafv2_web_acl_association" "pass_1" {
  resource_arn = aws_lb.pass_1.arn
  web_acl_arn  = aws_wafv2_web_acl.pass_1.arn
}

##################

# WAFv2 Web ACL
resource "aws_wafv2_web_acl" "fail_2" {
  name        = "example-waf-acl"
  description = "Example WAF Web ACL"
  scope       = "REGIONAL"

  default_action {
    allow {}
  }

  # Add your rules here
  rule {
    name     = "example-rule"
    priority = 1

    override_action {
      none {}
    }

    statement {
      managed_rule_group_statement {
        name        = "AWSManagedRulesAnonymousIpList"
        vendor_name = "AWS"
      }
    }

    visibility_config {
      cloudwatch_metrics_enabled = true
      metric_name               = "example-rule-metric"
      sampled_requests_enabled  = true
    }
  }

  visibility_config {
    cloudwatch_metrics_enabled = true
    metric_name               = "example-web-acl-metric"
    sampled_requests_enabled  = true
  }
}

# Application Load Balancer
resource "aws_lb" "fail_2" {
  name               = "example-alb"
  internal           = false
  load_balancer_type = "application"
  security_groups    = [aws_security_group.fail_2.id]
  subnets            = [aws_subnet.fail_2.id, aws_subnet.fail_2.id]
}

# WAF to ALB Association
resource "aws_wafv2_web_acl_association" "fail_2" {
  resource_arn = aws_lb.fail_2.arn
  web_acl_arn  = aws_wafv2_web_acl.fail_2.arn
}

##################

# WAFv2 Web ACL
resource "aws_wafv2_web_acl" "fail_1" {
  name        = "managed-rule-example"
  description = "Example of WAFv2 ACL with multiple managed rule groups"
  scope       = "REGIONAL"

  default_action {
    allow {}
  }

  rule {
    name     = "common-rule-set"
    priority = 1

    override_action {
      none {}
    }

    statement {
      managed_rule_group_statement {
        name        = "AWSManagedRulesCommonRuleSet"
        vendor_name = "AWS"
      }
    }

    visibility_config {
      cloudwatch_metrics_enabled = true
      metric_name               = "CommonRuleSetMetric"
      sampled_requests_enabled  = true
    }
  }

  rule {
    name     = "anonymous-ip-list"
    priority = 2

    override_action {
      none {}
    }

    statement {
      managed_rule_group_statement {
        name        = "AWSManagedRulesAnonymousIpList"
        vendor_name = "AWS"
      }
    }

    visibility_config {
      cloudwatch_metrics_enabled = true
      metric_name               = "AnonymousIPListMetric"
      sampled_requests_enabled  = true
    }
  }

  visibility_config {
    cloudwatch_metrics_enabled = true
    metric_name               = "WAFWebACLMetric"
    sampled_requests_enabled  = true
  }
}

# Application Load Balancer
resource "aws_lb" "fail_1" {
  name               = "example-alb"
  internal           = false
  load_balancer_type = "application"
  security_groups    = [aws_security_group.fail_1.id]
  subnets            = [aws_subnet.fail_1.id, aws_subnet.fail_1.id]
}

# WAF to ALB Association
resource "aws_wafv2_web_acl_association" "fail_1" {
  resource_arn = aws_lb.fail_1.arn
  web_acl_arn  = aws_wafv2_web_acl.fail_1.arn
}