"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateAccountSas = generateAccountSas;
const tslib_1 = require("tslib");
const accountSasPermissions_js_1 = require("./accountSasPermissions.js");
const accountSasServices_js_1 = require("./accountSasServices.js");
const core_auth_1 = require("@azure/core-auth");
const accountSasSignatureValues_js_1 = require("./accountSasSignatureValues.js");
/**
 * Generates a Table Account Shared Access Signature (SAS) URI based on the client properties
 * and parameters passed in. The SAS is signed by the shared key credential of the client.
 *
 * @see https://learn.microsoft.com/en-us/rest/api/storageservices/create-account-sas
 *
 * @param options - Optional parameters.
 * @returns An account SAS token
 */
function generateAccountSas(credential, options = {}) {
    const { expiresOn, permissions = (0, accountSasPermissions_js_1.accountSasPermissionsFromString)("rl"), resourceTypes = "sco", services = (0, accountSasServices_js_1.accountSasServicesFromString)("t") } = options, rest = tslib_1.__rest(options, ["expiresOn", "permissions", "resourceTypes", "services"]);
    if (!(0, core_auth_1.isNamedKeyCredential)(credential)) {
        throw RangeError("Can only generate the account SAS when the client is initialized with a shared key credential");
    }
    let expiry = expiresOn;
    if (expiry === undefined) {
        const now = new Date();
        expiry = new Date(now.getTime() + 3600 * 1000);
    }
    const sas = (0, accountSasSignatureValues_js_1.generateAccountSasQueryParameters)(Object.assign({ permissions, expiresOn: expiry, resourceTypes, services: (0, accountSasServices_js_1.accountSasServicesToString)(services) }, rest), credential).toString();
    return sas;
}
//# sourceMappingURL=generateAccountSas.js.map