/**
 * Range for Service Operations.
 * @see https://learn.microsoft.com/rest/api/storageservices/specifying-the-range-header-for-file-service-operations
 */
export interface Range {
    /**
     * StartByte, larger than or equal 0.
     */
    offset: number;
    /**
     * Optional. Count of bytes, larger than 0.
     * If not provided, will return bytes from offset to the end.
     */
    count?: number;
}
/**
 * Generate a range string. For example:
 *
 * "bytes=255-" or "bytes=0-511"
 *
 * @param range - A range of byte positions.
 * @returns The string representation for the byte range.
 */
export declare function rangeToString(range: Range): string;
//# sourceMappingURL=Range.d.ts.map