import { Share } from "../operationsInterfaces/index.js";
import { StorageClient } from "../storageClient.js";
import { ShareCreateOptionalParams, ShareCreateResponse, ShareGetPropertiesOptionalParams, ShareGetPropertiesResponse, ShareDeleteOptionalParams, ShareDeleteResponse, ShareAcquireLeaseOptionalParams, ShareAcquireLeaseResponse, ShareReleaseLeaseOptionalParams, ShareReleaseLeaseResponse, ShareChangeLeaseOptionalParams, ShareChangeLeaseResponse, ShareRenewLeaseOptionalParams, ShareRenewLeaseResponse, ShareBreakLeaseOptionalParams, ShareBreakLeaseResponse, ShareCreateSnapshotOptionalParams, ShareCreateSnapshotResponse, SharePermission, ShareCreatePermissionOptionalParams, ShareCreatePermissionResponse, ShareGetPermissionOptionalParams, ShareGetPermissionResponse, ShareSetPropertiesOptionalParams, ShareSetPropertiesResponse, ShareSetMetadataOptionalParams, ShareSetMetadataResponse, ShareGetAccessPolicyOptionalParams, ShareGetAccessPolicyResponse, ShareSetAccessPolicyOptionalParams, ShareSetAccessPolicyResponse, ShareGetStatisticsOptionalParams, ShareGetStatisticsResponse, ShareRestoreOptionalParams, ShareRestoreResponse } from "../models/index.js";
/** Class containing Share operations. */
export declare class ShareImpl implements Share {
    private readonly client;
    /**
     * Initialize a new instance of the class Share class.
     * @param client Reference to the service client
     */
    constructor(client: StorageClient);
    /**
     * Creates a new share under the specified account. If the share with the same name already exists, the
     * operation fails.
     * @param options The options parameters.
     */
    create(options?: ShareCreateOptionalParams): Promise<ShareCreateResponse>;
    /**
     * Returns all user-defined metadata and system properties for the specified share or share snapshot.
     * The data returned does not include the share's list of files.
     * @param options The options parameters.
     */
    getProperties(options?: ShareGetPropertiesOptionalParams): Promise<ShareGetPropertiesResponse>;
    /**
     * Operation marks the specified share or share snapshot for deletion. The share or share snapshot and
     * any files contained within it are later deleted during garbage collection.
     * @param options The options parameters.
     */
    delete(options?: ShareDeleteOptionalParams): Promise<ShareDeleteResponse>;
    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for
     * set and delete share operations.
     * @param options The options parameters.
     */
    acquireLease(options?: ShareAcquireLeaseOptionalParams): Promise<ShareAcquireLeaseResponse>;
    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for
     * set and delete share operations.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The options parameters.
     */
    releaseLease(leaseId: string, options?: ShareReleaseLeaseOptionalParams): Promise<ShareReleaseLeaseResponse>;
    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for
     * set and delete share operations.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The options parameters.
     */
    changeLease(leaseId: string, options?: ShareChangeLeaseOptionalParams): Promise<ShareChangeLeaseResponse>;
    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for
     * set and delete share operations.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The options parameters.
     */
    renewLease(leaseId: string, options?: ShareRenewLeaseOptionalParams): Promise<ShareRenewLeaseResponse>;
    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for
     * set and delete share operations.
     * @param options The options parameters.
     */
    breakLease(options?: ShareBreakLeaseOptionalParams): Promise<ShareBreakLeaseResponse>;
    /**
     * Creates a read-only snapshot of a share.
     * @param options The options parameters.
     */
    createSnapshot(options?: ShareCreateSnapshotOptionalParams): Promise<ShareCreateSnapshotResponse>;
    /**
     * Create a permission (a security descriptor).
     * @param sharePermission A permission (a security descriptor) at the share level.
     * @param options The options parameters.
     */
    createPermission(sharePermission: SharePermission, options?: ShareCreatePermissionOptionalParams): Promise<ShareCreatePermissionResponse>;
    /**
     * Returns the permission (security descriptor) for a given key
     * @param filePermissionKey Key of the permission to be set for the directory/file.
     * @param options The options parameters.
     */
    getPermission(filePermissionKey: string, options?: ShareGetPermissionOptionalParams): Promise<ShareGetPermissionResponse>;
    /**
     * Sets properties for the specified share.
     * @param options The options parameters.
     */
    setProperties(options?: ShareSetPropertiesOptionalParams): Promise<ShareSetPropertiesResponse>;
    /**
     * Sets one or more user-defined name-value pairs for the specified share.
     * @param options The options parameters.
     */
    setMetadata(options?: ShareSetMetadataOptionalParams): Promise<ShareSetMetadataResponse>;
    /**
     * Returns information about stored access policies specified on the share.
     * @param options The options parameters.
     */
    getAccessPolicy(options?: ShareGetAccessPolicyOptionalParams): Promise<ShareGetAccessPolicyResponse>;
    /**
     * Sets a stored access policy for use with shared access signatures.
     * @param options The options parameters.
     */
    setAccessPolicy(options?: ShareSetAccessPolicyOptionalParams): Promise<ShareSetAccessPolicyResponse>;
    /**
     * Retrieves statistics related to the share.
     * @param options The options parameters.
     */
    getStatistics(options?: ShareGetStatisticsOptionalParams): Promise<ShareGetStatisticsResponse>;
    /**
     * Restores a previously deleted Share.
     * @param options The options parameters.
     */
    restore(options?: ShareRestoreOptionalParams): Promise<ShareRestoreResponse>;
}
//# sourceMappingURL=share.d.ts.map