// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { RestError } from "@azure/core-rest-pipeline";
export * from "./AccountSASPermissions.js";
export * from "./AccountSASResourceTypes.js";
export * from "./AccountSASServices.js";
export { generateAccountSASQueryParameters, } from "./AccountSASSignatureValues.js";
export * from "./FileSASPermissions.js";
export { parseOctalFileMode, toOctalFileMode, parseSymbolicFileMode, toSymbolicFileMode, } from "./utils/utils.common.js";
export { generateFileSASQueryParameters, } from "./FileSASSignatureValues.js";
export * from "./Clients.js";
export * from "./ShareSASPermissions.js";
export { AnonymousCredential, Credential, StorageSharedKeyCredential, BaseRequestPolicy, AnonymousCredentialPolicy, CredentialPolicy, StorageRetryPolicyType, StorageRetryPolicy, StorageRetryPolicyFactory, StorageSharedKeyCredentialPolicy, StorageBrowserPolicyFactory, } from "@azure/storage-common";
export { StorageFileAudience, getFileServiceAccountAudience, } from "./models.js";
export * from "./FileSystemAttributes.js";
export { Pipeline, isPipelineLike, newPipeline, StorageOAuthScopes, } from "./Pipeline.js";
export * from "./ShareServiceClient.js";
export * from "./SASQueryParameters.js";
export * from "./generatedModels.js";
export { RestError };
export { logger } from "./log.js";
//# sourceMappingURL=index.js.map