/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.RecordVarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public final class PatternHelper {
    public static final String MATCH_EXCEPTION = "java/lang/MatchException";

    public static void replaceAssignmentsWithPatternVariables(@NotNull RootStatement statement, @NotNull StructClass structClass) {
        if (!structClass.hasPatternsInInstanceofSupport()) {
            return;
        }
        ArrayList<SwitchHelper.TempVarAssignmentItem> tempVarAssignments = new ArrayList<SwitchHelper.TempVarAssignmentItem>();
        boolean recordPatternSupport = structClass.hasRecordPatternSupport();
        List<Runnable> runnables = PatternHelper.replaceAssignmentsWithPatternVariables(statement, new HashSet<IfStatement>(), tempVarAssignments, recordPatternSupport);
        if (runnables.isEmpty() || !SwitchHelper.checkAssignmentsToDelete(statement, tempVarAssignments)) {
            return;
        }
        for (Runnable runnable : runnables) {
            runnable.run();
        }
        SwitchHelper.removeTempVariableDeclarations(tempVarAssignments);
    }

    private static List<Runnable> replaceAssignmentsWithPatternVariables(@NotNull Statement statement, @NotNull Set<IfStatement> usedIfStatements, @NotNull List<SwitchHelper.TempVarAssignmentItem> tempVarAssignments, boolean recordPatternSupport) {
        IfStatement ifStatement;
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        if (statement instanceof IfStatement && !usedIfStatements.contains(ifStatement = (IfStatement)statement)) {
            FunctionExprent instanceOfExprent = PatternHelper.findInstanceofExprent(ifStatement);
            if (instanceOfExprent == null) {
                return new ArrayList<Runnable>();
            }
            List<Exprent> operands = instanceOfExprent.getLstOperands();
            if (operands.size() != 2 || operands.get((int)0).type != 12 || operands.get((int)1).type != 3) {
                return new ArrayList<Runnable>();
            }
            VarExprent operand = (VarExprent)operands.get(0);
            ConstExprent checkType = (ConstExprent)operands.get(1);
            if (ifStatement.getIfstat() == null) {
                return new ArrayList<Runnable>();
            }
            Statement statementToChange = ifStatement.getIfstat();
            PatternVariableCandidate patternVarCandidate = PatternHelper.findInitPatternVarCandidate(statementToChange, operand, checkType, recordPatternSupport, statementToChange);
            if (patternVarCandidate == null && ifStatement.getElsestat() != null) {
                statementToChange = ifStatement.getElsestat();
                patternVarCandidate = PatternHelper.findInitPatternVarCandidate(statementToChange, operand, checkType, recordPatternSupport, statementToChange);
            }
            if (patternVarCandidate == null) {
                return new ArrayList<Runnable>();
            }
            tempVarAssignments.addAll(patternVarCandidate.getTempAssignments());
            usedIfStatements.add(ifStatement);
            usedIfStatements.addAll(patternVarCandidate.getUsedIfStatement());
            PatternVariableCandidate finalPatternVarCandidate = patternVarCandidate;
            Runnable action = () -> {
                operands.remove(1);
                operands.add(finalPatternVarCandidate.getVarExprent());
                finalPatternVarCandidate.getCleaner().run();
            };
            actions.add(action);
        }
        for (Statement child : statement.getStats()) {
            actions.addAll(0, PatternHelper.replaceAssignmentsWithPatternVariables(child, usedIfStatements, tempVarAssignments, recordPatternSupport));
        }
        return actions;
    }

    @Nullable
    private static FunctionExprent findInstanceofExprent(@NotNull IfStatement ifStat) {
        return ifStat.getHeadexprent().getAllExprents(true).stream().filter(expr -> expr.type == 6).map(expr -> (FunctionExprent)expr).filter(expr -> expr.getFuncType() == 30).findFirst().orElse(null);
    }

    static PatternVariableCandidate findInitPatternVarCandidate(@NotNull Statement ifElseStat, @NotNull VarExprent operand, @NotNull ConstExprent checkType, boolean recordPatternSupport, @NotNull Statement topLevelStatement) {
        if (ifElseStat instanceof BasicBlockStatement) {
            PatternVariableCandidate recordCandidate;
            BasicBlockStatement basicBlockStatement = (BasicBlockStatement)ifElseStat;
            PatternVariableCandidate candidate = PatternHelper.findSimpleCandidateFromIfStat(ifElseStat, operand, checkType, topLevelStatement);
            if (candidate == null) {
                return null;
            }
            if (recordPatternSupport && DecompilerContext.getOption("crp") && (recordCandidate = PatternHelper.findInitRecordPatternCandidate(basicBlockStatement, operand, candidate.getVarExprent())) != null) {
                recordCandidate.getTempVarAssignments().addAll(candidate.getTempVarAssignments());
                return recordCandidate;
            }
            return candidate;
        }
        if (ifElseStat instanceof IfStatement || ifElseStat instanceof SequenceStatement) {
            return PatternHelper.findInitPatternVarCandidate(ifElseStat.getFirst(), operand, checkType, recordPatternSupport, topLevelStatement);
        }
        return null;
    }

    @Nullable
    static PatternVariableCandidate findNextPatternVarCandidate(@NotNull Statement ifBranch, @NotNull VarExprent operand, @NotNull ConstExprent checkType, @NotNull VarTracker varTracker, @NotNull Statement topLevelStatement) {
        if (ifBranch instanceof BasicBlockStatement) {
            PatternVariableCandidate recordCandidate;
            PatternVariableCandidate candidate = PatternHelper.findSimpleCandidateFromIfStat(ifBranch, operand, checkType, topLevelStatement);
            VarTracker newVarTracker = varTracker.copy();
            if (newVarTracker == null) {
                return candidate;
            }
            RecordVarExprent previousRecord = newVarTracker.getRecord(operand);
            if (previousRecord == null) {
                return candidate;
            }
            previousRecord.setVarType(checkType.getConstType());
            if (!(ifBranch.getParent() instanceof IfStatement) && DecompilerContext.getOption("crp") && (recordCandidate = PatternHelper.findRecordPatternCandidate(ifBranch.getParent(), newVarTracker)) != null) {
                varTracker.putAll(newVarTracker);
                return recordCandidate;
            }
            return candidate;
        }
        if (ifBranch instanceof SequenceStatement || ifBranch instanceof IfStatement) {
            return PatternHelper.findNextPatternVarCandidate(ifBranch.getFirst(), operand, checkType, varTracker, topLevelStatement);
        }
        return null;
    }

    @Nullable
    private static PatternVariableCandidate findSimpleCandidateFromIfStat(@NotNull Statement ifElseStat, @NotNull VarExprent operand, @NotNull ConstExprent checkType, @NotNull Statement topLevelStatement) {
        Exprent exprent;
        List<Exprent> castExprents;
        List<Exprent> ifElseExprents = ifElseStat.getExprents();
        if (ifElseExprents == null || ifElseExprents.isEmpty() || ifElseExprents.get((int)0).type != 2) {
            return null;
        }
        AssignmentExprent assignmentExprent = (AssignmentExprent)ifElseExprents.get(0);
        if (assignmentExprent.getLeft().type != 12) {
            return null;
        }
        VarExprent varExprent = (VarExprent)assignmentExprent.getLeft();
        if (assignmentExprent.getRight().type != 6) {
            return null;
        }
        FunctionExprent castExprent = (FunctionExprent)assignmentExprent.getRight();
        if (castExprent.getFuncType() != 29) {
            return null;
        }
        if (!varExprent.isDefinition()) {
            Exprent leftAssignmentPart = assignmentExprent.getLeft();
            Exprent rightAssignmentPart = assignmentExprent.getRight();
            if (leftAssignmentPart.type != 12 || rightAssignmentPart.type != 6 || ((FunctionExprent)rightAssignmentPart).getFuncType() != 29) {
                return null;
            }
            varExprent = (VarExprent)leftAssignmentPart;
            List<Exprent> castOperands = ((FunctionExprent)rightAssignmentPart).getLstOperands();
            if (castOperands.size() != 2 || castOperands.get((int)1).type != 3) {
                return null;
            }
            VarType castType = ((ConstExprent)castOperands.get(1)).getConstType();
            varExprent = (VarExprent)varExprent.copy();
            varExprent.setVarType(castType);
            varExprent.setDefinition(true);
        }
        if ((castExprents = castExprent.getAllExprents()).size() != 2 || !operand.equals(castExprents.get(0)) || !checkType.equals(castExprents.get(1))) {
            return null;
        }
        ArrayList<SwitchHelper.TempVarAssignmentItem> tempVarAssignments = new ArrayList<SwitchHelper.TempVarAssignmentItem>();
        if (!varExprent.isDefinition()) {
            tempVarAssignments.add(new SwitchHelper.TempVarAssignmentItem(varExprent, ifElseStat));
        }
        if ((exprent = assignmentExprent.getLeft()) instanceof VarExprent) {
            VarExprent toDelete = (VarExprent)exprent;
            tempVarAssignments.add(new SwitchHelper.TempVarAssignmentItem(toDelete, ifElseStat));
        }
        return new PatternVariableCandidate(varExprent, topLevelStatement, new HashSet<IfStatement>(), tempVarAssignments, () -> {});
    }

    private static PatternVariableCandidate findInitRecordPatternCandidate(@NotNull BasicBlockStatement blockStatement, @NotNull VarExprent varExprent, @NotNull VarExprent candidate) {
        Statement parent = blockStatement.getParent();
        if (!(parent instanceof SequenceStatement)) {
            return null;
        }
        SequenceStatement parentSequenceStatement = (SequenceStatement)parent;
        int indexOfBlock = parentSequenceStatement.getStats().indexOf(blockStatement);
        if (indexOfBlock != 0) {
            return null;
        }
        RecordVarExprent recordVarExprent = new RecordVarExprent(candidate);
        VarTracker varTracker = new VarTracker(recordVarExprent);
        varTracker.put(varExprent, recordVarExprent, null);
        return PatternHelper.findRecordPatternCandidate(parentSequenceStatement, varTracker);
    }

    @Nullable
    private static PatternVariableCandidate findRecordPatternCandidate(@NotNull Statement parent, @NotNull VarTracker varTracker) {
        SequenceStatement sequenceStatement;
        if (!(parent instanceof SequenceStatement)) {
            return null;
        }
        if (PatternHelper.checkRegularEdgesForRecordPattern(parent)) {
            return null;
        }
        HashSet<IfStatement> ifStatements = new HashSet<IfStatement>();
        VBStyleCollection<Statement, Integer> stats = parent.getStats();
        if (stats.size() < 3) {
            return null;
        }
        int i = 0;
        while (true) {
            BasicBlockStatement basicBlockStatement;
            Object e;
            block13: {
                block12: {
                    if (stats.size() <= i + 1 || !((e = stats.get(i)) instanceof BasicBlockStatement)) break block12;
                    basicBlockStatement = (BasicBlockStatement)e;
                    e = stats.get(i + 1);
                    if (e instanceof CatchStatement) break block13;
                }
                if (i != 0) break;
                return null;
            }
            CatchStatement catchStatement = (CatchStatement)e;
            if (!PatternHelper.processFullBlock(varTracker, basicBlockStatement)) {
                return null;
            }
            if (!PatternHelper.processCatchStatement(varTracker, catchStatement)) {
                return null;
            }
            i += 2;
        }
        int nextIndex = i;
        ArrayList<SwitchHelper.TempVarAssignmentItem> tempVarAssignmentItems = new ArrayList<SwitchHelper.TempVarAssignmentItem>();
        if (!PatternHelper.processAtLeastOneBlock(varTracker, (Statement)stats.get(nextIndex))) {
            tempVarAssignmentItems.addAll(varTracker.getTempItems());
            sequenceStatement = new SequenceStatement(parent.getStats().subList(nextIndex, parent.getStats().size()));
            return new PatternVariableCandidate(varTracker.root, sequenceStatement, new HashSet<IfStatement>(), tempVarAssignmentItems, () -> {
                sequenceStatement.getStats().forEach(stat -> stat.setParent(sequenceStatement));
                parent.getParent().replaceStatement(parent, sequenceStatement);
            });
        }
        Object e = stats.get(nextIndex);
        if (e instanceof IfStatement) {
            PatternVariableCandidate nestedCandidate;
            IfStatement ifStatement = (IfStatement)e;
            if (stats.size() - 1 == nextIndex && (nestedCandidate = PatternHelper.findRecursivelyInstanceOfIfStatement((Statement)stats.get(nextIndex), varTracker, tempVarAssignmentItems)) != null) {
                ifStatements.add(ifStatement);
                ifStatements.addAll(nestedCandidate.getUsedIfStatement());
                tempVarAssignmentItems.addAll(varTracker.getTempItems());
                tempVarAssignmentItems.addAll(nestedCandidate.getTempVarAssignments());
                return new PatternVariableCandidate(varTracker.root, nestedCandidate.getNextStatement(), ifStatements, tempVarAssignmentItems, () -> {
                    nestedCandidate.getCleaner().run();
                    parent.getParent().replaceStatement(parent, ifStatement.getIfstat());
                });
            }
        }
        tempVarAssignmentItems.addAll(varTracker.getTempItems());
        sequenceStatement = new SequenceStatement(parent.getStats().subList(nextIndex, parent.getStats().size()));
        return new PatternVariableCandidate(varTracker.root, sequenceStatement, new HashSet<IfStatement>(), tempVarAssignmentItems, () -> {
            sequenceStatement.getStats().forEach(stat -> stat.setParent(sequenceStatement));
            parent.getParent().replaceStatement(parent, sequenceStatement);
        });
    }

    private static PatternVariableCandidate findRecursivelyInstanceOfIfStatement(@NotNull Statement statement, @NotNull VarTracker tracker, @NotNull List<SwitchHelper.TempVarAssignmentItem> tempVarAssignmentItems) {
        if (!(statement instanceof IfStatement)) {
            return null;
        }
        IfStatement ifStatement = (IfStatement)statement;
        if (ifStatement.isNegated() || ifStatement.getHeadexprent().getAllExprents().size() != 1) {
            return null;
        }
        FunctionExprent instanceOfExprent = PatternHelper.findInstanceofExprent(ifStatement);
        if (instanceOfExprent == null) {
            return null;
        }
        List<Exprent> operands = instanceOfExprent.getLstOperands();
        if (operands.size() != 2 || operands.get((int)0).type != 12 || operands.get((int)1).type != 3) {
            return null;
        }
        VarExprent operand = (VarExprent)operands.get(0);
        ConstExprent checkType = (ConstExprent)operands.get(1);
        RecordVarExprent recordVarExprent = tracker.getRecord(operand);
        if (recordVarExprent == null) {
            return null;
        }
        PatternVariableCandidate candidate = PatternHelper.findNextPatternVarCandidate(ifStatement.getIfstat(), operand, checkType, tracker, ifStatement.getIfstat());
        if (candidate == null) {
            return null;
        }
        if (!recordVarExprent.copyFrom(candidate.getVarExprent())) {
            return null;
        }
        tempVarAssignmentItems.addAll(candidate.getTempVarAssignments());
        tracker.put(candidate.getVarExprent(), recordVarExprent, null);
        return candidate;
    }

    private static boolean processCatchStatement(@NotNull VarTracker tracker, @NotNull CatchStatement statement) {
        RecordVarExprent nextComponent;
        Object processor;
        NewExprent newExprent;
        Exprent exprent;
        ExitExprent exitExprent;
        AssignmentExprent assignmentExprent;
        Exprent exprent2;
        Statement tryBody = statement.getFirst();
        if (tryBody == null || tryBody.getStats() == null || !tryBody.getStats().isEmpty() || tryBody.getExprents() == null || tryBody.getExprents().size() != 1) {
            return false;
        }
        Exprent body = tryBody.getExprents().get(0);
        InvocationExprent invocationExprent = null;
        boolean hasAssignment = false;
        if (body instanceof AssignmentExprent && (exprent2 = (assignmentExprent = (AssignmentExprent)body).getRight()) instanceof InvocationExprent) {
            InvocationExprent newInvocation;
            invocationExprent = newInvocation = (InvocationExprent)exprent2;
            hasAssignment = true;
        } else if (body instanceof InvocationExprent) {
            InvocationExprent newInvocation;
            invocationExprent = newInvocation = (InvocationExprent)body;
        }
        if (invocationExprent == null) {
            return false;
        }
        Exprent qualifier = invocationExprent.getInstance();
        if (qualifier == null || invocationExprent.isStatic() || invocationExprent.getParameters() == null || !invocationExprent.getParameters().isEmpty()) {
            return false;
        }
        RecordVarExprent recordVarExprent = tracker.getRecord(qualifier);
        if (recordVarExprent == null) {
            return false;
        }
        if (statement.getStats().size() != 2) {
            return false;
        }
        Statement catchSection = (Statement)statement.getStats().get(1);
        if (!catchSection.getStats().isEmpty() || catchSection.getExprents() == null) {
            return false;
        }
        if (!(catchSection.getExprents().size() == 1 || catchSection.getExprents().size() == 2 && catchSection.getExprents().get(1) instanceof ExitExprent)) {
            return false;
        }
        Exprent throwExpected = catchSection.getExprents().get(0);
        if (!(throwExpected instanceof ExitExprent && (exitExprent = (ExitExprent)throwExpected).getExitType() == 1 && (exprent = exitExprent.getValue()) instanceof NewExprent && (newExprent = (NewExprent)exprent).getNewType() != null && MATCH_EXCEPTION.equals(newExprent.getNewType().getValue()) || catchSection.getExprents().get(1) instanceof ExitExprent)) {
            return false;
        }
        if (!hasAssignment) {
            VarType exprType = invocationExprent.getExprType();
            processor = DecompilerContext.getVarProcessor();
            nextComponent = new RecordVarExprent(new VarExprent(DecompilerContext.getCounterContainer().getCounterAndIncrement(2), exprType, (VarProcessor)processor));
            recordVarExprent.addComponent(nextComponent);
            return true;
        }
        processor = ((AssignmentExprent)body).getLeft();
        if (!(processor instanceof VarExprent)) {
            return false;
        }
        VarExprent assignTo = (VarExprent)processor;
        VarExprent assignToDefinition = (VarExprent)assignTo.copy();
        assignToDefinition.setDefinition(true);
        nextComponent = new RecordVarExprent(assignToDefinition);
        recordVarExprent.addComponent(nextComponent);
        tracker.put(assignTo, nextComponent, tryBody);
        return true;
    }

    private static boolean processFullBlock(@NotNull VarTracker tracker, @NotNull Statement statement) {
        if (statement instanceof BasicBlockStatement && statement.getExprents() != null) {
            for (Exprent statementExprent : statement.getExprents()) {
                if (PatternHelper.collectRecordAssignment(tracker, statementExprent, statement)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean processAtLeastOneBlock(@NotNull VarTracker tracker, @NotNull Statement statement) {
        if (statement instanceof BasicBlockStatement && statement.getExprents() != null) {
            AssignmentExprent assignmentExprent;
            Exprent exprent;
            Exprent exprent2;
            boolean found = false;
            List<Exprent> exprents = statement.getExprents();
            List<StatEdge> edges = statement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
            if (edges.size() == 1 && edges.get(0).getType() == StatEdge.EdgeType.BREAK && exprents.size() > 1 && (exprent2 = exprents.get(exprents.size() - 1)) instanceof AssignmentExprent && (exprent = (assignmentExprent = (AssignmentExprent)exprent2).getLeft()) instanceof VarExprent) {
                VarExprent preserveVarExprent = (VarExprent)exprent;
                if (PatternHelper.usedOutside(edges.get(0), assignmentExprent)) {
                    exprents = exprents.subList(0, exprents.size() - 1);
                    tracker.addPreserve(preserveVarExprent, statement);
                }
            }
            for (Exprent statementExprent : exprents) {
                if (PatternHelper.collectRecordAssignment(tracker, statementExprent, statement)) {
                    found = true;
                    continue;
                }
                return found;
            }
        }
        if (statement instanceof SequenceStatement || statement instanceof IfStatement) {
            return PatternHelper.processAtLeastOneBlock(tracker, statement.getFirst());
        }
        return true;
    }

    private static boolean usedOutside(@NotNull StatEdge edge, @NotNull AssignmentExprent assignmentExprent) {
        Exprent left = assignmentExprent.getLeft();
        if (!(left instanceof VarExprent)) {
            return false;
        }
        VarExprent varExprent = (VarExprent)left;
        Statement destination = edge.getDestination();
        if (destination == null) {
            return false;
        }
        List<Exprent> exprents = destination.getExprents();
        if (exprents == null) {
            return false;
        }
        return exprents.stream().anyMatch(exp -> exp.containsExprent(varExprent));
    }

    private static boolean collectRecordAssignment(@NotNull VarTracker tracker, @Nullable Exprent exprent, @NotNull Statement statement) {
        Exprent reassignedRecord2;
        FunctionExprent functionExprent;
        if (!(exprent instanceof AssignmentExprent)) {
            return false;
        }
        AssignmentExprent assignmentExprent = (AssignmentExprent)exprent;
        Exprent exprentLeft = assignmentExprent.getLeft();
        if (!(exprentLeft instanceof VarExprent)) {
            return false;
        }
        VarExprent leftVarExprent = (VarExprent)exprentLeft;
        Exprent right = assignmentExprent.getRight();
        if (right instanceof VarExprent) {
            VarExprent varExprent = (VarExprent)right;
            RecordVarExprent reassignedRecord2 = tracker.getRecord(varExprent);
            if (reassignedRecord2 == null) {
                return false;
            }
            reassignedRecord2.copyFrom(leftVarExprent);
            tracker.put(leftVarExprent, reassignedRecord2, statement);
        } else if (right instanceof FunctionExprent && (functionExprent = (FunctionExprent)right).getFuncType() == 29 && functionExprent.getLstOperands().size() == 2 && (reassignedRecord2 = functionExprent.getLstOperands().get(1)) instanceof ConstExprent) {
            ConstExprent constExprent = (ConstExprent)reassignedRecord2;
            Exprent varForCast = functionExprent.getLstOperands().get(0);
            RecordVarExprent recordToCast = tracker.getRecord(varForCast);
            if (recordToCast == null) {
                return false;
            }
            if (!recordToCast.getVarType().equals(constExprent.getExprType())) {
                return false;
            }
            recordToCast.copyFrom(leftVarExprent);
            tracker.put(leftVarExprent, recordToCast, statement);
        } else {
            return false;
        }
        return true;
    }

    private static boolean checkRegularEdgesForRecordPattern(@NotNull Statement parent) {
        for (int i = 0; i < parent.getStats().size(); ++i) {
            Statement statement = (Statement)parent.getStats().get(i);
            if (i == parent.getStats().size() - 1) continue;
            List<StatEdge> edges = statement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
            if (edges.size() != 1) {
                return true;
            }
            StatEdge edge = edges.get(0);
            if (edge.getType() == StatEdge.EdgeType.REGULAR && edge.getDestination() == parent.getStats().get(i + 1)) continue;
            return true;
        }
        return false;
    }

    static class PatternVariableCandidate {
        @NotNull
        private final VarExprent varExprent;
        @NotNull
        private final List<SwitchHelper.TempVarAssignmentItem> tempVarAssignments;
        @NotNull
        private final Runnable cleaner;
        @NotNull
        private final Set<IfStatement> usedIfStatement = new HashSet<IfStatement>();
        @NotNull
        private final Statement nextStatement;
        @Nullable
        private Exprent guards;

        PatternVariableCandidate(@NotNull VarExprent varExprent, @NotNull Statement nextStatement, @NotNull Set<IfStatement> usedIfStatement, @NotNull List<SwitchHelper.TempVarAssignmentItem> tempVarAssignments, @NotNull Runnable cleaner) {
            this.varExprent = varExprent;
            this.tempVarAssignments = tempVarAssignments;
            this.cleaner = cleaner;
            this.getUsedIfStatement().addAll(usedIfStatement);
            this.nextStatement = nextStatement;
        }

        List<SwitchHelper.TempVarAssignmentItem> getTempAssignments() {
            return this.getTempVarAssignments();
        }

        @NotNull
        VarExprent getVarExprent() {
            return this.varExprent;
        }

        @NotNull
        List<SwitchHelper.TempVarAssignmentItem> getTempVarAssignments() {
            return this.tempVarAssignments;
        }

        @NotNull
        Runnable getCleaner() {
            return this.cleaner;
        }

        @NotNull
        Set<IfStatement> getUsedIfStatement() {
            return this.usedIfStatement;
        }

        @NotNull
        Statement getNextStatement() {
            return this.nextStatement;
        }

        @Nullable
        Exprent getGuards() {
            return this.guards;
        }

        void setGuards(@Nullable Exprent guards) {
            this.guards = guards;
        }
    }

    static class VarTracker {
        @NotNull
        private RecordVarExprent root;
        @NotNull
        private final Map<VarExprent, RecordVarExprent> varRecordTracker = new HashMap<VarExprent, RecordVarExprent>();
        @NotNull
        private final List<SwitchHelper.TempVarAssignmentItem> varTempAssignmentTracker = new ArrayList<SwitchHelper.TempVarAssignmentItem>();

        VarTracker(@NotNull RecordVarExprent root) {
            this.root = root;
        }

        void put(@NotNull VarExprent varExprent, @NotNull RecordVarExprent recordVarExprent, @Nullable Statement statement) {
            this.varRecordTracker.put(varExprent, recordVarExprent);
            if (statement != null) {
                this.varTempAssignmentTracker.add(new SwitchHelper.TempVarAssignmentItem(varExprent, statement));
            }
        }

        @Nullable
        RecordVarExprent getRecord(@NotNull Exprent exp) {
            return this.varRecordTracker.get(exp);
        }

        @NotNull
        List<SwitchHelper.TempVarAssignmentItem> getTempItems() {
            return this.varTempAssignmentTracker;
        }

        void addPreserve(@NotNull VarExprent varExprent, @NotNull Statement statement) {
            this.varTempAssignmentTracker.add(new SwitchHelper.TempVarAssignmentItem(varExprent, statement, false));
        }

        @Nullable
        VarTracker copy() {
            RecordVarExprent copy = this.root.copy();
            HashMap<RecordVarExprent, RecordVarExprent> mapToNew = new HashMap<RecordVarExprent, RecordVarExprent>();
            ArrayDeque<Map.Entry<RecordVarExprent, RecordVarExprent>> queue = new ArrayDeque<Map.Entry<RecordVarExprent, RecordVarExprent>>();
            queue.add(Map.entry(this.root, copy));
            while (!queue.isEmpty()) {
                Map.Entry nextPair = (Map.Entry)queue.poll();
                mapToNew.put((RecordVarExprent)nextPair.getKey(), (RecordVarExprent)nextPair.getValue());
                List<RecordVarExprent> oldComponents = ((RecordVarExprent)nextPair.getKey()).getComponents();
                List<RecordVarExprent> newComponents = ((RecordVarExprent)nextPair.getValue()).getComponents();
                if (oldComponents.size() != newComponents.size()) {
                    return null;
                }
                for (int i = 0; i < oldComponents.size(); ++i) {
                    queue.add(Map.entry((RecordVarExprent)oldComponents.get(i), newComponents.get(i)));
                }
            }
            HashMap<VarExprent, RecordVarExprent> newVarRecordTracker = new HashMap<VarExprent, RecordVarExprent>();
            for (Map.Entry<VarExprent, RecordVarExprent> entry : this.varRecordTracker.entrySet()) {
                RecordVarExprent newExprent = (RecordVarExprent)mapToNew.get(entry.getValue());
                newVarRecordTracker.put(entry.getKey(), newExprent);
            }
            VarTracker newTracker = new VarTracker(copy);
            newTracker.varRecordTracker.putAll(newVarRecordTracker);
            newTracker.varTempAssignmentTracker.addAll(this.varTempAssignmentTracker);
            return newTracker;
        }

        private void putAll(@NotNull VarTracker tracker) {
            this.root = tracker.root;
            this.varRecordTracker.putAll(tracker.varRecordTracker);
            this.varTempAssignmentTracker.addAll(tracker.varTempAssignmentTracker);
        }
    }
}

