# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


#############################################################################################
# File: rust_version_database.py
# Origin: Rust Repository https://github.com/rust-lang/rust
#
# Description:
# This file serves as a comprehensive reference, capturing the commit hashes associated with Rust versions over time.
# It facilitates tracking the commit history and enables the precise association of specific versions with their respective commits.
#
# Regeneration Instructions:
#
# To regenerate or update this file, you can follow these steps:
# 1. Navigate to the script directory.
# 2. Execute the script 'extract_rust_hashes.py'.
#    Example command: python extract_rust_hashes.py
#############################################################################################


rust_commit_hash = {
    "a28077b28a02b92985b3a3faecf92813155f1ea1": "1.74.1",
    "79e9716c980570bfd1f666e3b16ac583f0168962": "1.74.0",
    "cc66ad468955717ab92600c770da8c1601a4ff33": "1.73.0",
    "d5c2e9c342b358556da91d61ed4133f6f50fc0c3": "1.72.1",
    "5680fa18feaa87f3ff04063800aec256c3d4b4be": "1.72.0",
    "eb26296b556cef10fb713a38f3d16b9886080f26": "1.71.1",
    "8ede3aae28fe6e4d52b38157d7bfe0d3bceef225": "1.71.0",
    "90c541806f23a127002de5b4038be731ba1458ca": "1.70.0",
    "84c898d65adf2f39a5a98507f1fe0ce10a2b8dbc": "1.69.0",
    "9eb3afe9ebe9c7d2b84b71002d44f4a0edac95e0": "1.68.2",
    "8460ca823e8367a30dda430efda790588b8c84d3": "1.68.1",
    "2c8cc343237b8f7d5a3c3703e3a87f2eb2c54a74": "1.68.0",
    "d5a82bbd26e1ad8b7401f6a718a9c57c96905483": "1.67.1",
    "fc594f15669680fa70d255faec3ca3fb507c3405": "1.67.0",
    "90743e7298aca107ddaa0c202a4d3604e29bfeb6": "1.66.1",
    "69f9c33d71c871fc16ac445211281c6e7a340943": "1.66.0",
    "897e37553bba8b42751c67658967889d11ecd120": "1.65.0",
    "a55dd71d5fb0ec5a6a3a9e8c27b2127ba491ce52": "1.64.0",
    "4b91a6ea7258a947e59c6522cd5898e7c0a6a88f": "1.63.0",
    "e092d0b6b43f2de967af0887873151bb1c0b18d3": "1.62.1",
    "a8314ef7d0ec7b75c336af2c9857bfaf43002bfc": "1.62.0",
    "fe5b13d681f25ee6474be29d748c65adcd91f69e": "1.61.0",
    "7737e0b5c4103216d6fd8cf941b7ab9bdbaace7c": "1.60.0",
    "9d1b2106e23b1abd32fce1f17267604a5102f57a": "1.59.0",
    "db9d1b20bba1968c1ec1fc49616d4742c1725b4b": "1.58.1",
    "02072b482a8b5357f7fb5e5637444ae30e423c40": "1.58.0",
    "f1edd0429582dd29cccacaf50fd134b05593bd9c": "1.57.0",
    "59eed8a2aac0230a8b53e89d4e99d55912ba6b35": "1.56.1",
    "09c42c45858d5f3aedfa670698275303a3d19afa": "1.56.0",
    "c8dfcfe046a7680554bf4eb612bad840e7631c4b": "1.55.0",
    "a178d0322ce20e33eac124758e837cbd80a6f633": "1.54.0",
    "53cb7b09b00cbea8754ffb78e7e3cb521cb8af4b": "1.53.0",
    "9bc8c42bb2f19e745a63f3445f1ac248fb015e53": "1.52.1",
    "88f19c6dab716c6281af7602e30f413e809c5974": "1.52.0",
    "2fd73fabe469357a12c2c974c140f67e7cdd76d0": "1.51.0",
    "cb75ad5db02783e8b0222fee363c5f63f7e2cf5b": "1.50.0",
    "e1884a8e3c3e813aada8254edfa120e85bf5ffca": "1.49.0",
    "7eac88abb2e57e752f3302f02be5f3ce3d7adfb4": "1.48.0",
    "18bf6b4f01a6feaf7259ba7cdae58031af1b7b39": "1.47.0",
    "04488afe34512aa4c33566eb16d8c912a3ae04f9": "1.46.0",
    "d3fb005a39e62501b8b0b356166e515ae24e2e54": "1.45.2",
    "c367798cfd3817ca6ae908ce675d1d99242af148": "1.45.1",
    "5c1f21c3b82297671ad3ae1e8c942d2ca92e84f2": "1.45.0",
    "c7087fe00d2ba919df1d813c040a5d47e43b0fe7": "1.44.1",
    "49cae55760da0a43428eba73abcb659bb70cf2e4": "1.44.0",
    "8d69840ab92ea7f4d323420088dd8c9775f180cd": "1.43.1",
    "4fb7144ed159f94491249e86d5bbd033b5d60550": "1.43.0",
    "b8cedc00407a4c56a3bda1ed605c6fc166655447": "1.42.0",
    "f3e1a954d2ead4e2fc197c7da7d71e6c61bad196": "1.41.1",
    "5e1a799842ba6ed4a57e91f7ab9435947482f7d8": "1.41.0",
    "73528e339aae0f17a15ffa49a8ac608f50c6cf14": "1.40.0",
    "4560ea788cb760f0a34127156c78e2552949f734": "1.39.0",
    "625451e376bb2e5283fc4741caa0a3e8a2ca4d54": "1.38.0",
    "eae3437dfe991621e8afdc82734f4a172d7ddf9b": "1.37.0",
    "a53f9df32fbb0b5f4382caaad8f1a46f36ea887c": "1.36.0",
    "3c235d5600393dfe6c36eeed34042efad8d4f26e": "1.35.0",
    "6c2484dc3c532c052f159264e970278d8b77cdc9": "1.34.2",
    "fc50f328b0353b285421b8ff5d4100966387a997": "1.34.1",
    "91856ed52c58aa5ba66a015354d1cc69e9779bdf": "1.34.0",
    "2aa4c46cfdd726e97360c2734835aa3515e8c858": "1.33.0",
    "9fda7c2237db910e41d6a712e9a2139b352e558b": "1.32.0",
    "b6c32da9b0481e3e9d737153286b3ff8aa39a22c": "1.31.1",
    "abe02cefd6cd1916df62ad7dc80161bea50b72e8": "1.31.0",
    "1433507eba7d1a114e4c6f27ae0e1a74f60f20de": "1.30.1",
    "da5f414c2c0bfe5198934493f04c676e2b23ff2e": "1.30.0",
    "17a9dc7513b9fea883dc9505f09f97c63d1d601b": "1.29.2",
    "b801ae66425cf7c3c71052b19ef8f145b0d0513d": "1.29.1",
    "aa3ca1994904f2e056679fce1f185db8c7ed2703": "1.29.0",
    "9634041f0e8c0f3191d2867311276f19d0a42564": "1.28.0",
    "58cc626de3301192d5d8c6dcbde43b5b44211ae2": "1.27.2",
    "5f2b325f64ed6caa7179f3e04913db437656ec7e": "1.27.1",
    "3eda71b00ad48d7bf4eef4c443e7f611fd061418": "1.27.0",
    "594fb253c2b02b320c728391a425d028e6dc7a09": "1.26.2",
    "827013a31b88e536e85b8e6ceb5b9988042ec335": "1.26.1",
    "a7756804103447ea4e68a71ccf071e7ad8f7a03e": "1.26.0",
    "84203cac67e65ca8640b8392348411098c856985": "1.25.0",
    "d3ae9a9e08edf12de0ed82af57ba2a56c26496ea": "1.24.1",
    "4d90ac38c0b61bb69470b61ea2cccea0df48d9e5": "1.24.0",
    "766bd11c8a3c019ca53febdcd77b2215379dd67d": "1.23.0",
    "05e2e1c41414e8fc73d0f267ea8dab1a3eeeaa99": "1.22.1",
    "328886ba2eaf0d3ac7e78ef3ba27eb296d0af3c0": "1.22.0",
    "3b72af97e42989b2fe104d8edbaee123cdf7c58f": "1.21.0",
    "f3d6973f41a7d1fb83029c9c0ceaf0f5d4fd7208": "1.20.0",
    "0ade339411587887bf01bcfa2e9ae4414c8900d4": "1.19.0",
    "03fc9d622e0ea26a3d37f5ab030737fcca6928b9": "1.18.0",
    "56124baa9e73f28c0709e59e74783cf234a978cf": "1.17.0",
    "30cf806ef8881c41821fbd43e5cf3699c5290c16": "1.16.0",
    "021bd294c039bd54aa5c4aa85bcdffb0d24bc892": "1.15.1",
    "10893a9a349cdd423f2490a6984acb5b3b7c8046": "1.15.0",
    "e8a0123241f0d397d39cd18fcc4e5e7edde22730": "1.14.0",
    "2c6933acc05c61e041be764cb1331f6281993f3f": "1.13.0",
    "d4f39402a0c2c2b94ec0375cd7f7f6d7918113cd": "1.12.1",
    "3191fbae9da539442351f883bdabcad0d72efcb6": "1.12.0",
    "9b21dcd6a89f38e8ceccb2ede8c9027cb409f6e3": "1.11.0",
    "cfcb716cf0961a7e3a4eceac828d94805cf8140b": "1.10.0",
    "e4e8b666850a763fdf1c3c2c142856ab51e32779": "1.9.0",
    "db2939409db26ab4904372c82492cd3488e4c44e": "1.8.0",
    "a5d1e7a59a2a3413c377b003075349f854304b5e": "1.7.0",
    "c30b771ad9d44ab84f8c88b80c25fcfde2433126": "1.6.0",
    "3d7cd77e442ce34eaac8a176ae8be17669498ebc": "1.5.0",
    "8ab8581f6921bc7a8e3fa4defffd2814372dcb15": "1.4.0",
    "9a92aaf19a64603b02b4130fe52958cc12488900": "1.3.0",
    "082e4763615bdbe7b4dd3dfd6fc2210b7773edf5": "1.2.0",
    "35ceea3997c79a3b7562e89b462ab76af5b86b22": "1.1.0",
    "a59de37e99060162a2674e3ff45409ac73595c0e": "1.0.0",
    "522d09dfecbeca1595f25ac58c6d0178bbd21d7d": "1.0.0-alpha.2",
    "44a287e6eb22ec3c2a687fc156813577464017f7": "1.0.0-alpha",
    "ba4081a5a8573875fed17545846f6f6902c8ba8d": "0.12.0",
    "aa1163b92de7717eb7c5eba002b4012e0574a7fe": "0.11.0",
    "46867cc3e4ddcbb1d359a315805de00094dacaf9": "0.10",
    "7613b15fdbbb9bf770a2c731f4135886b0ff3cf0": "0.9",
    "8a4f0fa6c518eb634687abe9659601d9d2a61899": "0.8",
    "a2db7c15ce9f586164cabb15d83fb3f6bbeb3cf5": "0.7",
    "00dbbd01c2aee72982b3e0f9511ae1d4428c3ba9": "0.6",
    "8b98e5a296d95c5e832db0756828e5bec31c6f50": "0.5",
    "39c0d3591e0326874b7263a621ce09ecd64f0eb2": "0.4",
    "2f32a1581f522e524009138b33b1c7049ced668d": "0.3",
    "0622a74c48a708aec28d25964f4e9b4489580bc7": "0.2",
    "16e4369fe3b5f00aa3cdc584a4e41c51c0d3ca8a": "0.1",
}
