/*
 * Decompiled with CFR 0.152.
 */
package pcremoteconfiguration;

import felonycrowbar.webservice.ConfiguredImplant;
import felonycrowbar.webservice.FcMessage;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import pcremoteconfiguration.ActionOutput;
import pcremoteconfiguration.PcRemoteConfiguration;
import pcremoteconfiguration.RemoteConfiguration;

public class PcRemoteConfigGUI
extends JFrame
implements RemoteConfiguration.StatusCallback {
    public static final Icon GOOD = new ImageIcon(ClassLoader.getSystemResource("images/agt_action_success.png"));
    public static final Icon BAD = new ImageIcon(ClassLoader.getSystemResource("images/agt_action_fail.png"));
    public static final Collection<String> reqFiles = Collections.unmodifiableCollection(Arrays.asList("config.xml", "exec.properties", "pc.properties", "private_key.bin", "public_key.bin"));
    Component[] listToDisable;
    RemoteConfiguration remoteConfig;
    private JButton build;
    private JLabel currentStatus;
    private JTextField dataDirectory;
    private JLabel isPasswordValid;
    private JLabel isProjectNameValid;
    private JLabel isSidValid;
    private JLabel isToolConfigValid;
    private JLabel isUsernameValid;
    private JLabel isVersionValid;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPasswordField password;
    private JTextField peddlecheapVersion;
    private JTextField projectName;
    private JTextField sid;
    private JTextField toolConfigURL;
    private JTextField username;

    public PcRemoteConfigGUI() {
        this.initComponents();
        this.listToDisable = new Component[]{this.toolConfigURL, this.peddlecheapVersion, this.projectName, this.username, this.sid, this.password, this.build};
        this.validateData();
        this.setEnabledDetails(false);
    }

    private void isValidDirectory() {
        boolean bl = false;
        File file = new File(this.dataDirectory.getText());
        if (file.exists() && file.isDirectory()) {
            boolean bl2 = true;
            for (String string : reqFiles) {
                File file2 = new File(file, string);
                if (file2.exists() && !file2.isDirectory()) continue;
                bl2 = false;
            }
            if (bl2) {
                bl = true;
            }
        }
        this.setEnabledDetails(bl);
        if (bl) {
            try {
                this.remoteConfig = new RemoteConfiguration(this, String.format("%s/pc.properties", file.getAbsolutePath()));
                this.remoteConfig.loadConfiguration(String.format("%s/exec.properties", file.getAbsolutePath()));
                this.toolConfigURL.setText(this.remoteConfig.getToolConfigServer().toString());
                this.peddlecheapVersion.setText(this.remoteConfig.getVersion());
                this.projectName.setText("");
                this.username.setText(this.remoteConfig.getUser());
                this.password.setText(this.remoteConfig.getPassword());
                this.sid.setText(this.remoteConfig.getSid());
                this.remoteConfig.setPrivateKey(new File(file, "private_key.bin"));
                this.remoteConfig.setPublicKey(new File(file, "public_key.bin"));
                this.remoteConfig.setXml(new File(file, "config.xml"));
                this.projectName.requestFocus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.SetStatus(exception.getMessage());
            }
        }
    }

    @Override
    public void SetStatus(final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PcRemoteConfigGUI.this.currentStatus.setText(string);
            }
        });
    }

    private void setEnabledDetails(boolean bl) {
        for (Component component : this.listToDisable) {
            component.setEnabled(bl);
        }
    }

    private void validateData() {
        boolean bl = this.toolConfigURL.isEnabled();
        try {
            new URL(this.toolConfigURL.getText());
            this.isToolConfigValid.setIcon(GOOD);
        }
        catch (Exception exception) {
            this.isToolConfigValid.setIcon(BAD);
            bl = false;
        }
        if (!this.mustHaveValue(this.peddlecheapVersion, this.isVersionValid)) {
            bl = false;
        }
        if (!this.mustHaveValue(this.projectName, this.isProjectNameValid)) {
            bl = false;
        }
        if (!this.mustHaveValue(this.username, this.isUsernameValid)) {
            bl = false;
        }
        if (!this.mustHaveValue(this.sid, this.isSidValid)) {
            bl = false;
        }
        if (!this.mustHaveValue(this.password, this.isPasswordValid)) {
            bl = false;
        }
        this.build.setEnabled(bl);
    }

    private boolean mustHaveValue(JTextField jTextField, JLabel jLabel) {
        boolean bl = jTextField.getText().trim().length() > 0;
        jLabel.setIcon(bl ? GOOD : BAD);
        return bl;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dataDirectory = new JTextField();
        this.jButton1 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButton2 = new JButton();
        this.jLabel3 = new JLabel();
        this.toolConfigURL = new JTextField();
        this.isToolConfigValid = new JLabel();
        this.jLabel4 = new JLabel();
        this.peddlecheapVersion = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectName = new JTextField();
        this.jLabel6 = new JLabel();
        this.username = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.sid = new JTextField();
        this.isVersionValid = new JLabel();
        this.isProjectNameValid = new JLabel();
        this.isUsernameValid = new JLabel();
        this.isPasswordValid = new JLabel();
        this.isSidValid = new JLabel();
        this.build = new JButton();
        this.jSeparator2 = new JSeparator();
        this.currentStatus = new JLabel();
        this.password = new JPasswordField();
        this.setDefaultCloseOperation(3);
        this.setTitle("PeddleCheap Config via FelonyCrowbar");
        this.jLabel1.setText("Configuration Directory:");
        this.dataDirectory.setEditable(false);
        this.jButton1.setText("Browse...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PcRemoteConfigGUI.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/recur.png")));
        this.jButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PcRemoteConfigGUI.this.jButton2ActionPerformed(actionEvent);
            }
        });
        this.jLabel3.setText("Server:");
        this.toolConfigURL.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                PcRemoteConfigGUI.this.toolConfigURLCaretUpdate(caretEvent);
            }
        });
        this.isToolConfigValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.jLabel4.setText("Peddlecheap Version:");
        this.peddlecheapVersion.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                PcRemoteConfigGUI.this.peddlecheapVersionCaretUpdate(caretEvent);
            }
        });
        this.jLabel5.setText("Project Name:");
        this.projectName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                PcRemoteConfigGUI.this.projectNameCaretUpdate(caretEvent);
            }
        });
        this.jLabel6.setText("Username:");
        this.username.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                PcRemoteConfigGUI.this.usernameCaretUpdate(caretEvent);
            }
        });
        this.jLabel7.setText("Password:");
        this.jLabel8.setText("SID:");
        this.sid.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                PcRemoteConfigGUI.this.sidCaretUpdate(caretEvent);
            }
        });
        this.isVersionValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.isProjectNameValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.isUsernameValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.isPasswordValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.isSidValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.build.setText("Build");
        this.build.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PcRemoteConfigGUI.this.buildActionPerformed(actionEvent);
            }
        });
        this.currentStatus.setVerticalAlignment(1);
        this.currentStatus.setVerticalTextPosition(1);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.password).addComponent(this.peddlecheapVersion, -1, 147, Short.MAX_VALUE).addComponent(this.projectName, -1, 147, Short.MAX_VALUE).addComponent(this.username, -1, 147, Short.MAX_VALUE).addComponent(this.sid, -1, 147, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.isVersionValid).addComponent(this.isProjectNameValid).addComponent(this.isUsernameValid).addComponent(this.isPasswordValid).addComponent(this.isSidValid))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.toolConfigURL, -1, 345, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.isToolConfigValid)))).addGroup(groupLayout.createSequentialGroup().addComponent(this.currentStatus, -2, 376, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 39, Short.MAX_VALUE).addComponent(this.build)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataDirectory, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2))).addContainerGap()).addComponent(this.jSeparator2, -1, 492, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 492, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dataDirectory, -2, -1, -2).addComponent(this.jButton2).addComponent(this.jButton1)).addGap(11, 11, 11).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.toolConfigURL, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.peddlecheapVersion, -2, -1, -2).addComponent(this.isVersionValid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.projectName, -2, -1, -2).addComponent(this.isProjectNameValid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.username, -2, -1, -2).addComponent(this.isUsernameValid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.isPasswordValid).addComponent(this.password, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.sid, -2, -1, -2).addComponent(this.isSidValid))).addComponent(this.isToolConfigValid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.currentStatus, -1, 23, Short.MAX_VALUE).addComponent(this.build)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void toolConfigURLCaretUpdate(CaretEvent caretEvent) {
        this.validateData();
    }

    private void peddlecheapVersionCaretUpdate(CaretEvent caretEvent) {
        this.validateData();
    }

    private void projectNameCaretUpdate(CaretEvent caretEvent) {
        this.validateData();
    }

    private void usernameCaretUpdate(CaretEvent caretEvent) {
        this.validateData();
    }

    private void sidCaretUpdate(CaretEvent caretEvent) {
        this.validateData();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        String string = this.dataDirectory.getText().trim();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            file = jFileChooser.getSelectedFile();
            try {
                this.dataDirectory.setText(file.getCanonicalPath());
            }
            catch (Exception exception) {
                this.dataDirectory.setText(file.getAbsolutePath());
            }
        }
        this.isValidDirectory();
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        this.isValidDirectory();
    }

    private void buildActionPerformed(ActionEvent actionEvent) {
        try {
            this.remoteConfig.setHost(this.toolConfigURL.getText());
            this.remoteConfig.setVersion(this.peddlecheapVersion.getText());
            this.remoteConfig.setProject(this.projectName.getText());
            this.remoteConfig.setUser(this.username.getText());
            this.remoteConfig.setPassword(new String(this.password.getPassword()));
            this.remoteConfig.setSid(this.sid.getText());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        SwingWorker<Boolean, Object> swingWorker = new SwingWorker<Boolean, Object>(){
            Boolean retVal = Boolean.TRUE;
            String errorMsg = null;

            @Override
            protected Boolean doInBackground() throws Exception {
                try {
                    PcRemoteConfiguration.doConnection(PcRemoteConfigGUI.this.remoteConfig, PcRemoteConfigGUI.this.dataDirectory.getText(), new ActionOutput(){

                        @Override
                        public void action(final String string) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PcRemoteConfigGUI.this.currentStatus.setText(string);
                                }
                            });
                        }

                        @Override
                        public void error(String string) {
                            System.err.println(string);
                        }

                        @Override
                        public void status(final String string) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PcRemoteConfigGUI.this.currentStatus.setText(String.format("%s:  %s", PcRemoteConfigGUI.this.currentStatus.getText(), string));
                                }
                            });
                        }
                    });
                }
                catch (Exception exception) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PcRemoteConfigGUI.this.currentStatus.setText(exception.getMessage());
                        }
                    });
                    this.retVal = Boolean.FALSE;
                }
                return this.retVal;
            }

            @Override
            protected void done() {
                super.done();
                StringBuilder stringBuilder = new StringBuilder();
                ConfiguredImplant configuredImplant = PcRemoteConfigGUI.this.remoteConfig.getImplant();
                if (configuredImplant != null) {
                    if (configuredImplant.getMessages().size() > 0) {
                        stringBuilder.append(String.format("Felony Crowbar messages:\n", new Object[0]));
                        System.err.println("Felony Crowbar messages:\n");
                    }
                    for (FcMessage fcMessage : configuredImplant.getMessages()) {
                        stringBuilder.append(String.format("\t%d -- %s\n", fcMessage.getSeverity(), fcMessage.getMessage()));
                        System.err.printf("\t%d -- %s\n", fcMessage.getSeverity(), fcMessage.getMessage());
                    }
                }
                if (stringBuilder.length() > 0) {
                    String string3 = stringBuilder.toString();
                    string3 = string3.replaceAll("\n", "<br/>");
                    string3 = String.format("<html>%s</html>", string3);
                    JOptionPane.showMessageDialog(PcRemoteConfigGUI.this, new JLabel(string3), "Felony Crowbar Message", 2);
                }
                if (!this.retVal.booleanValue()) {
                    for (Component component : PcRemoteConfigGUI.this.listToDisable) {
                        component.setEnabled(true);
                    }
                }
                PcRemoteConfigGUI.this.jButton1.setEnabled(true);
                PcRemoteConfigGUI.this.jButton2.setEnabled(true);
            }
        };
        for (Component component : this.listToDisable) {
            component.setEnabled(false);
        }
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        swingWorker.execute();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new PcRemoteConfigGUI().setVisible(true);
                }
            });
        } else {
            PcRemoteConfiguration.main(new String[0]);
        }
    }
}

