/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Guid
implements Comparable<Guid> {
    private static final List<Guid> ALL_SORTED_GUIDS = new ArrayList<Guid>();
    public static final Guid NULL = Guid.GenerateGuid(BigInteger.ZERO);
    private final BigInteger value;

    public static Guid GenerateGuid(Guid other) {
        return other;
    }

    public static Guid GenerateGuid(String guid) {
        return Guid.GenerateGuid(new BigInteger(guid.replaceAll("-", ""), 16));
    }

    public static Guid GenerateGuid(BigInteger guid) {
        return Guid.addGuid(new Guid(guid));
    }

    private static synchronized Guid addGuid(Guid g) {
        int index = Collections.binarySearch(ALL_SORTED_GUIDS, g);
        if (index >= 0) {
            return ALL_SORTED_GUIDS.get(index);
        }
        ++index;
        if ((index = 0 - index) < ALL_SORTED_GUIDS.size()) {
            ALL_SORTED_GUIDS.add(index, g);
        } else {
            ALL_SORTED_GUIDS.add(g);
        }
        return g;
    }

    public Guid(BigInteger guid) {
        this.value = guid;
    }

    public String toString() {
        return Guid.convert(this.value);
    }

    public BigInteger asInteger() {
        return this.value;
    }

    public String asString() {
        return Guid.convert(this.value);
    }

    @Override
    public int compareTo(Guid o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        return this.value.compareTo(o.value);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Guid other = (Guid)obj;
        return this.value.equals(other.value);
    }

    public static String convert(BigInteger value) {
        if (value == null) {
            return null;
        }
        String input = String.format("%032x", value);
        return String.format("%s-%s-%s-%s", input.substring(0, 8), input.substring(8, 12), input.substring(12, 16), input.substring(16, 32));
    }
}

