/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QuotedStringTokenizer
extends StringTokenizer {
    private static final String __delim = "\t\n\r";
    private String _string;
    private String _delim = "\t\n\r";
    private boolean _returnQuotes = false;
    private boolean _returnTokens = false;
    private StringBuffer _token;
    private boolean _hasToken = false;
    private int _i = 0;
    private int _lastStart = 0;

    public QuotedStringTokenizer(String str, String delim, boolean returnTokens, boolean returnQuotes) {
        super("");
        this._string = str;
        if (delim != null) {
            this._delim = delim;
        }
        this._returnTokens = returnTokens;
        this._returnQuotes = returnQuotes;
        if (this._delim.indexOf(39) >= 0 || this._delim.indexOf(34) >= 0) {
            throw new Error("Can't use quotes as delimiters:  " + this._delim);
        }
        this._token = new StringBuffer(this._string.length() > 1024 ? 512 : this._string.length() / 2);
    }

    public QuotedStringTokenizer(String str, String delim, boolean returnTokens) {
        this(str, delim, returnTokens, false);
    }

    public QuotedStringTokenizer(String str, String delim) {
        this(str, delim, false, false);
    }

    public QuotedStringTokenizer(String str) {
        this(str, null, false, false);
    }

    public boolean hasMoreTokens() {
        if (this._hasToken) {
            return true;
        }
        this._lastStart = this._i;
        State state = State.Start;
        boolean escape = false;
        block6: while (this._i < this._string.length()) {
            char c = this._string.charAt(this._i++);
            switch (state) {
                case Start: {
                    if (this._delim.indexOf(c) >= 0) {
                        if (!this._returnTokens) continue block6;
                        this._token.append(c);
                        this._hasToken = true;
                        return true;
                    }
                    if (c == '\'') {
                        if (!this._returnQuotes) continue block6;
                        this._token.append(c);
                        state = State.SingleQuote;
                        continue block6;
                    }
                    if (c == '\"') {
                        if (!this._returnQuotes) continue block6;
                        this._token.append(c);
                        state = State.DoubleQuote;
                        continue block6;
                    }
                    this._token.append(c);
                    this._hasToken = true;
                    state = State.Token;
                    continue block6;
                }
                case Token: {
                    this._hasToken = true;
                    if (this._delim.indexOf(c) >= 0) {
                        if (!this._returnTokens) continue block6;
                        --this._i;
                        return this._hasToken;
                    }
                    if (c == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = State.SingleQuote;
                        continue block6;
                    }
                    if (c == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = State.DoubleQuote;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case SingleQuote: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        if (c == '\\') {
                            escape = true;
                        } else if (c != '\'' && c != '\"') {
                            this._token.append('\\');
                        }
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = State.Token;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case DoubleQuote: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        if (c == '\\') {
                            escape = true;
                        } else if (c != '\'' && c != '\"') {
                            this._token.append('\\');
                        }
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = State.Token;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
            }
        }
        return this._hasToken;
    }

    public String nextToken() throws NoSuchElementException {
        if (!this.hasMoreTokens() || this._token == null) {
            throw new NoSuchElementException();
        }
        String t = this._token.toString();
        this._token.setLength(0);
        this._hasToken = false;
        return t;
    }

    public String nextToken(String delim) throws NoSuchElementException {
        this._delim = delim;
        this._i = this._lastStart;
        this._token.setLength(0);
        this._hasToken = false;
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    public int countTokens() {
        return -1;
    }

    public static String quote(String s, String delim) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "\"\"";
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\"' && c != '\\' && c != '\'' && delim.indexOf(c) < 0) continue;
            StringBuffer b = new StringBuffer(s.length() + 8);
            QuotedStringTokenizer.quote(b, s);
            return b.toString();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quote(StringBuffer buf, String s) {
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            buf.append('\"');
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"') {
                    buf.append("\\\"");
                    continue;
                }
                if (c == '\\') {
                    buf.append("\\\\");
                    continue;
                }
                buf.append(c);
            }
            buf.append('\"');
        }
    }

    public static String unquote(String s) {
        char last;
        if (s == null) {
            return null;
        }
        if (s.length() < 2) {
            return s;
        }
        char first = s.charAt(0);
        if (first != (last = s.charAt(s.length() - 1)) || first != '\"' && first != '\'') {
            return s;
        }
        StringBuffer b = new StringBuffer(s.length() - 2);
        boolean quote = false;
        for (int i = 1; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if (c == '\\' && !quote) {
                quote = true;
                continue;
            }
            quote = false;
            b.append(c);
        }
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        Start,
        Token,
        SingleQuote,
        DoubleQuote;

    }
}

