/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StreamingXMLReader
implements XMLStreamReader {
    private InputStream inputStream;
    XMLStreamReader child = null;
    int level = 0;
    String root = null;
    boolean finished = false;
    boolean sentEndDoc = false;

    public String getCurrentNode() throws XMLStreamException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getCurrentNodeHelper());
        return sb.toString();
    }

    private StringBuffer getCurrentNodeHelper() throws XMLStreamException {
        StringBuffer results = new StringBuffer();
        if (this.isStartElement()) {
            results.append("<" + this.getName().getLocalPart());
            for (int i = 0; i < this.getAttributeCount(); ++i) {
                String name = this.getAttributeLocalName(i);
                String value = this.getAttributeValue(i);
                results.append(" " + StreamingXMLReader.xmlify(name) + "=\"" + StreamingXMLReader.xmlify(value) + "\"");
            }
            results.append(">");
            if (!this.isEndElement()) {
                this.next();
                while (!this.isEndElement()) {
                    while (!this.hasNext()) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(250L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    results.append(this.getCurrentNodeHelper());
                    this.next();
                }
            }
            results.append("</" + this.getName().getLocalPart() + ">");
        } else if (this.isCharacters()) {
            results.append(StreamingXMLReader.xmlify(this.getText()));
        } else if (this.isEndElement()) {
            // empty if block
        }
        return results;
    }

    public static String xmlify(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\"", "&quot;");
        return str;
    }

    public boolean hasName() {
        return this.child.hasName();
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.finished) {
            return !this.sentEndDoc;
        }
        return this.child.hasNext();
    }

    public int next() throws XMLStreamException {
        int res;
        if (this.finished) {
            this.sentEndDoc = true;
            return 8;
        }
        while (!this.hasNext()) {
            try {
                TimeUnit.MILLISECONDS.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        try {
            res = this.child.next();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMLStreamException("Unknown error?!");
        }
        if (res == 1) {
            System.err.println(this.child.getLocalName());
            ++this.level;
        } else if (res == 2) {
            --this.level;
        }
        if (this.root == null && res == 1) {
            this.root = this.child.getName().toString();
        } else if (this.root != null && res == 2 && this.level == 0) {
            String s = this.child.getName().toString();
            if (s.equals(this.root)) {
                this.finished = true;
            }
            return res;
        }
        return res;
    }

    public int nextTag() throws XMLStreamException {
        if (this.finished) {
            this.sentEndDoc = true;
            return 8;
        }
        int res = this.child.nextTag();
        if (res == 1) {
            ++this.level;
        } else if (res == 2) {
            --this.level;
        }
        if (this.root == null && res == 1) {
            this.root = this.child.getName().toString();
        } else if (this.root != null && res == 2 && this.level == 0) {
            String s = this.child.getName().toString();
            if (s.equals(this.root)) {
                this.finished = true;
            }
            return res;
        }
        if (this.level <= 0) {
            throw new XMLStreamException("Invalid document!");
        }
        return res;
    }

    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        this.child.require(arg0, arg1, arg2);
    }

    public StreamingXMLReader(InputStream is) throws XMLStreamException {
        this.inputStream = is;
        if (is == null) {
            throw new NullPointerException("Parameter 'is' cannot be null!");
        }
        this.child = StreamingXMLReader.createXMLStreamReader(this.inputStream);
    }

    public void close() throws XMLStreamException {
        this.child.close();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamingXMLReader other = (StreamingXMLReader)obj;
        return !(this.child == null ? other.child != null : !this.child.equals(other.child));
    }

    public int getAttributeCount() {
        return this.child.getAttributeCount();
    }

    public String getAttributeLocalName(int arg0) {
        return this.child.getAttributeLocalName(arg0);
    }

    public QName getAttributeName(int arg0) {
        return this.child.getAttributeName(arg0);
    }

    public String getAttributeNamespace(int arg0) {
        return this.child.getAttributeNamespace(arg0);
    }

    public String getAttributePrefix(int arg0) {
        return this.child.getAttributePrefix(arg0);
    }

    public String getAttributeType(int arg0) {
        return this.child.getAttributeType(arg0);
    }

    public String getAttributeValue(int arg0) {
        return this.child.getAttributeValue(arg0);
    }

    public String getAttributeValue(String arg0, String arg1) {
        return this.child.getAttributeValue(arg0, arg1);
    }

    public String getCharacterEncodingScheme() {
        return this.child.getCharacterEncodingScheme();
    }

    public String getElementText() throws XMLStreamException {
        return this.child.getElementText();
    }

    public String getEncoding() {
        return this.child.getEncoding();
    }

    public int getEventType() {
        return this.child.getEventType();
    }

    public String getLocalName() {
        return this.child.getLocalName();
    }

    public Location getLocation() {
        return this.child.getLocation();
    }

    public QName getName() {
        return this.child.getName();
    }

    public NamespaceContext getNamespaceContext() {
        return this.child.getNamespaceContext();
    }

    public int getNamespaceCount() {
        return this.child.getNamespaceCount();
    }

    public String getNamespacePrefix(int arg0) {
        return this.child.getNamespacePrefix(arg0);
    }

    public String getNamespaceURI() {
        return this.child.getNamespaceURI();
    }

    public String getNamespaceURI(int arg0) {
        return this.child.getNamespaceURI(arg0);
    }

    public String getNamespaceURI(String arg0) {
        return this.child.getNamespaceURI(arg0);
    }

    public String getPIData() {
        return this.child.getPIData();
    }

    public String getPITarget() {
        return this.child.getPITarget();
    }

    public String getPrefix() {
        return this.child.getPrefix();
    }

    public Object getProperty(String arg0) throws IllegalArgumentException {
        return this.child.getProperty(arg0);
    }

    public String getText() {
        return this.child.getText();
    }

    public char[] getTextCharacters() {
        return this.child.getTextCharacters();
    }

    public int getTextCharacters(int arg0, char[] arg1, int arg2, int arg3) throws XMLStreamException {
        return this.child.getTextCharacters(arg0, arg1, arg2, arg3);
    }

    public int getTextLength() {
        return this.child.getTextLength();
    }

    public int getTextStart() {
        return this.child.getTextStart();
    }

    public String getVersion() {
        return this.child.getVersion();
    }

    public boolean hasText() {
        return this.child.hasText();
    }

    public boolean isAttributeSpecified(int arg0) {
        return this.child.isAttributeSpecified(arg0);
    }

    public boolean isCharacters() {
        return this.child.isCharacters();
    }

    public boolean isEndElement() {
        return this.child.isEndElement();
    }

    public boolean isStandalone() {
        return this.child.isStandalone();
    }

    public boolean isStartElement() {
        return this.child.isStartElement();
    }

    public boolean isWhiteSpace() {
        return this.child.isWhiteSpace();
    }

    public boolean standaloneSet() {
        return this.child.standaloneSet();
    }

    public String toString() {
        return this.child.toString();
    }

    private static XMLStreamReader createXMLStreamReader(InputStream is) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xsr = factory.createXMLStreamReader(is);
            return xsr;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return null;
        }
    }
}

