/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.filemanager.ver3.browser;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SortingTableHeader {
    public static final String upIcon = "images/up.png";
    public static final String downIcon = "images/down.png";
    boolean ascending = true;
    TableColumn storedColumn;
    SortingTableHeaderCallback callback;

    public SortingTableHeader(SortingTableHeaderCallback sortingTableHeaderCallback) {
        this.callback = sortingTableHeaderCallback;
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final SortingTableHeader sortingTableHeader = this;
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() != 1) {
                    return;
                }
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = jTable2.columnAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                SortingTableHeader.this.setSortingColumn(tableColumnModel.getColumn(n), jTable2, sortingTableHeader);
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    void setSortingColumn(TableColumn tableColumn, JTable jTable, SortingTableHeader sortingTableHeader) {
        Serializable serializable;
        if (this.storedColumn != null) {
            this.storedColumn.setHeaderRenderer(null);
        }
        if (tableColumn == null) {
            return;
        }
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        tableColumn.setHeaderRenderer(defaultTableCellRenderer);
        if (tableColumn == this.storedColumn) {
            boolean bl = this.ascending = !this.ascending;
            if (this.ascending) {
                this.setNoSort();
                this.storedColumn = null;
                return;
            }
        } else {
            this.storedColumn = tableColumn;
            this.ascending = true;
            serializable = new ImageIcon(this.getClass().getClassLoader().getResource(upIcon));
            defaultTableCellRenderer.setIcon((Icon)((Object)serializable));
        }
        if (this.ascending) {
            serializable = new ImageIcon(this.getClass().getClassLoader().getResource(downIcon));
            defaultTableCellRenderer.setIcon((Icon)((Object)serializable));
        } else {
            serializable = new ImageIcon(this.getClass().getClassLoader().getResource(upIcon));
            defaultTableCellRenderer.setIcon((Icon)((Object)serializable));
        }
        defaultTableCellRenderer.setIconTextGap(10);
        serializable = jTable.getSelectionBackground();
        Color color = jTable.getSelectionForeground();
        defaultTableCellRenderer.setBackground((Color)serializable);
        defaultTableCellRenderer.setForeground(color);
        defaultTableCellRenderer.setHorizontalAlignment(0);
        defaultTableCellRenderer.setHorizontalTextPosition(2);
        this.callback.setSorting(this.storedColumn, this.ascending);
    }

    public void setNoSort() {
        this.setSortingColumn(null, null, null);
    }

    public static interface SortingTableHeaderCallback {
        public void setSorting(TableColumn var1, boolean var2);
    }
}

