/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.filemanager.ver3.search;

import ddb.dsz.plugin.filemanager.ver3.search.SearchResultColumns;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileObjectFields;
import ddb.targetmodel.filemodel.FileSystemModel;
import ddb.util.AbstractEnumeratedTableModel;
import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultModel
extends AbstractEnumeratedTableModel<SearchResultColumns> {
    static final long DELAY = 1500L;
    static final TimeUnit UNIT = TimeUnit.MILLISECONDS;
    public static final Integer IS_DIR = -1;
    List<Long> ids = new ArrayList<Long>();
    List<Reference<FileObject>> files = new ArrayList<Reference<FileObject>>();
    int size = 0;
    FileSystemModel model;
    final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    final Lock READ = this.LOCK.readLock();
    final Lock WRITE = this.LOCK.writeLock();

    public SearchResultModel(FileSystemModel fileSystemModel) {
        super(SearchResultColumns.class);
        this.model = fileSystemModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        this.READ.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.READ.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFileObjectAt(int n) {
        this.READ.lock();
        try {
            Object object;
            Reference<FileObject> reference = this.files.get(n);
            if (reference != null && (object = reference.get()) != null) {
                Object object2 = object;
                return object2;
            }
            object = this.ids.get(n);
            return object;
        }
        finally {
            this.READ.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(final int n, SearchResultColumns searchResultColumns) {
        List<Reference<FileObject>> list;
        if (n < 0) {
            return null;
        }
        long l = -2L;
        FileObject fileObject = null;
        this.READ.lock();
        try {
            if (n >= this.size) {
                Object var8_5 = null;
                return var8_5;
            }
            List<Long> list2 = this.ids;
            list = this.files;
            l = list2.get(n);
            Reference<FileObject> reference = list.get(n);
            if (reference != null) {
                fileObject = reference.get();
            }
        }
        finally {
            this.READ.unlock();
        }
        if (fileObject == null) {
            fileObject = new FileObject(this.model, l);
            this.WRITE.lock();
            try {
                list.set(n, new SoftReference<FileObject>(fileObject));
            }
            finally {
                this.WRITE.unlock();
            }
            this.model.retrieveFileInformation(fileObject, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SearchResultModel.this.READ.lock();
                    try {
                        if (n >= SearchResultModel.this.size) {
                            return;
                        }
                    }
                    finally {
                        SearchResultModel.this.READ.unlock();
                    }
                    EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsUpdated((AbstractEnumeratedTableModel)SearchResultModel.this, n, n));
                }
            });
            this.model.getPath(fileObject);
            return null;
        }
        try {
            switch (searchResultColumns) {
                case Accessed: {
                    return fileObject.getDataElement(FileObjectFields.File_Accessed).getValue();
                }
                case Created: {
                    return fileObject.getDataElement(FileObjectFields.File_Created).getValue();
                }
                case Modified: {
                    return fileObject.getDataElement(FileObjectFields.File_Modified).getValue();
                }
                case Name: {
                    return fileObject;
                }
                case Size: {
                    if (fileObject.isDirectory()) {
                        return IS_DIR;
                    }
                    return fileObject.getDataElement(FileObjectFields.File_Size).getValue();
                }
                case Path: {
                    return fileObject.getPath();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Class<?> getColumnClass(SearchResultColumns searchResultColumns) {
        switch (searchResultColumns) {
            case Accessed: 
            case Created: 
            case Modified: {
                return Calendar.class;
            }
            case Name: {
                return FileObject.class;
            }
            case Size: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileChanged(FileObject fileObject) {
        int n = -1;
        this.READ.lock();
        try {
            for (int i = 0; i < this.size; ++i) {
                if (!fileObject.getId().equals(this.ids.get(i))) continue;
                this.files.set(i, null);
                n = i;
                break;
            }
        }
        finally {
            this.READ.unlock();
        }
        if (n != -1) {
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsUpdated((AbstractEnumeratedTableModel)this, n, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(FileObject fileObject) {
        int n = -1;
        this.WRITE.lock();
        try {
            n = this.size++;
            this.ids.add(fileObject.getId());
            this.files.add(new SoftReference<FileObject>(fileObject));
        }
        finally {
            this.WRITE.unlock();
        }
        if (n >= 0) {
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsInserted((AbstractEnumeratedTableModel)this, n, n));
        }
        this.model.getPath(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.WRITE.lock();
        try {
            this.ids = new ArrayList<Long>();
            this.files = new ArrayList<Reference<FileObject>>();
            this.size = 0;
        }
        finally {
            this.WRITE.unlock();
        }
        EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableDataChanged((AbstractEnumeratedTableModel)this));
    }
}

