/*
 * Decompiled with CFR 0.152.
 */
package felonycrowbar;

import felonycrowbar.Key;
import felonycrowbar.PeddleCheapConfiguration;
import felonycrowbar.jaxb.ObjectFactory;
import felonycrowbar.jaxb.PCDumpType;
import felonycrowbar.jaxb.ProjectType;
import felonycrowbar.webservice.FcSearch;
import felonycrowbar.webservice.FcSearchService;
import felonycrowbar.webservice.ImplantRecord;
import felonycrowbar.webservice.Property;
import felonycrowbar.webservice.SearchCriteria;
import felonycrowbar.webservice.SearchResult;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class FelonyCrowbarQuery {
    public static final String HELP = "-help";
    public static final String VERSION = "1.0.0.1";
    public static final String USERNAME = "-username";
    public static final String PASSWORD = "-password";
    public static final String HOST = "-host";
    public static final String PORT = "-port";
    public static final String PROJECT = "-project";
    public static final String OUTPUT = "-output";
    public static final String KEYDIR = "-keydir";
    String username;
    String password;
    String host = "http://webserver1.developer.net";
    String output = "FC_Dump.xml";
    String keyDir = ".";
    int port = 8080;
    boolean fail = false;
    List<String> projects = new Vector<String>();

    public static void main(String ... args) {
        try {
            new FelonyCrowbarQuery(args).go();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private FelonyCrowbarQuery(String ... args) {
        for (String s : args) {
            if (this.parseArgument(s)) continue;
            System.err.println("Unable to parse argument " + s);
            this.fail = true;
            return;
        }
    }

    private boolean parseArgument(String s) {
        if (s.equals("?") || s.equalsIgnoreCase(HELP)) {
            this.doHelp();
        }
        if (!s.contains("=")) {
            return false;
        }
        String[] parts = s.split("=", 2);
        if (parts.length != 2) {
            return false;
        }
        if (parts[0].equalsIgnoreCase(USERNAME)) {
            this.username = parts[1];
        } else if (parts[0].equalsIgnoreCase(PASSWORD)) {
            this.password = parts[1];
        } else if (parts[0].equalsIgnoreCase(HOST)) {
            this.host = parts[1];
        } else if (parts[0].equalsIgnoreCase(PORT)) {
            try {
                this.port = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else if (parts[0].equalsIgnoreCase(PROJECT)) {
            this.projects.add(parts[1]);
        } else if (parts[0].equalsIgnoreCase(OUTPUT)) {
            this.output = parts[1];
        } else if (parts[0].equalsIgnoreCase(KEYDIR)) {
            this.keyDir = parts[1];
        } else {
            return false;
        }
        return true;
    }

    private void doHelp() {
        System.out.println("FelonyCrowbarQuery <-username=...> <-password=...> <-output=...> <-host=...> <-port=...> <-project=...> <-keydir=...>");
        System.out.println("\t<-username=...>  The username to log onto FelonyCrowbar");
        System.out.println("\t<-password=...>  The password to log onto FelonyCrowbar");
        System.out.println("\t<-output=...>  The destination path and file [default=FC_Dump.xml]");
        System.out.println("\t<-host=...>  The location of the FelonyCrowbar server");
        System.out.println("\t<-port=...>  The port on the FelonyCrowbar server");
        System.out.println("\t<-project=...>  The project(s) to retrieve.");
        System.out.println("\t<-keydir=...>  The directory in which to store the keys");
        System.out.println("\t\tThere must be at least one -project argument, but there is no maximum");
        System.exit(-1);
    }

    public void go() throws ParserConfigurationException, TransformerException, MalformedURLException, JAXBException {
        if (this.fail) {
            this.doHelp();
            return;
        }
        URL destination = new URL(String.format("%s:%d/%s", this.host, this.port, "FcSearchImplService/FcSearchImpl?wsdl"));
        File outputFile = new File(this.output);
        JAXBContext context = JAXBContext.newInstance("felonycrowbar.jaxb");
        ObjectFactory of = new ObjectFactory();
        PCDumpType dump = new PCDumpType();
        for (String project : this.projects) {
            ProjectType projType = new ProjectType();
            projType.setName(project);
            dump.getProject().add(projType);
            this.log("Retrieving for " + project);
            SearchCriteria criteria = new SearchCriteria();
            criteria.setProjectName(project);
            criteria.setImplantType("PeddleCheap");
            FcSearchService searcherService = new FcSearchService(destination, new QName("felonycrowbar/webservice", "FcSearchService"));
            FcSearch searcher = searcherService.getFcSearchPort();
            this.log("Searching");
            SearchResult result = searcher.fcSearch(this.username, this.password, criteria);
            this.log("Parsing Results");
            Vector<PeddleCheapConfiguration> pcs = new Vector<PeddleCheapConfiguration>();
            Key.clearKeys();
            for (ImplantRecord ir : result.getImplantRecords()) {
                if (ir.getProjectName() == null || ir.getImplantType() == null) continue;
                pcs.add(new PeddleCheapConfiguration(ir));
            }
            File keyFile = new File(this.keyDir);
            this.log("Writing keys into " + keyFile.getAbsolutePath());
            Key.writeKeys(keyFile, project);
            Collections.sort(pcs, new Comparator<PeddleCheapConfiguration>(){

                @Override
                public int compare(PeddleCheapConfiguration o1, PeddleCheapConfiguration o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    if (o1.configDate == null && o2.configDate == null) {
                        return 0;
                    }
                    if (o1.configDate == null) {
                        return 1;
                    }
                    if (o2.configDate == null) {
                        return -1;
                    }
                    return o1.configDate.compare(o2.configDate);
                }
            });
            for (PeddleCheapConfiguration pc : pcs) {
                projType.getTarget().add(pc.createXmlObject());
            }
        }
        this.log("Saving to " + outputFile.getAbsolutePath());
        Marshaller marsh = context.createMarshaller();
        marsh.setProperty("jaxb.encoding", "UTF-8");
        marsh.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marsh.marshal(of.createPCDump(dump), outputFile);
    }

    void addCriteria(SearchCriteria criteria, String key, String value) {
        Property prop = new Property();
        prop.setKey(key);
        prop.setValue(value);
        criteria.getConfigProperties().add(prop);
    }

    void log(String message) {
        System.out.printf("    [ FcQuery ] %s\n", message);
    }
}

