/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.taskmanager.processinformation.module;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ObjectValue;

public class Module {
    final Long baseAddress;
    final Long imageSize;
    final Long entryPoint;
    final String name;
    final String[] hashes;
    final CoreController core;

    public Module(ObjectValue module, CoreController cc) {
        this.baseAddress = module.getInteger("baseaddress");
        this.imageSize = module.getInteger("imagesize");
        this.entryPoint = module.getInteger("entrypoint");
        String n = module.getString("modulename");
        this.hashes = new String[Hash.values().length];
        for (ObjectValue ov : module.getObjects("checksum")) {
            String value = ov.getString("value");
            Hash h = Hash.getHash(ov.getString("type"));
            if (h == null) continue;
            this.hashes[h.ordinal()] = value;
        }
        this.name = n == null || n.length() == 0 ? " " : n;
        this.core = cc;
    }

    public Module(CoreController core, long baseAddress, long imageSize, long entryPoint, String name, String[] hashes) {
        this.core = core;
        this.baseAddress = baseAddress;
        this.imageSize = imageSize;
        this.entryPoint = entryPoint;
        this.name = name;
        this.hashes = hashes;
    }

    public Long getBaseAddress() {
        return this.baseAddress;
    }

    public Long getImageSize() {
        return this.imageSize;
    }

    public Long getEntryPoint() {
        return this.entryPoint;
    }

    public String getName() {
        return this.name;
    }

    public String getHash(Hash h) {
        return this.hashes[h.ordinal()];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hash {
        MD5("MD5"),
        SHA1("SHA1"),
        SHA256("SHA256"),
        SHA512("SHA512");

        public final String key;

        private Hash(String k) {
            this.key = k;
        }

        public static Hash getHash(String str) {
            for (Hash h : Hash.values()) {
                if (!h.key.equalsIgnoreCase(str)) continue;
                return h;
            }
            return null;
        }
    }
}

