/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.taskmanager.renderers;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.taskmanager.TaskManagerOptions;
import ddb.dsz.plugin.taskmanager.processinformation.ProcessInformation;
import ddb.dsz.plugin.taskmanager.renderers.ProcessBasicRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class ProcessShadingRenderer
extends ProcessBasicRenderer {
    public ProcessShadingRenderer(CoreController core, TableModel model, TaskManagerOptions options) {
        super(core, model, options);
    }

    public Component getTableCellRendererComponent(JTable jtable, Object o, boolean bln, boolean bln1, int row, int column) {
        Component c = super.getTableCellRendererComponent(jtable, o, bln, bln1, row, column);
        ProcessInformation procInfo = this.getProcessInformation(jtable, row);
        if (c instanceof JLabel && procInfo != null) {
            JLabel label = (JLabel)JLabel.class.cast(c);
            Color col = Color.BLACK;
            switch (procInfo.getType()) {
                case CORE_OS: {
                    col = this.options.coreOsColor;
                    break;
                }
                case MALICIOUS_SOFTWARE: {
                    col = this.options.maliceColor;
                    break;
                }
                case SAFE: {
                    col = this.options.safeColor;
                    break;
                }
                case SECURITY_PRODUCT: {
                    col = this.options.secProdColor;
                    break;
                }
                case NONE: {
                    col = this.options.unknownColor;
                }
            }
            label.setForeground(col);
        }
        return c;
    }
}

