/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.logviewer.LogViewer;
import ddb.dsz.plugin.multitarget.MultipleTargetWorkbench;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import javax.swing.JTabbedPane;

final class TabPopUpListener
extends MouseAdapter {
    private final LogViewer _viewer;
    private final CoreController core;

    TabPopUpListener(LogViewer viewer, CoreController core) {
        this._viewer = viewer;
        this.core = core;
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        try {
            MultipleTargetWorkbench tabPane;
            int tabIndex;
            if (e.isPopupTrigger() && ((tabIndex = (tabPane = this._viewer.getWorkbench()).getUI().tabForCoordinate((JTabbedPane)tabPane, e.getX(), e.getY())) < 0 || tabIndex >= tabPane.getTabCount())) {
                return;
            }
        }
        catch (Throwable e1) {
            e1.printStackTrace();
            this.core.logEvent(Level.SEVERE, "Can't show popup", e1);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.maybeShowPopup(e);
    }
}

