/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer.gui.detail;

import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.plugin.logviewer.gui.detail.ValueTableColumns;
import ddb.util.AbstractEnumeratedTableModel;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueTableModel
extends AbstractEnumeratedTableModel<ValueTableColumns> {
    ObjectValue current;
    List<List<Object>> dataVector = new Vector<List<Object>>();

    ValueTableModel() {
        super(ValueTableColumns.class);
    }

    public String getColumnName(ValueTableColumns column) {
        return column.getName();
    }

    void setCurrent(ObjectValue newCurrent) {
        this.current = newCurrent;
        this.regenerate();
        this.fireTableDataChanged();
    }

    void regenerate() {
        this.dataVector.clear();
        if (this.current == null) {
            return;
        }
        for (String s : this.current.getBooleanNames()) {
            for (Object b : this.current.getBooleans(s)) {
                this.addRow(Boolean.class.getSimpleName(), s, b);
            }
        }
        for (String s : this.current.getIntegerNames()) {
            for (Object b : this.current.getIntegers(s)) {
                this.addRow(Long.class.getSimpleName(), s, b);
            }
        }
        for (String s : this.current.getStringNames()) {
            for (Object b : this.current.getStrings(s)) {
                this.addRow(String.class.getSimpleName(), s, b);
            }
        }
    }

    private void addRow(String type, String key, Object value) {
        Vector<Object> newRow = new Vector<Object>();
        newRow.add(type);
        newRow.add(key);
        newRow.add(value);
        this.dataVector.add(newRow);
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public Object getValueAt(int rowIndex, ValueTableColumns columnIndex) {
        List<Object> row = this.dataVector.get(rowIndex);
        return row.get(columnIndex.ordinal());
    }
}

