/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer.gui.screenlog;

import ddb.dsz.plugin.logviewer.gui.screenlog.ScreenLogColumns;
import ddb.util.AbstractEnumeratedTableModel;
import java.awt.EventQueue;
import java.io.File;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenLogModel
extends AbstractEnumeratedTableModel<ScreenLogColumns> {
    List<Record> data = new Vector<Record>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock READ = this.lock.readLock();
    private final Lock WRITE = this.lock.writeLock();
    final Pattern timestampPattern = Pattern.compile(".*_([0-9]{4})_([0-9]{2})_([0-9]{2})_([0-9]{2})h([0-9]{2})m([0-9]{2})s.([0-9]{3}).dsz");

    public ScreenLogModel() {
        super(ScreenLogColumns.class);
    }

    public Class<?> getColumnClass(ScreenLogColumns column) {
        return column.getType();
    }

    public String getColumnName(ScreenLogColumns column) {
        return column.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int rowIndex, ScreenLogColumns column) {
        if (rowIndex < 0) {
            return null;
        }
        this.READ.lock();
        try {
            if (rowIndex >= this.data.size()) {
                Object var3_3 = null;
                return var3_3;
            }
            Record r = this.data.get(rowIndex);
            if (r == null) {
                Object var4_5 = null;
                return var4_5;
            }
            switch (column) {
                case FILENAME: {
                    File file = r.file;
                    return file;
                }
                case TIMESTAMP: {
                    Calendar calendar = this.getTimestamp(r.file);
                    return calendar;
                }
                case SIZE: {
                    Long l = r.lastSize;
                    return l;
                }
            }
            Object var4_9 = null;
            return var4_9;
        }
        finally {
            this.READ.unlock();
        }
    }

    private Calendar getTimestamp(File file) {
        Matcher m = this.timestampPattern.matcher(file.getName());
        try {
            if (m.matches()) {
                Calendar cal = Calendar.getInstance();
                cal.set(1, Integer.parseInt(m.group(1)));
                cal.set(2, Integer.parseInt(m.group(2)) - 1);
                cal.set(5, Integer.parseInt(m.group(3)));
                cal.set(11, Integer.parseInt(m.group(4)));
                cal.set(12, Integer.parseInt(m.group(5)));
                cal.set(13, Integer.parseInt(m.group(6)));
                cal.set(14, Integer.parseInt(m.group(7)));
                return cal;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        this.READ.lock();
        try {
            int n = this.data.size();
            return n;
        }
        finally {
            this.READ.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFile(File f) {
        if (f.length() == 0L) {
            return;
        }
        int update = -1;
        int add = -1;
        this.WRITE.lock();
        try {
            for (int i = 0; i < this.data.size(); ++i) {
                Record r = this.data.get(i);
                if (!r.file.equals(f)) continue;
                update = i;
                r.lastSize = f.length();
            }
            if (update == -1) {
                Record newRecord = new Record();
                newRecord.file = f;
                newRecord.lastSize = f.length();
                for (int i = 0; i < this.data.size(); ++i) {
                    Record oldRecord = this.data.get(i);
                    if (oldRecord.file.compareTo(newRecord.file) <= 0) continue;
                    add = i;
                    this.data.add(i, newRecord);
                    break;
                }
                if (add == -1) {
                    add = this.data.size();
                    this.data.add(newRecord);
                }
            }
        }
        finally {
            this.WRITE.unlock();
        }
        if (update != -1) {
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableCellUpdated((AbstractEnumeratedTableModel)this, update, (Enum)ScreenLogColumns.SIZE));
        } else if (add != -1) {
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsInserted((AbstractEnumeratedTableModel)this, add, add));
        }
    }

    private class Record {
        File file;
        long lastSize;

        private Record() {
        }
    }
}

