/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.text.DecimalFormat;

public class ByteUtils {
    public static final String classVersion = "2.2";
    public static final int ASCII = 1;
    public static final int BINARY = 2;
    public static final int DECIMAL = 10;
    public static final int HEX = 16;
    protected static final DecimalFormat DDD = new DecimalFormat("000");
    protected static final DecimalFormat DDDDD = new DecimalFormat("00000");
    protected static final String NEWLINE = System.getProperty("line.separator");
    private static final String[] nibbleString = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
    protected static final String[] hexDigit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    protected static final byte[] reverseBits = new byte[]{0, 8, 4, 12, 2, 10, 6, 14, 1, 9, 5, 13, 3, 11, 7, 15};

    public static void appendBinaryString(byte value, StringBuffer buffer) {
        byte a = (byte)(value >> 4 & 0xF);
        byte b = (byte)(value & 0xF);
        buffer.append(nibbleString[a]);
        buffer.append(nibbleString[b]);
    }

    public static void appendDecimalString(byte value, StringBuffer buffer) {
        buffer.append(DDD.format(value & 0xFF));
    }

    protected static void appendEmptyValue(int radix, StringBuffer buffer) {
        switch (radix) {
            case 1: {
                buffer.append(' ');
                break;
            }
            case 2: {
                buffer.append("        ");
                break;
            }
            case 10: {
                buffer.append("   ");
                break;
            }
            default: {
                buffer.append("  ");
            }
        }
    }

    public static void appendHexString(byte value, StringBuffer buffer) {
        byte a = (byte)(value >> 4 & 0xF);
        byte b = (byte)(value & 0xF);
        buffer.append(hexDigit[a]);
        buffer.append(hexDigit[b]);
    }

    public static void appendValue(byte value, int radix, StringBuffer buffer) {
        switch (radix) {
            case 1: {
                buffer.append(value >= 32 && value <= 126 ? (char)value : (char)' ');
                break;
            }
            case 2: {
                ByteUtils.appendBinaryString(value, buffer);
                break;
            }
            case 10: {
                ByteUtils.appendDecimalString(value, buffer);
                break;
            }
            default: {
                ByteUtils.appendHexString(value, buffer);
            }
        }
    }

    public static byte bitReverse(byte value) {
        byte a = reverseBits[(byte)((value & 0xF0) >> 4)];
        byte b = reverseBits[value & 0xF];
        return (byte)(b << 4 ^ a);
    }

    public static short bitReverse(short value) {
        byte a = ByteUtils.bitReverse((byte)(value >> 8 & 0xFF));
        byte b = ByteUtils.bitReverse((byte)(value & 0xFF));
        return (short)(a << 8 ^ b & 0xFF);
    }

    public static int bitReverse(int value) {
        short a = ByteUtils.bitReverse((short)(value >> 16 & 0xFFFF));
        short b = ByteUtils.bitReverse((short)(value & 0xFFFF));
        return a << 16 ^ b & 0xFFFF;
    }

    public static long bitReverse(long value) {
        int a = ByteUtils.bitReverse((int)(value >> 32 & 0xFFFFFFFFL));
        int b = ByteUtils.bitReverse((int)(value & 0xFFFFFFFFL));
        return (long)a << 32 ^ (long)b & 0xFFFFFFFFL;
    }

    public static short byteReverse(short value) {
        int a = value >> 8 & 0xFF;
        int b = (value & 0xFF) << 8;
        return (short)(b ^ a);
    }

    public static int byteReverse(int value) {
        int a = value >> 24 & 0xFF;
        int b = value >> 8 & 0xFF00;
        int c = value << 8 & 0xFF0000;
        int d = value << 24 & 0xFF000000;
        return d ^ c ^ b ^ a;
    }

    public static long byteReverse(long value) {
        int a = ByteUtils.byteReverse((int)(value >> 32 & 0xFFFFFFFFL));
        int b = ByteUtils.byteReverse((int)(value & 0xFFFFFFFFL));
        return (long)b << 32 ^ (long)a & 0xFFFFFFFFL;
    }

    public static final String dump(byte[] b, int radix, int perLine, int offset, int length) {
        int i;
        if (b == null || b.length == 0 || length == 0) {
            return "";
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be negative: " + length);
        }
        if (perLine < 1) {
            throw new IllegalArgumentException("Per-line must be positive: " + perLine);
        }
        int start = offset - offset % perLine;
        int end = offset + length;
        StringBuffer buffer = new StringBuffer();
        StringBuffer line = new StringBuffer();
        StringBuffer ascii = new StringBuffer();
        line.append(DDDDD.format(start));
        line.append("  ");
        if (start >= offset) {
            ByteUtils.appendValue(b[start], radix, line);
            ByteUtils.appendValue(b[start], 1, ascii);
        } else {
            ByteUtils.appendEmptyValue(radix, line);
            ByteUtils.appendEmptyValue(1, ascii);
        }
        for (i = start + 1; i < start + perLine; ++i) {
            line.append(' ');
            if (i < offset || i >= end) {
                ByteUtils.appendEmptyValue(radix, line);
                ByteUtils.appendEmptyValue(1, ascii);
                continue;
            }
            ByteUtils.appendValue(b[i], radix, line);
            ByteUtils.appendValue(b[i], 1, ascii);
        }
        line.append("  ");
        line.append(ascii.toString());
        buffer.append(line.toString().trim());
        ascii.setLength(0);
        line.setLength(0);
        for (i = start + perLine; i < end; i += perLine) {
            buffer.append(NEWLINE);
            line.append(DDDDD.format(i));
            line.append("  ");
            if (i < end) {
                ByteUtils.appendValue(b[i], radix, line);
                ByteUtils.appendValue(b[i], 1, ascii);
            } else {
                ByteUtils.appendEmptyValue(radix, line);
                ByteUtils.appendEmptyValue(1, ascii);
            }
            for (int j = i + 1; j < i + perLine; ++j) {
                line.append(' ');
                if (j < end) {
                    ByteUtils.appendValue(b[j], radix, line);
                    ByteUtils.appendValue(b[j], 1, ascii);
                    continue;
                }
                ByteUtils.appendEmptyValue(radix, line);
                ByteUtils.appendEmptyValue(1, ascii);
            }
            line.append("  ");
            line.append(ascii.toString());
            buffer.append(line.toString().trim());
            ascii.setLength(0);
            line.setLength(0);
        }
        return buffer.toString();
    }

    public static final String dumpBinary(byte[] b) {
        return ByteUtils.dump(b, 2, 4, 0, b.length);
    }

    public static final String dumpBinary(byte[] b, int length) {
        return ByteUtils.dump(b, 2, 4, 0, length);
    }

    public static final String dumpBinary(byte[] b, int offset, int length) {
        return ByteUtils.dump(b, 2, 4, offset, length);
    }

    public static final String dumpDecimal(byte[] b) {
        return ByteUtils.dump(b, 10, 10, 0, b.length);
    }

    public static final String dumpDecimal(byte[] b, int length) {
        return ByteUtils.dump(b, 10, 10, 0, length);
    }

    public static final String dumpDecimal(byte[] b, int offset, int length) {
        return ByteUtils.dump(b, 10, 10, offset, length);
    }

    public static final String dumpHex(byte[] b) {
        return ByteUtils.dump(b, 16, 16, 0, b.length);
    }

    public static final String dumpHex(byte[] b, int length) {
        return ByteUtils.dump(b, 16, 16, 0, length);
    }

    public static final String dumpHex(byte[] b, int offset, int length) {
        return ByteUtils.dump(b, 16, 16, offset, length);
    }

    public static String padOrTruncate(String value, int digits) {
        int length = value.length();
        if (digits > length) {
            StringBuffer buffer = new StringBuffer(value);
            while (buffer.length() < digits) {
                buffer.insert(0, '0');
            }
            return buffer.toString();
        }
        if (digits < length) {
            return value.substring(length - digits);
        }
        return value;
    }

    public static String toBinaryString(byte value) {
        return ByteUtils.toString(value, 2);
    }

    public static String toBinaryString(byte value, int digits) {
        return ByteUtils.toString(value, 2, digits);
    }

    public static String toBinaryString(short value) {
        return ByteUtils.toString(value, 2, " ");
    }

    public static String toBinaryString(short value, int digits) {
        return ByteUtils.toString(value, 2, digits);
    }

    public static String toBinaryString(short value, String delimiter) {
        return ByteUtils.toString(value, 2, delimiter);
    }

    public static String toBinaryString(int value) {
        return ByteUtils.toString(value, 2, " ");
    }

    public static String toBinaryString(int value, int digits) {
        return ByteUtils.toString(value, 2, digits);
    }

    public static String toBinaryString(int value, String delimiter) {
        return ByteUtils.toString(value, 2, delimiter);
    }

    public static String toBinaryString(long value) {
        return ByteUtils.toString(value, 2, " ");
    }

    public static String toBinaryString(long value, int digits) {
        return ByteUtils.toString(value, 2, digits);
    }

    public static String toBinaryString(long value, String delimiter) {
        return ByteUtils.toString(value, 2, delimiter);
    }

    public static String toBinaryString(byte[] b) {
        return ByteUtils.toString(b, 2, " ", 0, b.length);
    }

    public static String toBinaryString(byte[] b, String delimiter) {
        return ByteUtils.toString(b, 2, delimiter, 0, b.length);
    }

    public static String toBinaryString(byte[] b, int offset, int length) {
        return ByteUtils.toString(b, 2, " ", offset, length);
    }

    public static String toBinaryString(byte[] b, String delimiter, int offset, int length) {
        return ByteUtils.toString(b, 2, delimiter, offset, length);
    }

    public static String toHexString(byte value) {
        return ByteUtils.toString(value, 16);
    }

    public static String toHexString(byte value, int digits) {
        return ByteUtils.toString(value, 16, digits);
    }

    public static String toHexString(short value, int digits) {
        return ByteUtils.toString(value, 16, digits);
    }

    public static String toHexString(short value) {
        return ByteUtils.toString(value, 16, " ");
    }

    public static String toHexString(short value, String delimiter) {
        return ByteUtils.toString(value, 16, delimiter);
    }

    public static String toHexString(int value, int digits) {
        return ByteUtils.toString(value, 16, digits);
    }

    public static String toHexString(int value) {
        return ByteUtils.toString(value, 16, " ");
    }

    public static String toHexString(int value, String delimiter) {
        return ByteUtils.toString(value, 16, delimiter);
    }

    public static String toHexString(long value, int digits) {
        return ByteUtils.toString(value, 16, digits);
    }

    public static String toHexString(long value) {
        return ByteUtils.toString(value, 16, " ");
    }

    public static String toHexString(long value, String delimiter) {
        return ByteUtils.toString(value, 16, delimiter);
    }

    public static String toHexString(byte[] b) {
        return ByteUtils.toString(b, 16, " ", 0, b.length);
    }

    public static String toHexString(byte[] b, String delimiter) {
        return ByteUtils.toString(b, 16, delimiter, 0, b.length);
    }

    public static String toHexString(byte[] b, int offset, int length) {
        return ByteUtils.toString(b, 16, " ", offset, length);
    }

    public static String toHexString(byte[] b, String delimiter, int offset, int length) {
        return ByteUtils.toString(b, 16, delimiter, offset, length);
    }

    public static String toString(byte value, int radix) {
        StringBuffer buffer = new StringBuffer();
        ByteUtils.appendValue(value, radix, buffer);
        return buffer.toString();
    }

    public static String toString(byte value, int radix, int digits) {
        return ByteUtils.padOrTruncate(ByteUtils.toString((short)value, radix, ""), digits);
    }

    public static String toString(short value, int radix, int digits) {
        return ByteUtils.padOrTruncate(ByteUtils.toString(value, radix, ""), digits);
    }

    public static String toString(short value, int radix, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        ByteUtils.appendValue((byte)(value >> 8 & 0xFF), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value & 0xFF), radix, buffer);
        return buffer.toString();
    }

    public static String toString(int value, int radix, int digits) {
        return ByteUtils.padOrTruncate(ByteUtils.toString(value, radix, ""), digits);
    }

    public static String toString(int value, int radix, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        ByteUtils.appendValue((byte)(value >> 24 & 0xFF), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value >> 16 & 0xFF), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value >> 8 & 0xFF), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value & 0xFF), radix, buffer);
        return buffer.toString();
    }

    public static String toString(long value, int radix, int digits) {
        return ByteUtils.padOrTruncate(ByteUtils.toString(value, radix, ""), digits);
    }

    public static String toString(long value, int radix, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        ByteUtils.appendValue((byte)(value >> 56 & 0xFFL), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value >> 48 & 0xFFL), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value >> 40 & 0xFFL), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value >> 32 & 0xFFL), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value >> 24 & 0xFFL), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value >> 16 & 0xFFL), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value >> 8 & 0xFFL), radix, buffer);
        buffer.append(delimiter);
        ByteUtils.appendValue((byte)(value & 0xFFL), radix, buffer);
        return buffer.toString();
    }

    public static String toString(byte[] b, int radix, String delimiter, int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative: " + offset);
        }
        if (offset >= b.length) {
            return "";
        }
        int end = length + offset - 1;
        if (end >= b.length) {
            end = b.length - 1;
        }
        StringBuffer buffer = new StringBuffer();
        ByteUtils.appendValue(b[offset], radix, buffer);
        for (int i = offset + 1; i <= end; ++i) {
            buffer.append(delimiter);
            ByteUtils.appendValue(b[i], radix, buffer);
        }
        return buffer.toString();
    }

    public static void printUsage() {
    }
}

