/*
 * Decompiled with CFR 0.152.
 */
package ddb.gui.javalogviewer;

import ddb.gui.javalogviewer.LogRecordTableColumns;
import ddb.util.FrequentlyAppendedTableModel;
import java.util.Calendar;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogRecordTableModel
extends FrequentlyAppendedTableModel<LogRecordTableColumns, LogRecord> {
    LogRecordTableModel() {
        super(LogRecordTableColumns.class);
    }

    public Object getValueAt(int n, LogRecordTableColumns logRecordTableColumns) {
        LogRecord logRecord = (LogRecord)super.getRecord(n);
        if (logRecord == null) {
            return null;
        }
        switch (logRecordTableColumns) {
            case TIME: {
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.setTimeInMillis(logRecord.getMillis());
                return calendar;
            }
            case LEVEL: {
                return logRecord;
            }
            case MESSAGE: {
                return logRecord.getMessage();
            }
            case SOURCECLASS: {
                return logRecord.getSourceClassName();
            }
            case SOURCEMETHOD: {
                return logRecord.getSourceMethodName();
            }
            case LOGGER: {
                return logRecord.getLoggerName();
            }
        }
        return null;
    }

    public String getColumnName(LogRecordTableColumns logRecordTableColumns) {
        return logRecordTableColumns.getName();
    }

    public Class<?> getColumnClass(LogRecordTableColumns logRecordTableColumns) {
        return logRecordTableColumns.getClazz();
    }
}

