/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.library.console;

import ddb.GuiConstants;
import ddb.actions.cursor.CursorScope;
import ddb.actions.deletetext.DeleteScope;
import ddb.actions.history.HistoryDirection;
import ddb.actions.history.HistoryListener;
import ddb.antialiasing.AntialiasedJLabel;
import ddb.antialiasing.AntialiasedTextField;
import ddb.console.ColorTheme;
import ddb.console.OptionPane;
import ddb.console.Themable;
import ddb.detach.TabbableOption;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.connection.ConnectionChangeEvent;
import ddb.dsz.core.connection.events.LpTerminatedEvent;
import ddb.dsz.core.controller.CommandSet;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.internalcommand.InternalCommandHandler;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.core.task.TaskState;
import ddb.dsz.library.console.BuiltinHandler;
import ddb.dsz.library.console.ConsoleIcon;
import ddb.dsz.library.console.ConsoleOutputPane;
import ddb.dsz.library.console.EnterKeyPressAction;
import ddb.dsz.library.console.HistoryFileParserWriter;
import ddb.dsz.library.console.LoadSaveHistoryAction;
import ddb.dsz.library.console.ParsedCommandLine;
import ddb.dsz.library.console.actions.ChangeColorTheme;
import ddb.dsz.library.console.actions.CopyCommandLine;
import ddb.dsz.library.console.actions.CutCommandLine;
import ddb.dsz.library.console.actions.DecreaseFontSize;
import ddb.dsz.library.console.actions.IncreaseFontSize;
import ddb.dsz.library.console.actions.InteruptCurrentCommand;
import ddb.dsz.library.console.actions.PasteCommandLine;
import ddb.dsz.library.console.actions.ResetFontSizeToDefault;
import ddb.dsz.library.console.builtins.BuiltinCommand;
import ddb.dsz.library.console.builtins.ClearHandler;
import ddb.dsz.library.console.builtins.CommentHandler;
import ddb.dsz.library.console.builtins.ForegroundCommandHandler;
import ddb.dsz.library.console.builtins.HelpHandler;
import ddb.dsz.library.console.builtins.SetHandler;
import ddb.dsz.library.console.builtins.TitleHandler;
import ddb.dsz.library.console.jaxb.consolecommands.Command;
import ddb.dsz.library.console.jaxb.consolecommands.Commands;
import ddb.dsz.library.console.jaxb.consolecommands.ObjectFactory;
import ddb.dsz.plugin.AbstractPlugin;
import ddb.dsz.plugin.Plugin;
import ddb.history.History;
import ddb.imagemanager.ImageManager;
import ddb.listeners.RightClickListener;
import ddb.predicate.PredicateClosure;
import ddb.predicate.PredicateClosureImpl;
import ddb.util.FileAndTextTransferHandler;
import ddb.util.JaxbCache;
import ddb.util.StringCompletor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.TransformerUtils;
import org.apache.commons.collections.functors.ChainedTransformer;
import org.apache.commons.collections.functors.MapTransformer;
import org.apache.commons.collections.functors.SwitchClosure;
import org.apache.commons.collections.map.TransformedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Console
extends AbstractPlugin
implements Plugin,
IdCallback,
FocusListener,
InternalCommandHandler,
HistoryListener {
    public static Predicate ALWAYS_DISPLAY = new Predicate(){

        public boolean evaluate(Object object) {
            if (object == null) {
                return false;
            }
            if (CommandEvent.class.isInstance(object)) {
                CommandEvent commandEvent = (CommandEvent)CommandEvent.class.cast(object);
                return commandEvent.getId().idMatch(TaskId.GLOBAL.getId());
            }
            return false;
        }
    };
    public static final String BUSY_ICON = "/images/firefox-throbber.gif";
    private AbstractAction interruptCurrentCommand = new InteruptCurrentCommand(this, "kill command");
    private AbstractAction increaseFontSize = new IncreaseFontSize(this, "inc font size");
    private AbstractAction decreaseFontSize = new DecreaseFontSize(this, "dec font size");
    private AbstractAction resetFontSizeToDefault = new ResetFontSizeToDefault(this, "reset font size");
    AbstractAction cutCommandLine = new CutCommandLine(this);
    AbstractAction copyCommandLine = new CopyCommandLine(this);
    AbstractAction pasteCommandLine = new PasteCommandLine(this);
    AbstractAction changeColorTheme = new ChangeColorTheme(this);
    public static final String CUSTOM_THEME = "Custom Theme";
    private static final int PREFERRED_WIDTH = 800;
    private static final int PREFERRED_HEIGHT = 600;
    private static final int SPINNER_WIDTH = 100;
    private static final int STATUSBAR_HEIGHT = 40;
    private static final Dimension PREFERRED_SIZE = new Dimension(800, 600);
    private static final String COMMANDS = "/Console/commands.xml";
    protected Runnable stopPromptMode = new Runnable(){

        public void run() {
            Console.this.inPromptMode = false;
            Console.this.promptMessageLabel.setVisible(false);
            Console.super.fireContentsChanged();
            Console.this.updateDisplayLayout();
        }
    };
    public static final String INTERNAL_COMMAND_PREFIX = ".";
    protected JPanel mainDisplayPanel;
    protected JPanel southPanel;
    private AntialiasedJLabel statusBar;
    protected AntialiasedTextField commandLine;
    protected ConsoleOutputPane outputPane;
    protected AntialiasedJLabel promptMessageLabel;
    private JLabel feedbackIcon;
    protected Task lastBackgroundedTask;
    protected CommandSet commandSet;
    protected JCheckBoxMenuItem WordWrapEnabled;
    protected JCheckBoxMenuItem AutoScroll;
    private EnterKeyPressAction enterKeyPressAction;
    protected final Stack<Task> currentTasks;
    protected Collection<Task> silentTasks;
    private boolean pendingReply;
    private boolean waitingForHelpStatement;
    private String helpCommand;
    private final Object helpLock;
    private File screenLog;
    private OutputStreamWriter screenLogWriter;
    protected int pendingReqId;
    private TaskId pendingCmdId;
    protected boolean inPromptMode;
    private History<String> normalHistory;
    private History<String> promptHistory;
    protected Hashtable<String, BuiltinCommand> builtinCommands;
    protected JPanel commandLinePanel;
    private JPanel header;
    private Collection<JMenuItem> menuItems = new Vector<JMenuItem>();
    Transformer toUpper = new Transformer(){

        public Object transform(Object object) {
            if (object == null) {
                return object;
            }
            return object.toString().toUpperCase();
        }
    };
    private Map<String, String> variables = TransformedMap.decorate(new HashMap(), (Transformer)this.toUpper, (Transformer)TransformerUtils.nopTransformer());
    Transformer getValue = ChainedTransformer.getInstance((Transformer[])new Transformer[]{this.toUpper, MapTransformer.getInstance(this.variables)});
    Predicate shouldIgnore = new Predicate(){

        public boolean evaluate(Object object) {
            if (!(object instanceof CommandEvent)) {
                return true;
            }
            if (ALWAYS_DISPLAY.evaluate(object)) {
                return false;
            }
            CommandEvent commandEvent = (CommandEvent)CommandEvent.class.cast(object);
            if (Console.this.core.getTaskById(commandEvent.getId()) != null) {
                return false;
            }
            if (commandEvent.getId().idMatch(0)) {
                return false;
            }
            return !commandEvent.getType().equals((Object)CommandEvent.CommandEventType.HELP);
        }
    };
    PredicateClosure[] processCommandLineActions = new PredicateClosure[]{new PredicateClosureImpl(new Predicate(){

        public boolean evaluate(Object object) {
            return Console.this.inPromptMode;
        }
    }, new Closure(){

        public void execute(Object object) {
            String string = object.toString();
            try {
                Console.this.addHistoryItem(string);
                Console.this.sendPromptReply(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Exception in EnterKeyPressAction.actionPerformed()");
            }
            Console.this.commandLine.setText("");
        }
    }), new PredicateClosureImpl(new Predicate(){

        public boolean evaluate(Object object) {
            return Console.this.isWaitingForSyncResponse();
        }
    }, ClosureUtils.nopClosure())};
    Closure defaultProcessAction = new Closure(){

        public void execute(Object object) {
            String string = object.toString();
            Console.this.commandLine.setText("");
            Console.this.appendTimestampedString(string + "\n", ConsoleOutputPane.OutputLevel.BOLD);
            if (string.length() == 0) {
                return;
            }
            Console.this.addHistoryItem(string);
            if (string.startsWith(Console.INTERNAL_COMMAND_PREFIX)) {
                Console.this.processBuiltinCommand(string);
            } else if (!Console.this.startCommand(string)) {
                Console.this.appendOutputMessage("DispatcherException - Unable to start command\n", ConsoleOutputPane.OutputLevel.ERROR);
            }
        }
    };
    Closure processCommandLineClosure = SwitchClosure.getInstance((Predicate[])this.processCommandLineActions, (Closure[])this.processCommandLineActions, (Closure)this.defaultProcessAction);

    public void updateDisplayLayout() {
        this.getDisplay().revalidate();
    }

    public String getHistory() {
        return "/Console/history.xml";
    }

    protected boolean isWaitingForSyncResponse() {
        return this.pendingReply;
    }

    protected void setWaitingForSyncResponse(boolean bl) {
        this.pendingReply = bl;
    }

    public Console() {
        this.setOnlyLive(true);
        this.currentTasks = new Stack();
        this.silentTasks = new Vector<Task>();
        this.mainDisplayPanel = new JPanel();
        this.mainDisplayPanel.setLayout(new BorderLayout());
        this.promptMessageLabel = new AntialiasedJLabel();
        this.promptMessageLabel.setFont(GuiConstants.FIXED_WIDTH_FONT.Basic.deriveFont(0, 18.0f));
        super.setDisplay((JComponent)this.mainDisplayPanel);
        super.setName("Console");
        this.prefferedSize = PREFERRED_SIZE;
        super.setCareAboutLocalEvents(true);
        this.helpLock = new Object();
        this.inPromptMode = false;
        this.normalHistory = History.getHistoryString((int)500);
        this.promptHistory = History.getHistoryString((int)500);
        this.builtinCommands = new Hashtable();
        this.setupBuiltinCommands();
    }

    public TabbableOption getStaticOptions() {
        return OptionPane.getInstance();
    }

    protected abstract String getConsoleLogName();

    protected final int init2() {
        this.screenLog = this.core.createLogFile(this.getConsoleLogName());
        this.commandSet = this.core.getCommandSet();
        try {
            this.screenLogWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.screenLog), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.core.logEvent(Level.WARNING, "UnsupportedEncodingException caught while creating UTF-8 screen log\nUsing default encoding instead", (Throwable)unsupportedEncodingException);
            try {
                this.screenLogWriter = new FileWriter(this.screenLog);
            }
            catch (IOException iOException) {
                this.core.logEvent(Level.SEVERE, "Exception caught while setting up logfile: " + iOException.getMessage(), (Throwable)iOException);
                this.core.logEvent(Level.SEVERE, "Console window will not be logged", (Throwable)iOException);
                System.err.println("Console window will not be logged.");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.core.logEvent(Level.SEVERE, "Exception caught while setting up logfile: " + fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            this.core.logEvent(Level.SEVERE, "Console window will not be logged", (Throwable)fileNotFoundException);
            System.err.println("Console window will not be logged.");
        }
        String string = System.getProperty("DSMAXCHARS");
        this.outputPane = string != null ? new ConsoleOutputPane(this.core, Integer.parseInt(string) / 100) : new ConsoleOutputPane(this.core);
        this.commandLinePanel = new JPanel(new BorderLayout());
        this.southPanel = new JPanel();
        this.southPanel.setLayout(new BorderLayout());
        this.setWaitingForSyncResponse(false);
        this.statusBar = new AntialiasedJLabel();
        this.statusBar.setSize(new Dimension(700, 40));
        this.statusBar.setHorizontalAlignment(0);
        if (this.screenLog != null) {
            this.statusBar.setText("log: " + this.screenLog.getName());
        } else {
            this.statusBar.setText("Console output not being logged");
        }
        this.header = new JPanel();
        this.header.setLayout(new BorderLayout());
        this.header.add((Component)this.statusBar, "Center");
        this.commandLine = new AntialiasedTextField();
        this.commandLine.setFocusTraversalKeysEnabled(false);
        this.commandLine.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                Console.this.commandLine.requestFocus();
                Console.this.commandLine.requestFocusInWindow();
            }
        });
        this.outputPane.addConnectedThemable((Themable)this.commandLine);
        this.setupStandardActionMaps(this.outputPane);
        this.setupStandardActionMaps((JComponent)this.commandLine);
        this.setupStandardActionMaps(this.mainDisplayPanel);
        this.setupCommandLineSpecificActionMaps();
        this.commandLine.setDragEnabled(true);
        this.commandLine.setTransferHandler((TransferHandler)new FileAndTextTransferHandler());
        this.enterKeyPressAction = new EnterKeyPressAction(this);
        this.commandLine.addActionListener((ActionListener)this.enterKeyPressAction);
        this.commandLine.setPreferredSize(new Dimension(950, 35));
        this.feedbackIcon = new JLabel();
        this.feedbackIcon.setDisabledIcon(new ImageIcon(this.getClass().getResource(BUSY_ICON)));
        this.feedbackIcon.setIcon(ImageManager.getIcon((String)ConsoleIcon.IDLE.getIcon(), (Dimension)new Dimension(20, 20)));
        this.feedbackIcon.setSize(new Dimension(40, 42));
        this.commandLinePanel.add((Component)this.feedbackIcon, "West");
        this.commandLinePanel.add((Component)this.commandLine, "Center");
        this.southPanel.add((Component)this.promptMessageLabel, "North");
        this.southPanel.add((Component)this.commandLinePanel, "Center");
        this.mainDisplayPanel.add((Component)this.outputPane, "Center");
        this.mainDisplayPanel.add((Component)this.southPanel, "South");
        this.outputPane.passInMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                Console.this.commandLine.requestFocusInWindow();
            }
        });
        this.core.submit(new Runnable(){

            public void run() {
                try {
                    Console.this.loadExistingHistoryFile();
                }
                catch (Exception exception) {
                    Console.this.appendOutputMessage("Error while loading history file\n", ConsoleOutputPane.OutputLevel.ERROR);
                    exception.printStackTrace();
                }
            }
        });
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Console");
        this.menuBar.add(jMenu);
        this.addMenuItem("Save history", ConsoleIcon.SAVE, (ActionListener)new LoadSaveHistoryAction(this, this.mainDisplayPanel, this.normalHistory, LoadSaveHistoryAction.HistoryActionType.SAVE), jMenu);
        this.addMenuItem("Load history", ConsoleIcon.LOAD, (ActionListener)new LoadSaveHistoryAction(this, this.mainDisplayPanel, this.normalHistory, LoadSaveHistoryAction.HistoryActionType.LOAD), jMenu);
        this.addMenuItem("Inc font size", ConsoleIcon.PLUS, (ActionListener)this.increaseFontSize, jMenu);
        this.addMenuItem("Reset font size", null, (ActionListener)this.resetFontSizeToDefault, jMenu);
        this.addMenuItem("Dec font size", ConsoleIcon.MINUS, (ActionListener)this.decreaseFontSize, jMenu);
        this.addMenuItem("Change color theme", null, (ActionListener)this.changeColorTheme, jMenu);
        jMenu.addSeparator();
        this.WordWrapEnabled = new JCheckBoxMenuItem("Word Wrap");
        this.WordWrapEnabled.setSelected(this.outputPane.getWordWrap());
        this.WordWrapEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.outputPane.setWordWrap(!Console.this.outputPane.getWordWrap());
                Console.this.WordWrapEnabled.setSelected(Console.this.outputPane.getWordWrap());
            }
        });
        jMenu.add(this.WordWrapEnabled);
        this.AutoScroll = new JCheckBoxMenuItem("Auto Scroll");
        this.AutoScroll.setSelected(this.outputPane.getAutoScroll());
        this.AutoScroll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.outputPane.setAutoScroll(!Console.this.outputPane.getAutoScroll());
                Console.this.AutoScroll.setSelected(Console.this.outputPane.getAutoScroll());
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Pause Input");
        jCheckBoxMenuItem.setModel(this.outputPane.getPausedModel());
        jMenu.add(jCheckBoxMenuItem);
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItem("Cut", ConsoleIcon.CUT, (ActionListener)this.cutCommandLine, jPopupMenu);
        this.addMenuItem("Copy", ConsoleIcon.COPY, (ActionListener)this.copyCommandLine, jPopupMenu);
        this.addMenuItem("Paste", ConsoleIcon.PASTE, (ActionListener)this.pasteCommandLine, jPopupMenu);
        this.commandLine.addMouseListener((MouseListener)new RightClickListener(jPopupMenu));
        this.core.setupKeyBindings((JComponent)this.outputPane);
        this.core.setupKeyBindings((JComponent)this.commandLine);
        this.core.setupKeyBindings((JComponent)this.mainDisplayPanel);
        this.setupMenuKeybindings();
        this.setTheme(OptionPane.getInstance().getSharedTheme());
        return this.init3();
    }

    protected int init3() {
        return 0;
    }

    protected final boolean parseArgument2(String string, String string2) {
        if (string.equalsIgnoreCase("-max") && string2 != null) {
            Integer n = Integer.parseInt(string2);
            this.outputPane.setMaximumCharacters(n);
        }
        if (string.equalsIgnoreCase("-theme") && string2 != null) {
            for (ColorTheme colorTheme : OptionPane.getInstance().getAllThemes()) {
                if (!string2.equalsIgnoreCase(colorTheme.getName())) continue;
                this.setTheme(colorTheme);
                return true;
            }
            this.core.logEvent(Level.WARNING, "Invalid theme name: " + string2);
            return false;
        }
        return this.parseArgument3(string, string2);
    }

    protected boolean parseArgument3(String string, String string2) {
        return false;
    }

    private void addMenuItem(String string, ConsoleIcon consoleIcon, ActionListener actionListener, JMenu jMenu) {
        jMenu.add(this.createMenuItem(string, consoleIcon, actionListener));
    }

    private void addMenuItem(String string, ConsoleIcon consoleIcon, ActionListener actionListener, JPopupMenu jPopupMenu) {
        jPopupMenu.add(this.createMenuItem(string, consoleIcon, actionListener));
    }

    private JMenuItem createMenuItem(String string, ConsoleIcon consoleIcon, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (consoleIcon != null) {
            jMenuItem.setIcon(ImageManager.getIcon((String)consoleIcon.getIcon(), (Dimension)this.core.getLabelImageSize()));
        }
        jMenuItem.addActionListener(actionListener);
        this.menuItems.add(jMenuItem);
        return jMenuItem;
    }

    protected final void fini2() {
        this.fini3();
        this.outputPane.stop();
        try {
            this.screenLogWriter.flush();
            this.screenLogWriter.close();
        }
        catch (IOException iOException) {
            this.core.logEvent(Level.WARNING, "Exception caught while closing " + this.screenLog.getName() + ": " + iOException.getMessage(), (Throwable)iOException);
        }
        this.builtinCommands.clear();
        this.menuItems.clear();
    }

    protected void fini3() {
    }

    private void loadExistingHistoryFile() throws Exception {
        URL uRL = Console.class.getClassLoader().getResource(this.getHistory());
        if (uRL != null) {
            List<String> list = HistoryFileParserWriter.parse(uRL.openStream());
            for (String string : list) {
                this.normalHistory.addHistoryItem((Object)string);
            }
        }
    }

    public void addHistoryItem(String string) {
        if (this.isInPromptMode()) {
            if (string.trim().length() > 0) {
                this.promptHistory.addHistoryItem((Object)string);
            }
        } else {
            this.normalHistory.addHistoryItem((Object)string);
        }
    }

    public AntialiasedTextField getCommandLine() {
        return this.commandLine;
    }

    CoreController getController() {
        return this.core;
    }

    public void processCommandLine() {
        this.processCommandLineClosure.execute((Object)this.commandLine.getText());
    }

    public abstract boolean startCommand(String var1);

    protected String getPrefix() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getValue.transform((Object)"user") != null) {
            stringBuilder.append(String.format("USER=%s ", this.getValue.transform((Object)"user")));
        }
        return stringBuilder.toString();
    }

    void killCurrentCommand() {
        if (!this.isWaitingForSyncResponse()) {
            return;
        }
        try {
            Task task = this.currentTasks.peek();
            String string = task.getTypedCommand();
            this.core.killCommand(task);
            this.appendOutputMessage("Killed '" + string + "'\n", ConsoleOutputPane.OutputLevel.BOLD);
            this.setWorkingState(ConsoleState.IDLE);
        }
        catch (DispatcherException dispatcherException) {
            this.appendOutputMessage("Exception caught while trying to kill command\n", ConsoleOutputPane.OutputLevel.WARNING);
            this.appendOutputMessage(dispatcherException.getMessage() + "\n", ConsoleOutputPane.OutputLevel.WARNING);
        }
        this.evalutateWaitingForSyncTask();
    }

    public void interruptCurrentCommand() {
        if (!this.isWaitingForSyncResponse()) {
            return;
        }
        try {
            Task task = this.currentTasks.peek();
            String string = task.getCommandName();
            this.core.interruptCommand(task);
            this.appendOutputMessage(String.format("\n[Interrupt send to command %d: %s]\n", task.getId().getId(), string), ConsoleOutputPane.OutputLevel.BOLD);
        }
        catch (DispatcherException dispatcherException) {
            this.appendOutputMessage("Exception caught while trying to interrupt command\n", ConsoleOutputPane.OutputLevel.WARNING);
            this.appendOutputMessage(dispatcherException.getMessage() + "\n", ConsoleOutputPane.OutputLevel.WARNING);
        }
    }

    void sendPromptReply(String string) {
        try {
            this.core.sendPromptReply(this.pendingReqId, this.pendingCmdId, string);
        }
        catch (DispatcherException dispatcherException) {
            this.core.logEvent(Level.SEVERE, "Unable to send requested input to dispatcher\nCmdId: " + this.pendingCmdId + "  ReqId: " + this.pendingReqId, (Throwable)dispatcherException);
            this.appendOutputMessage("Unable to send requested input to dispatcher\n", ConsoleOutputPane.OutputLevel.ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandOutputReceived(CommandEvent commandEvent, Task task) {
        CommandEvent.XmlOutput xmlOutput;
        Object object;
        if (!ALWAYS_DISPLAY.evaluate((Object)commandEvent)) {
            object = commandEvent.getId();
            if (object.idMatch(0)) {
                this.appendOutputMessage(commandEvent.getText(), ConsoleOutputPane.OutputLevel.DEFAULT);
                return;
            }
            if (this.currentTasks.size() == 0) {
                return;
            }
            if (task == null) {
                this.core.logEvent(Level.INFO, "Can't locate a task for this reply.  Dropping output:" + commandEvent.getText());
                return;
            }
            xmlOutput = task.getState();
            if (xmlOutput.equals((Object)TaskState.KILLED)) {
                return;
            }
            boolean bl = false;
            Stack<Task> stack = this.currentTasks;
            synchronized (stack) {
                if (!this.currentTasks.contains(task)) {
                    bl = true;
                } else if (this.silentTasks.contains(task)) {
                    return;
                }
            }
            if (bl) {
                this.appendOutputMessage("What happened? What command is this from?\n", ConsoleOutputPane.OutputLevel.WARNING);
                this.appendOutputMessage("Reply id: " + object, ConsoleOutputPane.OutputLevel.WARNING);
                if (this.currentTasks.size() != 0) {
                    this.appendOutputMessage("\tCurrent task id: " + this.currentTasks.peek().getId(), ConsoleOutputPane.OutputLevel.WARNING);
                }
                this.appendOutputMessage("\n", ConsoleOutputPane.OutputLevel.WARNING);
            }
        }
        object = commandEvent.getText();
        xmlOutput = commandEvent.getXmlOutput();
        if (object != null) {
            switch (xmlOutput) {
                case ERROR: {
                    this.appendOutputMessage((String)object, ConsoleOutputPane.OutputLevel.ERROR);
                    break;
                }
                case GOOD: {
                    this.appendOutputMessage((String)object, ConsoleOutputPane.OutputLevel.NOTICE);
                    break;
                }
                case WARNING: {
                    this.appendOutputMessage((String)object, ConsoleOutputPane.OutputLevel.WARNING);
                    break;
                }
                default: {
                    this.appendOutputMessage((String)object, ConsoleOutputPane.OutputLevel.DEFAULT);
                }
            }
        }
        super.fireContentsChanged();
    }

    protected void commandBackgrounded(CommandEvent commandEvent) {
        super.commandBackgrounded(commandEvent);
        Task task = this.core.getTaskById(commandEvent.getId());
        if (task == null) {
            return;
        }
        if (this.currentTasks.contains(task)) {
            this.silentTasks.add(task);
        }
    }

    public void appendOutputMessage(String string, ConsoleOutputPane.OutputLevel outputLevel) {
        if (this.screenLogWriter != null && string != null) {
            try {
                this.screenLogWriter.write(string);
                this.screenLogWriter.flush();
            }
            catch (IOException iOException) {
                this.core.logEvent(Level.SEVERE, "Exception caught while writing to screen log", (Throwable)iOException);
                this.core.logEvent(Level.SEVERE, "Unlogged text: " + string, (Throwable)iOException);
            }
        }
        this.outputPane.appendOutputMessage(string, outputLevel);
    }

    public void appendToOutput(String string) {
        this.appendOutputMessage(string, ConsoleOutputPane.OutputLevel.DEFAULT);
    }

    public void appendTimestampedString(String string, ConsoleOutputPane.OutputLevel outputLevel) {
        this.appendOutputMessage(this.getTimestamp() + ">> " + string, outputLevel);
    }

    private String getTimestamp() {
        String string;
        String string2;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        String string3 = "0" + Integer.toString(calendar.get(11));
        if (string3.length() > 2) {
            string3 = string3.substring(string3.length() - 2);
        }
        if ((string2 = "0" + Integer.toString(calendar.get(12))).length() > 2) {
            string2 = string2.substring(string2.length() - 2);
        }
        if ((string = "0" + Integer.toString(calendar.get(13))).length() > 2) {
            string = string.substring(string.length() - 2);
        }
        String string4 = string3 + ":" + string2 + ":" + string;
        return string4;
    }

    public void startPromptReceived(CommandEvent commandEvent) {
        EventQueue.invokeLater(new StartPromptReceived(commandEvent));
    }

    public void stopPromptReceived(CommandEvent commandEvent) {
        if (commandEvent.getId().equals((Object)this.pendingCmdId)) {
            EventQueue.invokeLater(this.stopPromptMode);
        }
    }

    public boolean isInPromptMode() {
        return this.inPromptMode;
    }

    public void setInPromptMode(boolean bl) {
        this.inPromptMode = bl;
    }

    public void idAcquired(TaskId taskId, Object object) {
        Task task = this.core.getTaskById(taskId);
        if (task == null) {
            this.outputPane.appendOutputMessage("Received ID callback for unknown command", ConsoleOutputPane.OutputLevel.WARNING);
            return;
        }
        this.currentTasks.push(task);
    }

    protected void setCurrentSynchTask(Task task) {
        this.currentTasks.push(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestHelpStatement(ParsedCommandLine parsedCommandLine, HostInfo hostInfo) {
        Object object = this.helpLock;
        synchronized (object) {
            this.helpCommand = parsedCommandLine.getCommandName();
            this.waitingForHelpStatement = true;
            this.commandLine.setEnabled(false);
        }
        try {
            this.core.requestHelpStatement(this.helpCommand, hostInfo);
        }
        catch (DispatcherException dispatcherException) {
            this.outputPane.appendOutputMessage("Exception caught while requesting help statement for " + this.helpCommand, ConsoleOutputPane.OutputLevel.ERROR);
            this.waitingForHelpStatement = false;
            return;
        }
    }

    public void setWorkingState(ConsoleState consoleState) {
        EventQueue.invokeLater(new SetWorkingState(consoleState));
    }

    protected void setStatus(String string) {
        EventQueue.invokeLater(new SetStatus(string));
    }

    private void setupMenuKeybindings() {
        Map map = this.core.getKeyBindings();
        if (map == null) {
            return;
        }
        for (JMenuItem jMenuItem : this.menuItems) {
            ActionListener[] actionListenerArray;
            for (ActionListener actionListener : actionListenerArray = jMenuItem.getActionListeners()) {
                if (!(actionListener instanceof AbstractAction)) continue;
                AbstractAction abstractAction = (AbstractAction)AbstractAction.class.cast(actionListener);
                for (KeyStroke keyStroke : map.keySet()) {
                    if (!((String)map.get(keyStroke)).equals(abstractAction.getValue("Name"))) continue;
                    jMenuItem.setAccelerator(keyStroke);
                }
            }
        }
    }

    private void setupStandardActionMaps(JComponent jComponent) {
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put("kill command", this.interruptCurrentCommand);
        actionMap.put("inc font size", this.increaseFontSize);
        actionMap.put("dec font size", this.decreaseFontSize);
        actionMap.put("reset font size", this.resetFontSizeToDefault);
    }

    protected void setupCommandLineSpecificActionMaps() {
        ActionMap actionMap = this.commandLine.getActionMap();
        CursorScope.fill((JTextComponent)this.commandLine);
        DeleteScope.fill((JTextComponent)this.commandLine);
        HistoryDirection.fill((HistoryListener)this, (ActionMap)actionMap);
        actionMap.put("copy text", this.copyCommandLine);
        actionMap.put("cut text", this.cutCommandLine);
        actionMap.put("paste text", this.pasteCommandLine);
    }

    protected void commandEnded(CommandEvent commandEvent) {
        super.commandEnded(commandEvent);
        Task task = this.core.getTaskById(commandEvent.getId());
        if (this.shouldIgnore.evaluate((Object)commandEvent)) {
            return;
        }
        if (this.inPromptMode && this.pendingCmdId.equals((Object)commandEvent.getId())) {
            EventQueue.invokeLater(this.stopPromptMode);
        }
        if (this.currentTasks.contains(task)) {
            this.currentTasks.remove(task);
            while (this.silentTasks.contains(task)) {
                this.silentTasks.remove(task);
            }
            this.removeChildTasks(task);
            Task task2 = task.getParentTask();
            if (task2 != null && !this.silentTasks.contains(task2)) {
                this.setStatus(task2.getTypedCommand());
            }
        } else {
            return;
        }
        if (this.currentTasks.size() == 0 && this.isWaitingForSyncResponse()) {
            this.setStatus("");
            super.fireContentsChanged();
        }
        this.evalutateWaitingForSyncTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandHelp(CommandEvent commandEvent) {
        super.commandHelp(commandEvent);
        if (this.shouldIgnore.evaluate((Object)commandEvent)) {
            return;
        }
        Object object = this.helpLock;
        synchronized (object) {
            if (!this.waitingForHelpStatement) {
                return;
            }
            if (commandEvent.getCommand().equalsIgnoreCase(this.helpCommand)) {
                this.outputPane.appendOutputMessage(commandEvent.getText() + "\n", ConsoleOutputPane.OutputLevel.DEFAULT);
                this.waitingForHelpStatement = false;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Console.this.commandLine.setEnabled(true);
                        Console.this.commandLine.requestFocusInWindow();
                    }
                });
            }
        }
    }

    protected void commandOutput(CommandEvent commandEvent) {
        super.commandOutput(commandEvent);
        Task task = this.core.getTaskById(commandEvent.getId());
        if (this.shouldIgnore.evaluate((Object)commandEvent)) {
            return;
        }
        if (this.currentTasks.contains(task) || ALWAYS_DISPLAY.evaluate((Object)commandEvent)) {
            this.commandOutputReceived(commandEvent, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandSetFlags(CommandEvent commandEvent) {
        super.commandSetFlags(commandEvent);
        Task task = this.core.getTaskById(commandEvent.getId());
        if (this.shouldIgnore.evaluate((Object)commandEvent)) {
            return;
        }
        if (this.isWaitingForSyncResponse()) {
            String string = commandEvent.getText();
            if (string.toLowerCase().startsWith("background")) {
                boolean bl = false;
                Console console = this;
                synchronized (console) {
                    if (this.currentTasks.contains(task)) {
                        bl = this.currentTasks.size() <= 1;
                        this.currentTasks.remove(task);
                        this.evalutateWaitingForSyncTask();
                    }
                }
                if (bl) {
                    this.appendOutputMessage("[" + this.getTimestamp() + "] Backgrounded '" + task.getTypedCommand() + "'  Id: " + task.getId() + "\n", ConsoleOutputPane.OutputLevel.BOLD);
                }
            }
            if (!string.toLowerCase().equals("guiflag=focus") || this.currentTasks.contains(task)) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evalutateWaitingForSyncTask() {
        boolean bl = false;
        Console console = this;
        synchronized (console) {
            if (this.currentTasks.size() == 0) {
                this.setWaitingForSyncResponse(false);
                bl = true;
            }
        }
        this.setWorkingState(bl ? ConsoleState.IDLE : ConsoleState.BUSY);
    }

    private void removeChildTasks(Task task) {
        LinkedBlockingQueue<Task> linkedBlockingQueue = new LinkedBlockingQueue<Task>();
        linkedBlockingQueue.offer(task);
        while (linkedBlockingQueue.peek() != null) {
            Task task2;
            Task task3 = (Task)linkedBlockingQueue.poll();
            if (task3 == null) continue;
            Iterator<Object> iterator = this.currentTasks.iterator();
            while (iterator.hasNext()) {
                task2 = (Task)iterator.next();
                if (!task2.getParentId().equals((Object)task.getId())) continue;
                linkedBlockingQueue.add(task2);
                iterator.remove();
            }
            iterator = this.silentTasks.iterator();
            while (iterator.hasNext()) {
                task2 = (Task)iterator.next();
                if (!task2.getParentId().equals((Object)task.getId())) continue;
                linkedBlockingQueue.add(task2);
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandStarted(CommandEvent commandEvent) {
        super.commandStarted(commandEvent);
        TaskId taskId = commandEvent.getId();
        TaskId taskId2 = commandEvent.getPid();
        Task task = this.core.getTaskById(taskId);
        Task task2 = this.core.getTaskById(taskId2);
        if (this.shouldIgnore.evaluate((Object)commandEvent)) {
            return;
        }
        Stack<Task> stack = this.currentTasks;
        synchronized (stack) {
            if (!this.currentTasks.contains(task) && !this.currentTasks.contains(task2)) {
                return;
            }
            if (this.currentTasks.peek().equals(task)) {
                if (!this.silentTasks.contains(task) && !this.silentTasks.contains(task2)) {
                    this.setWorkingState(ConsoleState.BUSY);
                    for (int i = 0; i < 15 && task.getHost() == null; ++i) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(10L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String string = task.getHost() == null ? String.format("default target: %s", this.target != null ? this.target.getId() : "(unknown)") : String.format("target: %s", task.getHost().getId());
                    this.appendOutputMessage(String.format("[%s] ID: %d '%s' started [%s]\n", this.getTimestamp(), task.getId().getId(), task.getCommandName(), string), ConsoleOutputPane.OutputLevel.NOTICE);
                    super.fireContentsChanged();
                }
            } else if (this.currentTasks.contains(task2)) {
                this.currentTasks.push(task);
            }
        }
    }

    protected void commandStartPrompt(CommandEvent commandEvent) {
        super.commandStartPrompt(commandEvent);
        if (this.shouldIgnore.evaluate((Object)commandEvent)) {
            return;
        }
        this.startPromptReceived(commandEvent);
    }

    protected void commandStopPrompt(CommandEvent commandEvent) {
        super.commandStopPrompt(commandEvent);
        Task task = this.core.getTaskById(commandEvent.getId());
        if (this.shouldIgnore.evaluate((Object)commandEvent)) {
            return;
        }
        if (!this.currentTasks.contains(task)) {
            return;
        }
        this.stopPromptReceived(commandEvent);
    }

    public void moveFocusToCommandLine() {
        this.commandLine.requestFocus();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.moveFocusToCommandLine();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.moveFocusToCommandLine();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.moveFocusToCommandLine();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.moveFocusToCommandLine();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.moveFocusToCommandLine();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.moveFocusToCommandLine();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.moveFocusToCommandLine();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public void receivedFocus() {
        super.receivedFocus();
        this.moveFocusToCommandLine();
    }

    public void decreaseFontSize() {
        this.outputPane.decreaseFontSize();
    }

    public void increaseFontSize() {
        this.outputPane.increaseFontSize();
    }

    public void resetFontSizeToDefault() {
        this.outputPane.resetFontSizeToDefault();
    }

    public void historyActionPerformed(HistoryDirection historyDirection) {
        String string;
        History<String> history = this.normalHistory;
        if (this.isInPromptMode()) {
            history = this.promptHistory;
        }
        if ((string = (String)history.doHistoryAction(historyDirection, (Object)this.commandLine.getText())) != null) {
            this.commandLine.setText(string);
        }
    }

    public synchronized void setTheme(ColorTheme colorTheme) {
        this.commandLine.setTheme(colorTheme);
        this.outputPane.setTheme(colorTheme);
    }

    public boolean handlesPromptsForTask(Task task, int n) {
        return this.currentTasks.contains(task);
    }

    public ColorTheme getCurrentTheme() {
        return this.outputPane.getTheme();
    }

    protected void setupBuiltinCommands2() {
        JAXBContext jAXBContext = JaxbCache.getContext(ObjectFactory.class);
        if (jAXBContext == null) {
            return;
        }
        Commands commands = null;
        try {
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            if (unmarshaller == null) {
                return;
            }
            Iterator<Command> iterator = unmarshaller.unmarshal(Console.class.getResource(COMMANDS));
            if (iterator instanceof JAXBElement) {
                iterator = ((JAXBElement)JAXBElement.class.cast(iterator)).getValue();
            }
            if (iterator instanceof Commands) {
                commands = (Commands)Commands.class.cast(iterator);
            }
            if (commands == null) {
                return;
            }
        }
        catch (Exception exception) {
            if (this.core != null) {
                this.core.logEvent(Level.SEVERE, null, (Throwable)exception);
            } else {
                exception.printStackTrace();
            }
            return;
        }
        for (Command command : commands.getCommand()) {
            this.builtinCommands.put(command.getName(), BuiltinCommand.generate(this, command, this.builtinCommands));
        }
    }

    protected void setupBuiltinCommands() {
        BuiltinCommand builtinCommand = new BuiltinCommand("help");
        builtinCommand.setHandler(new HelpHandler(this, this.builtinCommands));
        builtinCommand.setHelpStatement("Usage: help [internalCmd]");
        BuiltinCommand builtinCommand2 = new BuiltinCommand("clear");
        builtinCommand2.setHandler(new ClearHandler(this));
        builtinCommand2.setHelpStatement("Usage: clear\n");
        BuiltinCommand builtinCommand3 = new BuiltinCommand("foreground");
        builtinCommand3.setHandler(new ForegroundCommandHandler(this));
        builtinCommand3.setHelpStatement("Usage: foreground [cmdId]");
        BuiltinCommand builtinCommand4 = new BuiltinCommand("comment");
        builtinCommand4.setHandler(new CommentHandler(this));
        builtinCommand4.setHelpStatement("Usage: comment [comment text]");
        BuiltinCommand builtinCommand5 = new BuiltinCommand("set");
        builtinCommand5.setHandler(new SetHandler(this));
        builtinCommand5.setHelpStatement("Usage: set <variable>[=value]");
        BuiltinCommand builtinCommand6 = new BuiltinCommand("title");
        builtinCommand6.setHandler(new TitleHandler(this));
        builtinCommand6.setHelpStatement("Usage: title <new name>");
        this.builtinCommands.put("help", builtinCommand);
        this.builtinCommands.put("clear", builtinCommand2);
        this.builtinCommands.put("foreground", builtinCommand3);
        this.builtinCommands.put("comment", builtinCommand4);
        this.builtinCommands.put("set", builtinCommand5);
        this.builtinCommands.put("title", builtinCommand6);
        this.setupBuiltinCommands2();
    }

    public void processBuiltinCommand(String string) {
        String string2 = string.trim();
        String string3 = null;
        String string4 = null;
        int n = string2.indexOf(32);
        if (n == -1) {
            string3 = string2.substring(INTERNAL_COMMAND_PREFIX.length());
        } else {
            string3 = string2.substring(INTERNAL_COMMAND_PREFIX.length(), n);
            string4 = string2.substring(n).trim();
        }
        if (this.builtinCommands.containsKey(string3)) {
            BuiltinHandler builtinHandler = this.builtinCommands.get(string3).getHandler();
            builtinHandler.executeBuiltinCommand(string3, string4);
        } else {
            this.appendOutputMessage("Unrecognized internal command\n", ConsoleOutputPane.OutputLevel.WARNING);
        }
    }

    public void helpBuiltinCommand(String string) {
        if (string == null || string.length() == 1) {
            return;
        }
        String string2 = string.toLowerCase().trim().substring(1);
        Set<String> set = this.builtinCommands.keySet();
        for (String string3 : set) {
            if (!string2.startsWith(string3.toLowerCase())) continue;
            BuiltinCommand builtinCommand = this.builtinCommands.get(string3);
            this.appendOutputMessage(builtinCommand.getHelpStatement(), ConsoleOutputPane.OutputLevel.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeBuiltinCommand(String string, String string2) {
        Set<String> set = this.builtinCommands.keySet();
        String string3 = string.substring(INTERNAL_COMMAND_PREFIX.length());
        List list = StringCompletor.complete((String)string3, set);
        switch (list.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.commandLine.setText(INTERNAL_COMMAND_PREFIX + list.get(0) + " " + string2);
                int n = INTERNAL_COMMAND_PREFIX.length() + list.get(0).toString().length() + 1;
                this.commandLine.setCaretPosition(n);
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                for (Object e : list) {
                    String string4 = e.toString();
                    stringBuilder.append(string4 + "\t");
                    if (++n % 3 != 0) continue;
                    stringBuilder.append("\n");
                }
                Console console = this;
                synchronized (console) {
                    this.appendOutputMessage("Internal commands:\n", ConsoleOutputPane.OutputLevel.NOTICE);
                    this.appendToOutput(stringBuilder.toString());
                    this.appendToOutput("\n");
                    break;
                }
            }
        }
    }

    public void startNewPluginWithInitArgs(String string, List<String> list) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string, false, Console.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.appendOutputMessage("Unable to locate class " + string + "\n", ConsoleOutputPane.OutputLevel.WARNING);
            return;
        }
        this.core.startNewPlugin(clazz, clazz.getSimpleName(), list, false, false);
    }

    public void startNewPluginWithInitArgs(String string) {
        if (string == null) {
            this.printBuiltinCommandHelp("newplugin");
            return;
        }
        int n = string.indexOf(32);
        if (n == -1) {
            this.startNewPluginWithInitArgs(string, null);
            return;
        }
        String string2 = string.substring(0, n);
        Vector<String> vector = new Vector<String>();
        vector.add(string.substring(n + 1));
        this.startNewPluginWithInitArgs(string2, vector);
    }

    public void clearOutputScreen(String string) {
        this.outputPane.clearAndReplace(string);
    }

    public void addOutputComment(String string) {
        this.outputPane.appendToOutput(string);
    }

    public void foregroundLast() {
        this.foregroundCommand(this.lastBackgroundedTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foregroundCommand(Task task) {
        if (task == null) {
            return;
        }
        this.foregroundCommand(task.getParentTask());
        Task task2 = this.currentTasks;
        synchronized (task2) {
            if (!this.currentTasks.contains(task)) {
                this.currentTasks.push(task);
            }
            this.silentTasks.remove(task);
        }
        this.setStatus(task.getTypedCommand());
        this.setWaitingForSyncResponse(true);
        this.setWorkingState(ConsoleState.BUSY);
        if (task.isInPromptMode()) {
            this.pendingCmdId = task.getId();
            EventQueue.invokeLater(new RestorePrompt(this.core.claimPrompt(task)));
        }
        try {
            this.core.restartCommandOutput(task);
        }
        catch (DispatcherException dispatcherException) {
            this.appendOutputMessage("Exception caught while trying to restart command output", ConsoleOutputPane.OutputLevel.ERROR);
            this.currentTasks.remove(task);
            this.evalutateWaitingForSyncTask();
            return;
        }
        switch (task.getState()) {
            case FAILED: 
            case SUCCEEDED: 
            case KILLED: {
                if (this.currentTasks.contains(task)) {
                    this.currentTasks.remove(task);
                    while (this.silentTasks.contains(task)) {
                        this.silentTasks.remove(task);
                    }
                    this.removeChildTasks(task);
                    task2 = task.getParentTask();
                    if (task2 != null && !this.silentTasks.contains(task2)) {
                        this.setStatus(task2.getTypedCommand());
                    }
                } else {
                    return;
                }
                if (this.currentTasks.size() == 0 && this.isWaitingForSyncResponse()) {
                    this.setStatus("");
                    super.fireContentsChanged();
                }
                this.evalutateWaitingForSyncTask();
                break;
            }
        }
    }

    public void foregroundCommand(int n) {
        TaskId taskId = TaskId.GenerateTaskId((int)n, (Operation)this.core.getOperation());
        Task task = this.core.getTaskById(taskId);
        if (task == null) {
            this.outputPane.appendOutputMessage("Command " + n + " not found.  Unable to foreground unknown command\n", ConsoleOutputPane.OutputLevel.ERROR);
            return;
        }
        this.foregroundCommand(task);
    }

    public void printString(String string) {
        this.printString(string, ConsoleOutputPane.OutputLevel.DEFAULT);
    }

    public void printString(String string, ConsoleOutputPane.OutputLevel outputLevel) {
        this.appendOutputMessage(string, outputLevel);
    }

    public void printBuiltinCommandHelp(String string) {
        BuiltinCommand builtinCommand = this.builtinCommands.get(string);
        if (builtinCommand != null) {
            if (builtinCommand.getHelpStatement() != null) {
                this.printString(builtinCommand.getHelpStatement() + "\n", ConsoleOutputPane.OutputLevel.DEFAULT);
            }
        } else {
            this.printString("No such internal command\n", ConsoleOutputPane.OutputLevel.DEFAULT);
            return;
        }
    }

    public void connectionChanged(ConnectionChangeEvent connectionChangeEvent) {
        super.connectionChanged(connectionChangeEvent);
        if (connectionChangeEvent instanceof LpTerminatedEvent) {
            this.inPromptMode = false;
            this.waitingForHelpStatement = false;
            this.currentTasks.clear();
            this.evalutateWaitingForSyncTask();
        }
    }

    public JComponent getHeader() {
        return this.header;
    }

    public int getCurrentFontSize() {
        return this.outputPane.getCurrentFontSize();
    }

    public Font getFont() {
        return this.outputPane.getFont();
    }

    public void setTheme(ColorTheme colorTheme, Font font, int n) {
        this.setTheme(colorTheme);
        this.outputPane.setCurrentFontSize(n);
    }

    public ConsoleOutputPane getOutputPane() {
        return this.outputPane;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public static void main(String[] stringArray) throws Throwable {
        Class<?> clazz = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> clazz2 = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method method = clazz.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConsoleState {
        IDLE,
        BUSY;

    }

    public class SetStatus
    implements Runnable {
        String status;

        public SetStatus(String string) {
            this.status = string;
        }

        public void run() {
            Console.super.setStatus(this.status);
        }
    }

    public class SetWorkingState
    implements Runnable {
        ConsoleState state;

        public SetWorkingState(ConsoleState consoleState) {
            this.state = consoleState;
        }

        public void run() {
            switch (this.state) {
                case IDLE: {
                    Console.this.feedbackIcon.setEnabled(true);
                    Console.this.setLogo(Console.this.getLogo());
                    break;
                }
                case BUSY: {
                    Console.this.feedbackIcon.setEnabled(false);
                    Console.this.setLogo(new ImageIcon(this.getClass().getResource(Console.BUSY_ICON)));
                }
            }
            Console.this.updateDisplayLayout();
        }
    }

    public class StartPromptReceived
    implements Runnable {
        protected CommandEvent e;

        public StartPromptReceived(CommandEvent commandEvent) {
            this.e = commandEvent;
        }

        public void run() {
            if (Console.this.currentTasks.contains(Console.this.core.getTaskById(this.e.getId()))) {
                Console.this.pendingCmdId = this.e.getId();
                Console.this.pendingReqId = this.e.getReqId();
                Console.this.inPromptMode = true;
                Console.this.promptMessageLabel.setText(this.e.getText());
                Console.this.promptMessageLabel.setVisible(true);
                Console.super.fireContentsChanged();
                Console.this.updateDisplayLayout();
            }
        }
    }

    public class RestorePrompt
    implements Runnable {
        String text;

        RestorePrompt(String string) {
            this.text = string;
        }

        public void run() {
            Console.this.inPromptMode = true;
            Console.this.promptMessageLabel.setText(this.text);
            Console.this.promptMessageLabel.setVisible(true);
            Console.super.fireContentsChanged();
            Console.this.updateDisplayLayout();
        }
    }
}

