/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.library.console;

import ddb.GuiConstants;
import ddb.antialiasing.AntialiasedTextPane;
import ddb.console.ColorTheme;
import ddb.console.OptionPane;
import ddb.console.Themable;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.library.console.ConsoleStyledDocument;
import ddb.events.AutoScroll;
import ddb.imagemanager.ImageManager;
import ddb.listeners.RightClickListener;
import ddb.predicate.PredicateClosure;
import ddb.predicate.PredicateClosureImpl;
import ddb.util.XmlCache;
import ddb.writequeue.AbstractWritable;
import ddb.writequeue.Writable;
import ddb.writequeue.WriteQueue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.collections.functors.SwitchClosure;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ConsoleOutputPane
extends JScrollPane
implements Observer,
Themable {
    private static final String DEFAULTNODE = "Default";
    private static final String GOODNODE = "Good";
    private static final String ERRORNODE = "Error";
    private static final String WARNINGNODE = "Warning";
    private static final String NODE = "Node";
    PredicateClosure[] xmlClosures = new PredicateClosure[]{new XmlDocumentClosure("Default", OutputLevel.DEFAULT), new XmlDocumentClosure("Good", OutputLevel.NOTICE), new XmlDocumentClosure("Error", OutputLevel.ERROR), new XmlDocumentClosure("Warning", OutputLevel.WARNING), new PredicateClosure(){

        public boolean evaluate(Object object) {
            if (!(object instanceof Node)) {
                return false;
            }
            for (Node node = (Node)object; node != null; node = node.getNextSibling()) {
                if (node.getNodeName() == null) continue;
                return node.getNodeName().equals(ConsoleOutputPane.NODE);
            }
            return false;
        }

        public void execute(Object object) {
            Node node = (Node)object;
            if (node.getNodeName() == null) {
                return;
            }
            if (node.getNodeValue() == null) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    String string;
                    Node node3;
                    OutputLevel outputLevel = OutputLevel.DEFAULT;
                    if (node.getAttributes() != null && (node3 = node.getAttributes().getNamedItem("type")) != null && (string = node3.getNodeValue()) != null) {
                        if (string.equals(ConsoleOutputPane.DEFAULTNODE)) {
                            outputLevel = OutputLevel.DEFAULT;
                        } else if (string.equals(ConsoleOutputPane.GOODNODE)) {
                            outputLevel = OutputLevel.NOTICE;
                        } else if (string.equals(ConsoleOutputPane.WARNINGNODE)) {
                            outputLevel = OutputLevel.WARNING;
                        } else if (string.equals(ConsoleOutputPane.ERRORNODE)) {
                            outputLevel = OutputLevel.ERROR;
                        }
                    }
                    ConsoleOutputPane.this.appendOutputMessage(node2.getNodeValue(), outputLevel);
                }
            } else {
                OutputLevel outputLevel = OutputLevel.DEFAULT;
                Node node4 = node.getAttributes().getNamedItem("type");
                if (node4 == null) {
                    outputLevel = OutputLevel.DEFAULT;
                } else if (node4.equals(ConsoleOutputPane.DEFAULTNODE)) {
                    outputLevel = OutputLevel.DEFAULT;
                } else if (node4.equals(ConsoleOutputPane.GOODNODE)) {
                    outputLevel = OutputLevel.NOTICE;
                } else if (node4.equals(ConsoleOutputPane.WARNINGNODE)) {
                    outputLevel = OutputLevel.WARNING;
                } else if (node4.equals(ConsoleOutputPane.ERRORNODE)) {
                    outputLevel = OutputLevel.ERROR;
                }
                ConsoleOutputPane.this.appendOutputMessage(node.getNodeValue(), outputLevel);
            }
        }
    }};
    Closure appendText = new Closure(){

        public void execute(Object object) {
            if (object != null) {
                ConsoleOutputPane.this.appendOutputMessage(object.toString(), OutputLevel.DEFAULT);
            }
        }
    };
    Transformer textToDoc = new Transformer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object transform(Object object) {
            DocumentBuilder documentBuilder;
            String string = "";
            if (object != null) {
                string = object.toString();
            }
            if ((documentBuilder = XmlCache.getBuilder()) == null) {
                return string;
            }
            try {
                org.w3c.dom.Document document;
                org.w3c.dom.Document document2 = document = documentBuilder.parse(new InputSource(new StringReader(string)));
                return document2;
            }
            catch (Exception exception) {
                String string2 = string;
                return string2;
            }
            finally {
                XmlCache.releaseBuilder((DocumentBuilder)documentBuilder);
            }
        }
    };
    Closure handleDisplay = new Closure(){

        public void execute(Object object) {
            Object object2 = ConsoleOutputPane.this.textToDoc.transform(object);
            if (object2 != null && object2 instanceof org.w3c.dom.Document) {
                org.w3c.dom.Document document = (org.w3c.dom.Document)object2;
                Node node = document.getDocumentElement();
                if ("Xml".equals(node.getNodeName())) {
                    node = node.getFirstChild();
                }
                boolean bl = false;
                while (node != null) {
                    for (int i = 0; i < ConsoleOutputPane.this.xmlClosures.length && node.getNodeType() == 1; ++i) {
                        if (!ConsoleOutputPane.this.xmlClosures[i].evaluate((Object)node)) continue;
                        ConsoleOutputPane.this.xmlClosures[i].execute((Object)node);
                        bl = true;
                        break;
                    }
                    node = node.getNextSibling();
                }
                if (bl) {
                    return;
                }
            }
            ConsoleOutputPane.this.appendText.execute(object);
        }
    };
    public static final int DEFAULT_MAX_CHARS = 400000;
    protected Style boldStyle;
    protected int currentFontSize;
    private AttributeSet currentStyle;
    protected Style defaultStyle;
    protected final Object DOC_LOCK = new Object();
    protected Style docProvidedStyle;
    protected Style errorStyle;
    protected Style noticeStyle;
    protected ConsoleStyledDocument outputDoc;
    protected boolean wordWrap = false;
    private ColorTheme currentTheme = null;
    private final List<Themable> connectedThemables = new Vector<Themable>();
    PredicateClosure[] items = new PredicateClosure[]{new PredicateClosureImpl(InstanceofPredicate.getInstance(ReapplyStyles.class), new Closure(){

        public void execute(Object object) {
            Element element = ConsoleOutputPane.this.outputDoc.getDefaultRootElement();
            Style style = ((ReapplyStyles)((Object)ReapplyStyles.class.cast(object))).getStyle();
            int n = element.getElementCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                Element element2 = element.getElement(i);
                AttributeSet attributeSet = element2.getAttributes();
                String string = (String)attributeSet.getAttribute(StyleConstants.NameAttribute);
                if (style.getName().equals(string)) {
                    n2 = element2.getStartOffset();
                    int n3 = element2.getEndOffset();
                    ConsoleOutputPane.this.outputDoc.setParagraphAttributes(n2, n3 - n2, style, true);
                }
                for (n2 = 0; n2 < element2.getElementCount(); ++n2) {
                    Element element3 = element2.getElement(n2);
                    attributeSet = element3.getAttributes();
                    string = (String)attributeSet.getAttribute(StyleConstants.NameAttribute);
                    if (!style.getName().equals(string)) continue;
                    int n4 = element3.getStartOffset();
                    int n5 = element3.getEndOffset();
                    ConsoleOutputPane.this.outputDoc.setCharacterAttributes(n4, n5 - n4, style, true);
                }
            }
        }
    }), new PredicateClosureImpl(InstanceofPredicate.getInstance(TextBlock.class), new Closure(){

        public void execute(Object object) {
            TextBlock textBlock = (TextBlock)((Object)TextBlock.class.cast(object));
            ConsoleOutputPane.this.appendTextToPane(textBlock.getText(), textBlock.getStyle());
        }
    }), new PredicateClosureImpl(InstanceofPredicate.getInstance(TextClear.class), new Closure(){

        public void execute(Object object) {
            ConsoleOutputPane.this.outputDoc.clear();
        }
    })};
    WriteQueue<Writable> writer2 = new WriteQueue((Closure)new SwitchClosure((Predicate[])this.items, (Closure[])this.items, ClosureUtils.nopClosure()), false);
    private StringBuilder sb = new StringBuilder();
    boolean shouldStop = false;
    protected AntialiasedTextPane textPane;
    protected Style warningStyle;
    protected CoreController core;
    private AutoScroll auto;
    protected JToggleButton.ToggleButtonModel inputPaused = new JToggleButton.ToggleButtonModel();
    private int MaximumCharacters = Integer.MAX_VALUE;

    public void disableDisplay() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }

    public void enableDisplay() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }

    public void appendDisplay(String string) {
        this.handleDisplay.execute((Object)string);
    }

    public ConsoleOutputPane(CoreController coreController) {
        this(coreController, 3000);
    }

    public ConsoleOutputPane(CoreController coreController, int n) {
        this.core = coreController;
        OptionPane.getInstance().addDirectory(coreController.getUserConfigDirectory() + "/Console");
        for (String string : coreController.getResourcePackages()) {
            OptionPane.getInstance().addDirectory(String.format("%s/%s", coreController.getResourceDirectory(), string));
        }
        this.inputPaused.setSelected(this.writer2.isPaused());
        this.inputPaused.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleOutputPane.this.writer2.setPaused(ConsoleOutputPane.this.inputPaused.isSelected());
            }
        });
        this.MaximumCharacters = n * 100;
        if (this.MaximumCharacters < 0) {
            this.MaximumCharacters = Integer.MAX_VALUE;
        }
        this.textPane = new AntialiasedTextPane(){

            public boolean getScrollableTracksViewportWidth() {
                return ConsoleOutputPane.this.wordWrap;
            }
        };
        this.textPane.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                while (ConsoleOutputPane.this.textPane.getSelectionEnd() - 1 > ConsoleOutputPane.this.textPane.getSelectionStart()) {
                    try {
                        String string = ConsoleOutputPane.this.textPane.getText(ConsoleOutputPane.this.textPane.getSelectionEnd() - 1, 1);
                        if (!string.equals("\r") && !string.equals("\n")) break;
                        ConsoleOutputPane.this.textPane.setSelectionEnd(ConsoleOutputPane.this.textPane.getSelectionEnd() - 1);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                        break;
                    }
                }
                if (ConsoleOutputPane.this.textPane.getSelectionEnd() != ConsoleOutputPane.this.textPane.getSelectionStart()) {
                    ConsoleOutputPane.this.textPane.copy();
                }
            }
        });
        this.outputDoc = new ConsoleStyledDocument();
        this.outputDoc.setMaximumCharacters(this.MaximumCharacters);
        this.textPane.setDocument((Document)this.outputDoc);
        this.textPane.setEditable(false);
        this.textPane.setCaret((Caret)new DefaultCaret(){

            protected void adjustVisibility(Rectangle rectangle) {
            }

            public void setSelectionVisible(boolean bl) {
                super.setSelectionVisible(true);
            }
        });
        super.setViewportView((Component)this.textPane);
        this.setAutoscrolls(true);
        this.setVerticalScrollBarPolicy(22);
        this.currentFontSize = GuiConstants.FIXED_WIDTH_FONT.size;
        this.docProvidedStyle = this.outputDoc.getStyle("default");
        this.defaultStyle = this.outputDoc.addStyle("defaultStyle", this.docProvidedStyle);
        this.errorStyle = this.outputDoc.addStyle("error", this.defaultStyle);
        this.warningStyle = this.outputDoc.addStyle("warning", this.defaultStyle);
        this.noticeStyle = this.outputDoc.addStyle("notice", this.defaultStyle);
        this.boldStyle = this.outputDoc.addStyle("bold", this.defaultStyle);
        StyleConstants.setBold(this.boldStyle, true);
        this.outputDoc.setAsynchronousLoadPriority(3);
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItem("Copy", "images/editcopy.png", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleOutputPane.this.copy();
            }
        }, jPopupMenu);
        this.addMouseListener((MouseListener)new RightClickListener(jPopupMenu));
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Pause Input");
        jCheckBoxMenuItem.setModel(this.inputPaused);
        jPopupMenu.add(jCheckBoxMenuItem);
        this.addMenuItem("Change Theme", null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorTheme colorTheme = OptionPane.getInstance().displayThemeSelectionDialog(ConsoleOutputPane.this.currentTheme);
                if (colorTheme == null) {
                    return;
                }
                ConsoleOutputPane.this.setTheme(colorTheme);
            }
        }, jPopupMenu);
        if (coreController != null) {
            coreController.setupKeyBindings((JComponent)this);
        }
        this.setCurrentFontSize(this.currentFontSize);
        this.auto = new AutoScroll((JScrollPane)this);
        this.setBackground(Color.BLACK);
        if (this.currentTheme == null) {
            this.currentTheme = new ColorTheme(DEFAULTNODE);
        }
    }

    public void setAutoScroll(boolean bl) {
        this.auto.setScroll(bl);
    }

    public boolean getAutoScroll() {
        return this.auto.getScroll();
    }

    private void addMenuItem(String string, String string2, ActionListener actionListener, JPopupMenu jPopupMenu) {
        jPopupMenu.add(this.createMenuItem(string, string2, actionListener));
    }

    private JMenuItem createMenuItem(String string, String string2, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (string2 != null) {
            jMenuItem.setIcon(ImageManager.getIcon((String)string2, (Dimension)ImageManager.SIZE16));
        }
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public void setMaximumCharacters(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFocusRelayListener(FocusListener focusListener) {
        ConsoleOutputPane consoleOutputPane = this;
        synchronized (consoleOutputPane) {
            super.addFocusListener(focusListener);
            this.textPane.addFocusListener(focusListener);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.textPane.addMouseListener(mouseListener);
    }

    public void appendOutputMessage(String string, OutputLevel outputLevel) {
        switch (outputLevel) {
            case DEFAULT: {
                this.appendStyledStringToOutput(string, this.defaultStyle);
                break;
            }
            case ERROR: {
                this.appendStyledStringToOutput(string, this.errorStyle);
                break;
            }
            case WARNING: {
                this.appendStyledStringToOutput(string, this.warningStyle);
                break;
            }
            case NOTICE: {
                this.appendStyledStringToOutput(string, this.noticeStyle);
                break;
            }
            case BOLD: {
                this.appendStyledStringToOutput(string, this.boldStyle);
                break;
            }
            default: {
                this.appendStyledStringToOutput(string, this.defaultStyle);
            }
        }
    }

    public void appendStyledStringToOutput(String string, AttributeSet attributeSet) {
        int n = string.length() - this.MaximumCharacters;
        if (n > 0) {
            this.offer((Writable)new TextClear());
            string = string.substring(n, string.length());
        }
        this.offer((Writable)new TextBlock(string, attributeSet));
    }

    void appendTextToPane(String string, AttributeSet attributeSet) {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n == 0) {
            return;
        }
        try {
            this.outputDoc.appendString(string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void appendToOutput(String string) {
        this.appendOutputMessage(string, OutputLevel.DEFAULT);
    }

    public void clearAndReplace(String string) {
        this.offer((Writable)new TextClear());
        this.appendOutputMessage(string, OutputLevel.DEFAULT);
    }

    private void offer(Writable writable) {
        this.writer2.enqueue(writable);
    }

    public void copy() {
        this.textPane.copy();
    }

    public void decreaseFontSize() {
        this.setFontSize(--this.currentFontSize);
    }

    void flush() {
        if (this.sb.length() == 0) {
            return;
        }
        this.appendTextToPane(this.sb.toString(), this.currentStyle);
        this.sb.setLength(0);
        this.currentStyle = null;
    }

    public int getCurrentFontSize() {
        return this.currentFontSize;
    }

    private Style getStyle(StyleTypes styleTypes) {
        Style style = null;
        switch (styleTypes) {
            case DEFAULT: {
                style = this.defaultStyle;
                break;
            }
            case ERROR: {
                style = this.errorStyle;
                break;
            }
            case WARNING: {
                style = this.warningStyle;
                break;
            }
            case NOTICE: {
                style = this.noticeStyle;
                break;
            }
            case BOLD: {
                style = this.boldStyle;
            }
        }
        return style;
    }

    public void increaseFontSize() {
        this.setFontSize(++this.currentFontSize);
    }

    public void reapplyStyles(Style style) {
        this.offer((Writable)new ReapplyStyles(style));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFocusRelayListener(FocusListener focusListener) {
        ConsoleOutputPane consoleOutputPane = this;
        synchronized (consoleOutputPane) {
            super.removeFocusListener(focusListener);
            this.textPane.removeFocusListener(focusListener);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.textPane.removeMouseListener(mouseListener);
    }

    public void resetFontSizeToDefault() {
        this.currentFontSize = GuiConstants.FIXED_WIDTH_FONT.size;
        this.setFontSize(this.currentFontSize);
    }

    private void setBackgroundColor(Color color) {
        this.textPane.setBackground(color);
        this.setBackground(color);
        this.textPane.setSelectionColor(this.textPane.getForeground());
    }

    public void setCurrentFontSize(int n) {
        this.currentFontSize = n;
        this.setFontSize(this.currentFontSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFontSize(int n) {
        Object object = this.DOC_LOCK;
        synchronized (object) {
            StyleConstants.setFontSize(this.docProvidedStyle, n);
            Font font = this.outputDoc.getFont(this.docProvidedStyle);
            JLabel jLabel = new JLabel("    ");
            jLabel.setFont(font);
            int n2 = jLabel.getPreferredSize().width;
            Vector<TabStop> vector = new Vector<TabStop>();
            for (int i = 0; i < 20; ++i) {
                vector.add(new TabStop(n2 * i));
            }
            TabStop[] tabStopArray = new TabStop[vector.size()];
            tabStopArray = vector.toArray(tabStopArray);
            TabSet tabSet = new TabSet(tabStopArray);
            Enumeration<?> enumeration = this.outputDoc.getStyleNames();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                StyleConstants.setTabSet(this.outputDoc.getStyle(string), tabSet);
            }
        }
    }

    private void setForegroundColor(Color color) {
        this.textPane.setForeground(color);
        this.textPane.setCaretColor(color);
        this.textPane.setSelectionColor(this.textPane.getForeground());
        this.textPane.setSelectedTextColor(this.textPane.getBackground());
    }

    public void setTextBackgroundColor(StyleTypes styleTypes, Color color) {
        Style style = this.getStyle(styleTypes);
        if (style == null) {
            return;
        }
        StyleConstants.setBackground(style, color);
        if (styleTypes == StyleTypes.DEFAULT) {
            this.setBackgroundColor(color);
            StyleConstants.setBackground(this.boldStyle, color);
            this.reapplyStyles(this.boldStyle);
        }
        this.reapplyStyles(style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTheme(ColorTheme colorTheme) {
        if (colorTheme == null) {
            return;
        }
        if (this.currentTheme != null) {
            this.currentTheme.deleteObserver((Observer)this);
        }
        this.currentTheme = colorTheme;
        this.currentTheme.addObserver((Observer)this);
        this.applyTheme(colorTheme);
        List<Themable> list = this.connectedThemables;
        synchronized (list) {
            for (Themable themable : this.connectedThemables) {
                themable.setTheme(colorTheme);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectedThemable(Themable themable) {
        List<Themable> list = this.connectedThemables;
        synchronized (list) {
            this.connectedThemables.add(themable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectedThemable(Themable themable) {
        List<Themable> list = this.connectedThemables;
        synchronized (list) {
            this.connectedThemables.remove(themable);
        }
    }

    public ColorTheme getTheme() {
        return this.currentTheme;
    }

    private void applyTheme(ColorTheme colorTheme) {
        this.setTextColor(StyleTypes.ERROR, colorTheme.getValue(ColorTheme.Location.ErrorForeground));
        this.setTextBackgroundColor(StyleTypes.ERROR, colorTheme.getValue(ColorTheme.Location.ErrorBackground));
        this.setTextColor(StyleTypes.DEFAULT, colorTheme.getValue(ColorTheme.Location.NormalForeground));
        this.setTextBackgroundColor(StyleTypes.DEFAULT, colorTheme.getValue(ColorTheme.Location.NormalBackground));
        this.setTextColor(StyleTypes.BOLD, colorTheme.getValue(ColorTheme.Location.NormalForeground));
        this.setTextBackgroundColor(StyleTypes.BOLD, colorTheme.getValue(ColorTheme.Location.NormalBackground));
        this.setTextColor(StyleTypes.NOTICE, colorTheme.getValue(ColorTheme.Location.NoticeForeground));
        this.setTextBackgroundColor(StyleTypes.NOTICE, colorTheme.getValue(ColorTheme.Location.NoticeBackground));
        this.setTextColor(StyleTypes.WARNING, colorTheme.getValue(ColorTheme.Location.WarningForeground));
        this.setTextBackgroundColor(StyleTypes.WARNING, colorTheme.getValue(ColorTheme.Location.WarningBackground));
        this.setBackground(colorTheme.getValue(ColorTheme.Location.NormalBackground));
        this.getViewport().setBackground(colorTheme.getValue(ColorTheme.Location.NormalBackground));
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof ColorTheme) {
            this.applyTheme((ColorTheme)ColorTheme.class.cast(observable));
        }
    }

    public void setTextColor(StyleTypes styleTypes, Color color) {
        Style style = this.getStyle(styleTypes);
        if (style == null) {
            return;
        }
        StyleConstants.setForeground(style, color);
        if (styleTypes == StyleTypes.DEFAULT) {
            this.setForegroundColor(color);
            StyleConstants.setForeground(this.boldStyle, color);
            this.reapplyStyles(this.boldStyle);
        }
        this.reapplyStyles(style);
    }

    public void stop() {
        this.shouldStop = true;
        this.writer2.stop();
    }

    public JTextComponent getTextPane() {
        return this.textPane;
    }

    public void passInMouseListener(MouseListener mouseListener) {
        this.textPane.addMouseListener(mouseListener);
    }

    public void setWordWrap(boolean bl) {
        this.wordWrap = bl;
        this.textPane.revalidate();
    }

    public boolean getWordWrap() {
        return this.wordWrap;
    }

    public void setPaused(boolean bl) {
        this.inputPaused.setSelected(bl);
        for (ActionListener actionListener : this.inputPaused.getActionListeners()) {
            actionListener.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public boolean isPaused() {
        return this.inputPaused.isSelected();
    }

    public ButtonModel getPausedModel() {
        return this.inputPaused;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StyleTypes {
        DEFAULT,
        ERROR,
        WARNING,
        NOTICE,
        BOLD;

    }

    private class XmlDocumentClosure
    implements PredicateClosure {
        String nodeName;
        OutputLevel style;

        public XmlDocumentClosure(String string, OutputLevel outputLevel) {
            this.nodeName = string;
            this.style = outputLevel;
        }

        public boolean evaluate(Object object) {
            if (!(object instanceof Node)) {
                return false;
            }
            for (Node node = (Node)object; node != null; node = node.getNextSibling()) {
                if (node.getNodeName() == null) continue;
                return node.getNodeName().equals(this.nodeName);
            }
            return false;
        }

        public void execute(Object object) {
            Node node = (Node)object;
            if (node.getNodeName() == null) {
                return;
            }
            if (node.getNodeValue() == null) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    ConsoleOutputPane.this.appendOutputMessage(node2.getNodeValue(), this.style);
                }
            } else {
                ConsoleOutputPane.this.appendOutputMessage(node.getNodeValue(), this.style);
            }
        }
    }

    class TextClear
    extends AbstractWritable {
        TextClear() {
        }

        public boolean resets() {
            return true;
        }
    }

    class TextBlock
    extends AbstractWritable {
        StringBuilder sb = new StringBuilder();
        AttributeSet style;

        public TextBlock(String string, AttributeSet attributeSet) {
            this.sb.append(string);
            this.style = attributeSet;
        }

        public String getText() {
            return this.sb.toString();
        }

        public AttributeSet getStyle() {
            return this.style;
        }

        public boolean resets() {
            return this.sb.length() >= ConsoleOutputPane.this.MaximumCharacters;
        }

        public boolean combine(Writable writable) {
            TextBlock textBlock;
            if (writable instanceof TextBlock && (textBlock = (TextBlock)((Object)TextBlock.class.cast(writable))).getStyle().equals(this.getStyle())) {
                this.sb.append(textBlock.getText());
                return true;
            }
            return false;
        }
    }

    class ReapplyStyles
    extends AbstractWritable {
        Style style;

        public ReapplyStyles(Style style) {
            this.style = style;
        }

        public Style getStyle() {
            return this.style;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputLevel {
        DEFAULT,
        NOTICE,
        WARNING,
        ERROR,
        BOLD;

    }
}

