/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.library.console;

import ddb.dsz.library.console.Console;
import ddb.dsz.library.console.HistoryFileParserWriter;
import ddb.history.History;
import ddb.util.FileExtensionFilter;
import ddb.util.XMLException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadSaveHistoryAction
extends AbstractAction {
    private final Component parent;
    private History<String> history;
    private final HistoryActionType mode;
    private final URL historyFile;
    private static final Object CHOOSER_LOCK = new Object();
    private static JFileChooser fileChooser = null;

    public LoadSaveHistoryAction(Console console, Component component, History<String> history, HistoryActionType historyActionType) {
        this.parent = component;
        this.history = history;
        this.mode = historyActionType;
        this.historyFile = LoadSaveHistoryAction.class.getClassLoader().getResource(console.getHistory());
    }

    private static JFileChooser getFileChooser(URL uRL) {
        String string;
        JFileChooser jFileChooser = new JFileChooser();
        if (uRL != null) {
            string = uRL.getPath();
            jFileChooser.setCurrentDirectory(new File(string));
        }
        string = new FileExtensionFilter("xml", true);
        jFileChooser.addChoosableFileFilter((FileFilter)((Object)string));
        jFileChooser.setMultiSelectionEnabled(false);
        return jFileChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = CHOOSER_LOCK;
        synchronized (object) {
            if (fileChooser == null) {
                fileChooser = LoadSaveHistoryAction.getFileChooser(this.historyFile);
            }
            if (fileChooser == null) {
                return;
            }
        }
        fileChooser.updateUI();
        int n = 2;
        switch (this.mode) {
            case LOAD: {
                n = fileChooser.showOpenDialog(this.parent);
                break;
            }
            case SAVE: {
                n = fileChooser.showSaveDialog(this.parent);
            }
        }
        switch (n) {
            case -1: 
            case 1: {
                return;
            }
            case 0: {
                switch (this.mode) {
                    case LOAD: {
                        this.loadHistoryFile(fileChooser.getSelectedFile());
                        break;
                    }
                    case SAVE: {
                        this.saveHistoryFile(fileChooser.getSelectedFile(), this.history.toList());
                    }
                }
                return;
            }
        }
    }

    private void loadHistoryFile(File file) {
        List<String> list;
        try {
            list = HistoryFileParserWriter.parse(file.getPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showErrorDialog(fileNotFoundException);
            return;
        }
        catch (XMLException xMLException) {
            this.showErrorDialog(xMLException);
            return;
        }
        Iterator<String> iterator = list.iterator();
        this.history.clear();
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.history.addHistoryItem((Object)string);
        }
    }

    private void saveHistoryFile(File file, List<String> list) {
        try {
            HistoryFileParserWriter.save(list, file.getAbsolutePath());
        }
        catch (XMLException xMLException) {
            this.showErrorDialog(xMLException);
            return;
        }
        catch (IOException iOException) {
            this.showErrorDialog(iOException);
            return;
        }
    }

    public void showErrorDialog(Throwable throwable) {
        throwable.printStackTrace();
        JOptionPane.showMessageDialog(this.parent, "<pre>" + throwable.toString() + "</pre>", "Error", 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HistoryActionType {
        LOAD,
        SAVE;

    }
}

