/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.library.console;

import ddb.dsz.core.controller.CommandInfo;
import ddb.dsz.core.controller.CommandSet;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedCommandLine {
    protected String commandLine;
    protected String commandName;
    protected List<String> prefixes;
    protected List<String> options;
    protected String arguments;
    protected List<CommandInfo> commandInfo;
    protected String lastWord;
    protected String lineWithoutLastWord;
    protected boolean endsWithSpace;
    protected CommandSet commandSet;

    public ParsedCommandLine(String string, CommandSet commandSet) {
        this.commandSet = commandSet;
        this.parseLine(string);
    }

    public ParsedCommandLine(ParsedCommandLine parsedCommandLine) {
        this(parsedCommandLine.getCommandLine(), parsedCommandLine.getCommandSet());
    }

    public void parseLine(String string) {
        this.initialize();
        this.commandLine = string;
        this.endsWithSpaceCheck();
        this.findLastWord();
        this.findLineWithoutLastWord();
        this.findCommand();
        this.findPrefixes();
        this.findArgumentString();
        this.findOptions();
    }

    private void initialize() {
        this.commandLine = null;
        this.commandName = null;
        this.prefixes = new Vector<String>();
        this.options = new Vector<String>();
        this.arguments = null;
        this.commandInfo = new Vector<CommandInfo>();
        this.lastWord = null;
        this.lineWithoutLastWord = null;
        this.endsWithSpace = false;
    }

    private void endsWithSpaceCheck() {
        this.endsWithSpace = this.commandLine.endsWith(" ");
    }

    private void findLastWord() {
        if (this.commandLine.trim().length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.commandLine);
        while (stringTokenizer.hasMoreTokens()) {
            this.lastWord = stringTokenizer.nextToken();
        }
        if (this.lastWord == null) {
            this.lastWord = "";
        }
    }

    private void findLineWithoutLastWord() {
        if (this.lastWord == null) {
            this.lineWithoutLastWord = this.commandLine;
            return;
        }
        int n = this.commandLine.lastIndexOf(this.lastWord);
        this.lineWithoutLastWord = this.commandLine.substring(0, n);
    }

    private void findCommand() {
        this.commandInfo.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(this.commandLine);
        while (stringTokenizer.hasMoreTokens()) {
            List list;
            String string = stringTokenizer.nextToken();
            int n = string.indexOf(61);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if ((list = this.commandSet.getAllCommands(string)).size() == 0) {
                this.commandName = null;
                this.commandInfo = null;
                return;
            }
            for (CommandInfo commandInfo : list) {
                if (!commandInfo.isOrContainsCommand()) continue;
                this.commandInfo.add(commandInfo);
                CommandInfo commandInfo2 = this.commandSet.getCommandByName(commandInfo.getExpansionCommand());
                if (!commandInfo.isAlias() || commandInfo2 == null) continue;
                this.commandInfo.add(commandInfo2);
            }
            if (this.commandInfo.size() <= 0) continue;
            this.commandName = string;
            break;
        }
    }

    private void findPrefixes() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.commandLine);
        while (stringTokenizer.hasMoreTokens()) {
            CommandInfo commandInfo;
            String string = stringTokenizer.nextToken();
            int n = string.indexOf(61);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if ((commandInfo = this.commandSet.getCommandByName(string)) == null) {
                return;
            }
            if (!commandInfo.isOrContainsCommand()) {
                this.prefixes.add(string);
                continue;
            }
            return;
        }
    }

    private void findArgumentString() {
        if (this.commandName == null) {
            return;
        }
        int n = this.commandLine.indexOf(this.commandName);
        int n2 = n + this.commandName.length();
        if (n2 < this.commandLine.length()) {
            this.arguments = this.commandLine.substring(n2);
        }
    }

    private void findOptions() {
        if (this.commandName == null) {
            return;
        }
        if (this.arguments == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : this.commandInfo) {
            for (String string : object.getOptions()) {
                hashSet.add(String.format("%s%s", object.getOptionPrefix(), string).toLowerCase());
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.arguments);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            object = stringTokenizer.nextToken().toLowerCase();
            if (!hashSet.contains(object)) continue;
            this.options.add((String)object);
        }
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getArguments() {
        return this.arguments;
    }

    public List<CommandInfo> getCommandInfo() {
        return this.commandInfo;
    }

    public void setCommandLine(String string) {
        this.parseLine(string);
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public boolean endsWithSpace() {
        return this.endsWithSpace;
    }

    public String getLastWord() {
        return this.lastWord;
    }

    public String getLineWithoutLastWord() {
        return this.lineWithoutLastWord;
    }

    private CommandSet getCommandSet() {
        return this.commandSet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("line: '" + this.commandLine + "'\n");
        stringBuilder.append("command: '" + this.commandName + "'\n");
        for (CommandInfo commandInfo : this.commandInfo) {
            stringBuilder.append("commandInfo: '" + commandInfo.debugToString() + "'\n");
        }
        stringBuilder.append("line w/o last word: '" + this.lineWithoutLastWord + "'\n");
        stringBuilder.append("last word: '" + this.lastWord + "'\n");
        stringBuilder.append("ends with space: '" + this.endsWithSpace + "'\n");
        return stringBuilder.toString();
    }
}

