/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.library.console.builtins;

import ddb.dsz.library.console.BuiltinHandler;
import ddb.dsz.library.console.Console;
import ddb.dsz.library.console.builtins.BuiltinHandlerAdapter;
import ddb.dsz.library.console.jaxb.consolecommands.Argument;
import ddb.dsz.library.console.jaxb.consolecommands.Command;
import ddb.dsz.library.console.jaxb.consolecommands.Split;
import ddb.dsz.library.console.jaxb.consolecommands.Statement;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinCommand {
    private String name;
    private BuiltinHandler handler;
    private String helpStatement;

    public BuiltinCommand(String string) {
        this.name = string;
    }

    public BuiltinHandler getHandler() {
        return this.handler;
    }

    public void setHandler(BuiltinHandler builtinHandler) {
        this.handler = builtinHandler;
    }

    public String getHelpStatement() {
        return this.helpStatement;
    }

    public void setHelpStatement(String string) {
        this.helpStatement = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public static BuiltinCommand generate(Console console, final Command command, final Map<String, BuiltinCommand> map) {
        BuiltinCommand builtinCommand = new BuiltinCommand(command.getName());
        builtinCommand.setHelpStatement(command.getHelp());
        builtinCommand.setHandler(new BuiltinHandlerAdapter(console){

            public boolean executeBuiltinCommand(String string, String string2) {
                String string3 = this.getValue(string, string2, command.getCommand());
                String string4 = this.getValue(string, string2, command.getArgs());
                if (map.get(string3) != null) {
                    return ((BuiltinCommand)map.get(string3)).getHandler().executeBuiltinCommand(string3, string4);
                }
                return false;
            }

            private String getValue(String string, String string2, Statement statement) {
                if (statement.getValue() != null) {
                    return statement.getValue();
                }
                if (statement.getNull() != null) {
                    return null;
                }
                Argument argument = statement.getArgument();
                if (argument.getFormat() != null) {
                    return argument.getFormat().replaceAll("%COMMAND%", string).replaceAll("%ARGS%", string2);
                }
                if (argument.getSplit() != null) {
                    Split split = argument.getSplit();
                    String string3 = split.getString().replaceAll("%COMMAND%", string).replaceAll("%ARGS%", string2);
                    String[] stringArray = string3.split(split.getRegex(), split.getLimit());
                    if (stringArray == null) {
                        return split.getDefault();
                    }
                    if (split.getPart() < 0) {
                        return split.getDefault();
                    }
                    if (stringArray.length < split.getPart()) {
                        return split.getDefault();
                    }
                    return stringArray[split.getPart()];
                }
                return null;
            }
        });
        return builtinCommand;
    }
}

