/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer;

import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.netmapviewer.Resource;
import ddb.dsz.plugin.netmapviewer.data.Arp;
import ddb.dsz.plugin.netmapviewer.data.Group;
import ddb.dsz.plugin.netmapviewer.data.IfConfig;
import ddb.dsz.plugin.netmapviewer.data.Netmap;
import ddb.dsz.plugin.netmapviewer.data.Ping;
import ddb.dsz.plugin.netmapviewer.data.Service;
import ddb.dsz.plugin.netmapviewer.data.Traceroute;
import ddb.dsz.plugin.netmapviewer.data.User;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    Order order = Order.Default;
    private HashSet<Arp> arps = new HashSet();
    private HashMap<Task, String> printingCommandsList = new HashMap();
    private Netmap netmapData = null;
    private IfConfig ifconfigData = null;
    private List<Ping> pings = new Vector<Ping>();
    private List<Resource> resources = new Vector<Resource>();
    private List<Traceroute> traceroutes = new Vector<Traceroute>();
    private Set<Group> groups = new TreeSet<Group>();
    private List<Service> services = new Vector<Service>();
    private Set<User> users = new TreeSet<User>();
    private Set<String> addresses = new HashSet<String>();
    private boolean matchable = true;
    private String name = "Unknown";
    private boolean updated = false;

    public boolean isUpdated() {
        return this.updated;
    }

    public void viewed() {
        this.updated = false;
    }

    public void changed() {
        this.updated = true;
    }

    public void removeDataset(DataTypes dataTypes) {
        switch (dataTypes) {
            case ArpType: {
                this.arps.clear();
                break;
            }
            case PingType: {
                this.pings.clear();
                break;
            }
            case ResourceType: {
                this.resources.clear();
                break;
            }
            case TracerouteType: {
                this.traceroutes.clear();
            }
        }
    }

    public void setMatchable(boolean bl) {
        this.matchable = bl;
    }

    public Collection<String> getAddresses() {
        if (!this.matchable) {
            return Collections.emptyList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.addresses);
        for (Arp data : this.getArps()) {
            hashSet.add(data.getInetAddress());
            hashSet.add(data.getPhysAddress());
        }
        if (this.getNetmapData() != null) {
            hashSet.addAll(this.getNetmapData().getAddresses());
        }
        for (Ping ping : this.getPings()) {
            hashSet.add(ping.getDestination());
        }
        for (Traceroute traceroute : this.getTraceroutes()) {
            hashSet.add(traceroute.getLocation());
        }
        if (this.ifconfigData != null) {
            hashSet.addAll(this.ifconfigData.getAddresses());
        }
        return hashSet;
    }

    public HashSet<Arp> getArps() {
        return this.arps;
    }

    public void addArp(Arp arp) {
        if (this.arps.add(arp)) {
            this.updated = true;
        }
    }

    public void setIfconfig(IfConfig ifConfig) {
        this.ifconfigData = ifConfig;
    }

    public IfConfig getIfConfig() {
        return this.ifconfigData;
    }

    public void addAddress(String string) {
        this.addresses.add(string);
    }

    public synchronized List<Task> getPrintedCommands() {
        Vector<Task> vector = new Vector<Task>();
        vector.addAll(this.printingCommandsList.keySet());
        Collections.sort(vector, Task.TaskComparator);
        return vector;
    }

    public synchronized String getPrintedCommand(Task task) {
        return this.printingCommandsList.get(task);
    }

    public synchronized void addPrintingCommandEntry(Task task, String string) {
        String string2 = this.printingCommandsList.get(task);
        if (string2 != null) {
            this.printingCommandsList.put(task, String.format("%s%s", string2, string));
        } else {
            this.printingCommandsList.put(task, string);
        }
        this.updated = true;
    }

    public Netmap getNetmapData() {
        return this.netmapData;
    }

    public void addService(Service service) {
        this.services.add(service);
        this.updated = true;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void addUser(User user) {
        this.users.add(user);
        this.updated = true;
    }

    public List<User> getUsers() {
        Vector<User> vector = new Vector<User>();
        vector.addAll(this.users);
        return vector;
    }

    public List<Group> getGroups() {
        Vector<Group> vector = new Vector<Group>();
        vector.addAll(this.groups);
        return vector;
    }

    public void addGroup(Group group) {
        this.groups.add(group);
        this.updated = true;
    }

    public void setNetmapData(Netmap netmap) {
        this.netmapData = netmap;
        this.updated = true;
    }

    public void addPing(Ping ping) {
        this.pings.add(ping);
        this.updated = true;
    }

    public List<Ping> getPings() {
        return this.pings;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
        this.updated = true;
    }

    public boolean doesNameMatch(String string) {
        if (string == null ? this.name == null : string.equals(this.name)) {
            return true;
        }
        if (this.netmapData != null) {
            return this.netmapData.getName().equalsIgnoreCase(string);
        }
        return this.name.equalsIgnoreCase(string);
    }

    public boolean doesAddressMatch(String string) {
        if (string == null) {
            return false;
        }
        return this.getAddresses().contains(string.toLowerCase());
    }

    public List<Traceroute> getTraceroutes() {
        return this.traceroutes;
    }

    public void addTraceroute(Traceroute traceroute) {
        if (this.traceroutes.contains(traceroute)) {
            return;
        }
        this.traceroutes.add(traceroute);
        this.updated = true;
    }

    public String toString() {
        if (this.ifconfigData != null) {
            return this.ifconfigData.getHostName();
        }
        if (this.netmapData != null) {
            return this.netmapData.getName();
        }
        if (this.pings.size() > 0) {
            return this.pings.get(this.pings.size() - 1).getDestination();
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public Order getOrder() {
        return this.order;
    }

    public void CopyNode(Node node) {
        if (this.netmapData == null) {
            this.netmapData = node.netmapData;
        }
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                try {
                    Object object6;
                    Iterator<Object> iterator;
                    Object object2;
                    Object object3;
                    Object object4 = field.get(this);
                    if (object4 == null) continue;
                    Object object5 = field.get(node);
                    if (object4 instanceof List && object5 instanceof List) {
                        object3 = (List)object4;
                        object2 = (List)object5;
                        iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            object6 = iterator.next();
                            object3.add(object6);
                        }
                    }
                    if (object4 instanceof Map && object5 instanceof Map) {
                        object3 = (Map)object4;
                        object2 = (Map)object5;
                        for (Object object6 : object2.keySet()) {
                            object3.put(object6, object2.get(object6));
                        }
                    }
                    if (!(object4 instanceof Set) || !(object5 instanceof Set)) continue;
                    object3 = (Set)object4;
                    object2 = (Set)object5;
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object6 = iterator.next();
                        object3.add(object6);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataTypes {
        ArpType,
        GroupType,
        PingType,
        ResourceType,
        ServiceType,
        TracerouteType,
        UserType;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order {
        Before,
        Default,
        After;

    }
}

