/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.closures;

import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.netmapviewer.NetmapViewerHost;
import ddb.dsz.plugin.netmapviewer.data.Arp;
import ddb.dsz.plugin.netmapviewer.insertion.InsertArps;
import java.awt.EventQueue;
import java.util.Vector;
import org.apache.commons.collections.Closure;

public class ArpClosure
implements Closure {
    NetmapViewerHost networkHost;

    public ArpClosure(NetmapViewerHost netmapViewerHost) {
        this.networkHost = netmapViewerHost;
    }

    public void execute(Object object) {
        DataEvent dataEvent = (DataEvent)object;
        TaskId taskId = dataEvent.getTaskId();
        if (taskId == null) {
            return;
        }
        if (!DataEvent.DataEventType.DATA.equals((Object)dataEvent.getDataType())) {
            return;
        }
        Vector<Arp> vector = new Vector<Arp>();
        for (ObjectValue objectValue : dataEvent.getData().getObjects("entry")) {
            Arp arp = new Arp(objectValue);
            arp.setLpTimestamp(dataEvent.getTimestamp());
            vector.add(arp);
        }
        EventQueue.invokeLater(new InsertArps(vector, this.networkHost));
    }
}

