/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.data;

import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.TaskId;
import ddb.util.GeneralUtilities;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfConfig {
    TaskId taskid;
    String hostName;
    String domainName;
    List<DnsServer> DnsServers = new Vector<DnsServer>();
    List<Interface> interfaces = new Vector<Interface>();

    public IfConfig(ObjectValue objectValue, TaskId taskId) {
        this.taskid = taskId;
        this.hostName = objectValue.getString("FixedDataItem::HostName");
        this.domainName = objectValue.getString("FixedDataItem::DomainName");
        for (ObjectValue objectValue2 : objectValue.getObjects("FixedDataItem::DnsServers::DnsServer")) {
            this.DnsServers.add(new DnsServer(objectValue2.getString("broadcast"), objectValue2.getString("mask"), objectValue2.getString("ip")));
        }
        for (ObjectValue objectValue2 : objectValue.getObjects("InterfaceItem")) {
            this.interfaces.add(new Interface(objectValue2));
        }
    }

    public List<DnsServer> getDnsServers() {
        return Collections.unmodifiableList(this.DnsServers);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public List<Interface> getInterfaces() {
        return this.interfaces;
    }

    public TaskId getTaskid() {
        return this.taskid;
    }

    public List<String> getAddresses() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.hostName.toLowerCase());
        for (Interface interface_ : this.interfaces) {
            vector.addAll(interface_.getIpAddresses());
            vector.add(interface_.getPhysicalAddress());
        }
        return vector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Interface {
        private final String description;
        private final String physicalAddress;
        private final boolean dhcpEnabled;
        List<String> ipAddresses = new Vector<String>();
        private final String dhcpServer;
        private final Calendar leaseObtained;
        private final Calendar leaseExpires;

        public Interface(ObjectValue objectValue) {
            this.description = objectValue.getString("Description");
            this.physicalAddress = objectValue.getString("address");
            this.dhcpEnabled = objectValue.getBoolean("dhcpEnabled");
            this.dhcpServer = objectValue.getString("dhcp::ip");
            this.leaseObtained = GeneralUtilities.stringToCalendar((String)String.format("%sT%s", objectValue.getString("lease::obtained::date"), objectValue.getString("lease::obtained::time")), null);
            this.leaseExpires = GeneralUtilities.stringToCalendar((String)String.format("%sT%s", objectValue.getString("lease::expires::date"), objectValue.getString("lease::expires::time")), null);
            for (ObjectValue objectValue2 : objectValue.getObjects("ipaddress")) {
                this.ipAddresses.add(objectValue2.getString("ip"));
            }
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isDhcpEnabled() {
            return this.dhcpEnabled;
        }

        public String getDhcpServer() {
            return this.dhcpServer;
        }

        public List<String> getIpAddresses() {
            return Collections.unmodifiableList(this.ipAddresses);
        }

        public Calendar getLeaseExpires() {
            return this.leaseExpires;
        }

        public Calendar getLeaseObtained() {
            return this.leaseObtained;
        }

        public String getPhysicalAddress() {
            return this.physicalAddress;
        }
    }

    public class DnsServer {
        private final String broadcast;
        private final String mask;
        private final String ip;

        public DnsServer(String string, String string2, String string3) {
            this.broadcast = string;
            this.mask = string2;
            this.ip = string3;
        }

        public String getBroadcast() {
            return this.broadcast;
        }

        public String getIp() {
            return this.ip;
        }

        public String getMask() {
            return this.mask;
        }
    }
}

