/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.display;

import ddb.dsz.plugin.netmapviewer.data.Arp;
import ddb.dsz.plugin.netmapviewer.display.CalendarRenderer;
import ddb.util.AbstractEnumeratedTableModel;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArpDisplay
extends JPanel {
    ColumnHidingModel hider = new ColumnHidingModel(ArpColumns.class);
    private JTable arpTable;
    private JScrollPane jScrollPane1;

    public ArpDisplay(Collection<Arp> collection) {
        this.initComponents();
        this.arpTable.setColumnModel((TableColumnModel)this.hider);
        ArpTableModel arpTableModel = new ArpTableModel(collection);
        this.arpTable.setModel((TableModel)((Object)arpTableModel));
        this.hider.applyToTable(this.arpTable);
        this.arpTable.setDefaultRenderer(Calendar.class, (TableCellRenderer)((Object)new CalendarRenderer()));
        this.arpTable.setRowSorter(new TableRowSorter<ArpTableModel>(arpTableModel));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.arpTable = new JTable();
        this.arpTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.arpTable);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 394, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 379, Short.MAX_VALUE));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArpTableModel
    extends AbstractEnumeratedTableModel<ArpColumns> {
        List<Arp> arps;

        public ArpTableModel(Collection<Arp> collection) {
            super(ArpColumns.class);
            this.arps = new ArrayList<Arp>();
            this.arps.addAll(collection);
            Collections.sort(this.arps, new Comparator<Arp>(){

                @Override
                public int compare(Arp arp, Arp arp2) {
                    return (int)(arp.getLpTimestamp() - arp2.getLpTimestamp());
                }
            });
        }

        public Object getValueAt(int n, ArpColumns arpColumns) {
            try {
                if (n < this.arps.size() && n >= 0) {
                    switch (arpColumns) {
                        case NetAddress: {
                            return this.arps.get(n).getInetAddress();
                        }
                        case State: {
                            return this.arps.get(n).getState();
                        }
                        case PhysicalAddress: {
                            return this.arps.get(n).getPhysAddress();
                        }
                        case Interface: {
                            return this.arps.get(n).getInterface();
                        }
                        case Timestamp: {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTimeInMillis(this.arps.get(n).getLpTimestamp());
                            return calendar;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return null;
        }

        public int getRowCount() {
            return this.arps.size();
        }

        public String getColumnName(ArpColumns arpColumns) {
            return arpColumns.getName();
        }

        public Class<?> getColumnClass(ArpColumns arpColumns) {
            return arpColumns.getClazz();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArpColumns {
        NetAddress(String.class, "Internet Address"),
        State(String.class, "State/Type"),
        PhysicalAddress(String.class, "Physical Address"),
        Interface(String.class, "Interface"),
        Timestamp(Calendar.class, "Timestamp");

        Class<?> clazz;
        String name;

        private ArpColumns(Class<?> clazz, String string2) {
            this.clazz = clazz;
            this.name = string2;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getName() {
            return this.name;
        }
    }
}

