/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.display;

import ddb.dsz.plugin.netmapviewer.data.IfConfig;
import java.text.SimpleDateFormat;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class IfConfigInterfaceDisplay
extends JPanel {
    private JTextField addressField;
    private JTextField descriptionField;
    private JTextField dhcpEnabledField;
    private JTextField dhcpServerField;
    private JList ipAddressList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JTextField leaseExpiresField;
    private JTextField leaseObtainedField;

    public IfConfigInterfaceDisplay(IfConfig.Interface interface_) {
        this.initComponents();
        this.addressField.setText(interface_.getPhysicalAddress());
        this.descriptionField.setText(interface_.getDescription());
        if (interface_.isDhcpEnabled()) {
            this.dhcpEnabledField.setText("Enabled");
        } else {
            this.dhcpEnabledField.setText("Disabled");
        }
        this.dhcpServerField.setText(interface_.getDhcpServer());
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        this.ipAddressList.setModel(defaultListModel);
        for (String string : interface_.getIpAddresses()) {
            defaultListModel.addElement(string);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
        this.leaseExpiresField.setText(simpleDateFormat.format(interface_.getLeaseExpires().getTime()));
        this.leaseObtainedField.setText(simpleDateFormat.format(interface_.getLeaseObtained().getTime()));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.ipAddressList = new JList();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.leaseExpiresField = new JTextField();
        this.leaseObtainedField = new JTextField();
        this.dhcpServerField = new JTextField();
        this.addressField = new JTextField();
        this.descriptionField = new JTextField();
        this.jLabel7 = new JLabel();
        this.dhcpEnabledField = new JTextField();
        this.setBorder(BorderFactory.createTitledBorder("Interface"));
        this.jLabel1.setText("Description:");
        this.ipAddressList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.ipAddressList.setVisibleRowCount(4);
        this.jLabel2.setText("Phsyical Address:");
        this.jLabel3.setText("DHCP Server:");
        this.jLabel4.setText("Lease Obtained:");
        this.jLabel5.setText("Lease Expires:");
        this.jLabel6.setText("Ip Addresses:");
        this.leaseExpiresField.setEditable(false);
        this.leaseExpiresField.setText("jTextField1");
        this.leaseObtainedField.setEditable(false);
        this.leaseObtainedField.setText("jTextField2");
        this.dhcpServerField.setEditable(false);
        this.dhcpServerField.setText("jTextField3");
        this.addressField.setEditable(false);
        this.addressField.setText("jTextField4");
        this.descriptionField.setEditable(false);
        this.descriptionField.setText("jTextField5");
        this.jLabel7.setText("DHCP Enabled:");
        this.dhcpEnabledField.setEditable(false);
        this.dhcpEnabledField.setText("jTextField6");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel7)).addGap(13, 13, 13).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ipAddressList, -1, 200, Short.MAX_VALUE).addComponent(this.descriptionField, -1, 200, Short.MAX_VALUE).addComponent(this.addressField, -1, 200, Short.MAX_VALUE).addComponent(this.dhcpServerField, -1, 200, Short.MAX_VALUE).addComponent(this.leaseObtainedField, -1, 200, Short.MAX_VALUE).addComponent(this.leaseExpiresField, -1, 200, Short.MAX_VALUE).addComponent(this.dhcpEnabledField, -1, 200, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.descriptionField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.addressField, -2, -1, -2)).addGap(7, 7, 7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.dhcpEnabledField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.dhcpServerField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.leaseObtainedField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.leaseExpiresField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.ipAddressList, -1, 88, Short.MAX_VALUE)).addContainerGap()));
    }
}

