/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.display;

import ddb.console.OptionPane;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.task.Task;
import ddb.dsz.library.console.ConsoleOutputPane;
import ddb.dsz.plugin.netmapviewer.data.Service;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.collections.Closure;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDisplay
extends JPanel {
    private DefaultListModel serviceListModel;
    private ConsoleOutputPane outPane;
    private DataTransformer dataTransform;
    private String lastKeyUsed = null;
    private TreeMap<String, String> serviceData = new TreeMap();
    private JScrollPane listScroller;
    private JButton nextButton;
    private JPanel outputPanel;
    private JButton previousButton;
    private JTextField searchField;
    private JLabel searchLabel;
    private JList serviceList;

    public ServiceDisplay(CoreController coreController, List<Service> list) {
        this.serviceListModel = new DefaultListModel(){

            public int indexOf(Object object) {
                int n = -1;
                Enumeration enumeration = this.elements();
                Service service = null;
                while (enumeration.hasMoreElements()) {
                    service = (Service)enumeration.nextElement();
                    if (!service.getServiceName().equalsIgnoreCase((String)object)) continue;
                    n = this.indexOf(service, 0);
                    break;
                }
                return n;
            }
        };
        ArrayList<Service> arrayList = new ArrayList<Service>(list);
        Collections.sort(arrayList);
        for (Service service : arrayList) {
            this.serviceListModel.addElement(service);
        }
        this.outPane = new ConsoleOutputPane(coreController);
        this.outPane.setTheme(OptionPane.getInstance().getSharedTheme());
        this.outPane.setWordWrap(false);
        this.outPane.setAutoScroll(false);
        this.initComponents();
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((JButton)actionEvent.getSource()).getText();
                ServiceDisplay.this.search(string);
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((JButton)actionEvent.getSource()).getText();
                ServiceDisplay.this.search(string);
            }
        });
        this.dataTransform = DataTransformer.newInstance();
        this.dataTransform.addClosure(ClosureFactory.newDisplayClosure((CoreController)coreController, (String)"services", (String)"Dsz", (Closure)new Closure(){

            public void execute(Object object) {
                ServiceDisplay.this.parseTaskOutput(object.toString());
            }
        }));
        Task task = coreController.getTaskById(list.get(0).getTaskId());
        this.dataTransform.addTask(task);
        this.outputPanel.add((Component)this.outPane);
        this.initializeOutput(list.get(0));
        this.serviceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JList jList = (JList)listSelectionEvent.getSource();
                Service service = (Service)jList.getSelectedValue();
                ServiceDisplay.this.setOutputText(service);
            }
        });
    }

    private void initializeOutput(final Service service) {
        String string = this.serviceData.get(service.getServiceName().toLowerCase());
        if (string == null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ServiceDisplay.this.initializeOutput(service);
                }
            });
        } else {
            this.outPane.appendDisplay(string);
        }
    }

    private void setOutputText(Service service) {
        this.outPane.clearAndReplace(this.serviceData.get(service.getServiceName().toLowerCase()));
    }

    private void parseTaskOutput(String string) {
        int n = string.indexOf("Service :");
        int n2 = -1;
        int n3 = string.indexOf("----------", n);
        String string2 = null;
        while (n != -1) {
            n2 = string.substring(0, n).lastIndexOf("\n") + 1;
            int n4 = string.indexOf("\n", n + 10);
            string2 = string.substring(n + 10, n4).trim();
            String string3 = string.substring(n2, n3);
            this.serviceData.put(string2.toLowerCase(), string3);
            n = string.indexOf("Service :", n3);
            n3 = string.indexOf("----------", n);
        }
    }

    private void search(String string) {
        String string2 = this.searchField.getText().toLowerCase();
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = true;
        if (this.lastKeyUsed == null) {
            string3 = this.serviceData.firstKey().toLowerCase();
            string4 = this.serviceData.get(string3).toLowerCase();
        } else {
            bl2 = false;
            string3 = string.equalsIgnoreCase("previous") && !bl2 ? this.serviceData.lowerKey(this.lastKeyUsed) : this.serviceData.higherKey(this.lastKeyUsed);
            if (string3 != null) {
                string4 = this.serviceData.get(string3);
            }
        }
        if (string3 != null) {
            if (string4 != null && (string3.toLowerCase().contains(string2) || string4.toLowerCase().contains(string2))) {
                bl = true;
            } else {
                while (string3 != null) {
                    string3 = string.equalsIgnoreCase("previous") && !bl2 ? this.serviceData.lowerKey(string3) : this.serviceData.higherKey(string3);
                    if (string3 == null || (string4 = this.serviceData.get(string3)) == null || !string3.toLowerCase().contains(string2) && !string4.toLowerCase().contains(string2)) continue;
                    bl = true;
                    break;
                }
            }
            this.lastKeyUsed = string3;
        }
        if (bl) {
            int n = this.serviceListModel.indexOf(string3);
            this.serviceList.setSelectedValue(this.serviceListModel.getElementAt(n), true);
            this.previousButton.setEnabled(true);
        } else {
            this.previousButton.setEnabled(false);
            this.serviceList.setSelectedValue(this.serviceListModel.getElementAt(0), true);
            if (!bl2) {
                int n = JOptionPane.showConfirmDialog(this, "No entry was found containing " + string2 + "\nRetry search from the beginning?");
                if (n == 0) {
                    this.lastKeyUsed = null;
                    this.search(string);
                }
            } else {
                JOptionPane.showMessageDialog(this, "No entry was found containing " + string2);
            }
        }
    }

    private void initComponents() {
        this.listScroller = new JScrollPane();
        this.serviceList = new JList();
        this.outputPanel = new JPanel();
        this.searchField = new JTextField();
        this.searchLabel = new JLabel();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.serviceList.setBorder(BorderFactory.createTitledBorder("Services"));
        this.serviceList.setModel(this.serviceListModel);
        this.serviceList.setSelectionMode(1);
        this.serviceList.setSelectedIndex(0);
        this.listScroller.setViewportView(this.serviceList);
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Service Properties"));
        this.outputPanel.setLayout(new BorderLayout());
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ServiceDisplay.this.searchFieldKeyReleased(keyEvent);
            }
        });
        this.searchLabel.setText("Search:");
        this.previousButton.setText("Previous");
        this.previousButton.setEnabled(false);
        this.nextButton.setText("Next");
        this.nextButton.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.listScroller, -2, 242, -2).addPreferredGap(0).add((Component)this.outputPanel, -1, 252, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.searchLabel).addPreferredGap(0).add((Component)this.searchField, -1, 319, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.previousButton).addPreferredGap(0).add((Component)this.nextButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.outputPanel, -1, 238, Short.MAX_VALUE).add((Component)this.listScroller, -1, 238, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.searchField, -2, -1, -2).add((Component)this.searchLabel).add((Component)this.previousButton).add((Component)this.nextButton)).addContainerGap()));
        this.outputPanel.add((Component)this.outPane);
    }

    private void searchFieldKeyReleased(KeyEvent keyEvent) {
        if (!this.searchField.getText().equals("")) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        }
    }
}

