/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.display;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.netmapviewer.Node;
import ddb.dsz.plugin.netmapviewer.data.Traceroute;
import ddb.gui.swing.DszTableCellRenderer;
import ddb.util.AbstractEnumeratedTableModel;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TracerouteDisplay
extends JPanel {
    CoreController core;
    TracerouteTableModel modelofTraceroute;
    DefaultListModel listOfTraceroutes;
    Node node;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable traceRouteDetails;
    private JList traceRouteList;

    public TracerouteDisplay(CoreController coreController, Node node) {
        this.core = coreController;
        this.initComponents();
        this.node = node;
        List<Traceroute> list = this.node.getTraceroutes();
        this.modelofTraceroute = new TracerouteTableModel();
        this.listOfTraceroutes = new DefaultListModel();
        ArrayList<Traceroute> arrayList = new ArrayList<Traceroute>(list);
        Collections.sort(arrayList, new Comparator<Traceroute>(){

            @Override
            public int compare(Traceroute traceroute, Traceroute traceroute2) {
                long l = traceroute.getLpTimestamp() - traceroute2.getLpTimestamp();
                if (l < 0L) {
                    return -1;
                }
                if (l == 0L) {
                    return 0;
                }
                return 1;
            }
        });
        for (Traceroute traceroute : arrayList) {
            this.listOfTraceroutes.addElement(traceroute);
        }
        this.traceRouteList.setModel(this.listOfTraceroutes);
        this.traceRouteDetails.setModel((TableModel)((Object)this.modelofTraceroute));
        if (arrayList.size() > 0) {
            this.traceRouteList.setSelectedValue(arrayList.get(0), true);
        }
        this.traceRouteDetails.setDefaultRenderer(String.class, (TableCellRenderer)new DszTableCellRenderer(){
            Font BOLD;
            Font PLAIN;

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (this.BOLD == null) {
                    this.BOLD = super.getFont().deriveFont(1);
                }
                if (this.PLAIN == null) {
                    this.PLAIN = super.getFont().deriveFont(0);
                }
                Font font = this.PLAIN;
                if (object instanceof String && (TracerouteDisplay.this.node.doesAddressMatch(object.toString()) || TracerouteDisplay.this.node.doesNameMatch(object.toString()))) {
                    font = this.BOLD;
                }
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setFont(font);
                return component;
            }
        });
        this.traceRouteDetails.setDefaultRenderer(Integer.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return super.getTableCellRendererComponent(jTable, (Object)String.format("%d", object), bl, bl2, n, n2);
            }
        });
        this.traceRouteDetails.setDefaultRenderer(Long.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object != null) {
                    Long l = (Long)object;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (l >= 60000L) {
                        stringBuilder.append(l / 60000L);
                        stringBuilder.append(":");
                        l = l % 60000L;
                    }
                    if (l >= 1000L || stringBuilder.length() > 0) {
                        stringBuilder.append(String.format("%02d.", l / 1000L));
                        l = l % 1000L;
                    } else {
                        stringBuilder.append("0.");
                    }
                    stringBuilder.append(String.format("%03d s", l));
                    return super.getTableCellRendererComponent(jTable, (Object)stringBuilder.toString(), bl, bl2, n, n2);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.traceRouteList.setCellRenderer(new DefaultListCellRenderer(){
            Calendar cal = Calendar.getInstance();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof Traceroute) {
                    Calendar calendar = ((Traceroute)Traceroute.class.cast(object)).getLpTimestampAsCalendar();
                    object = String.format("%04d-%02d-%02d   %02d:%02d:%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.traceRouteList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.traceRouteDetails = new JTable();
        this.jSplitPane1.setDividerLocation(150);
        this.jSplitPane1.setOrientation(0);
        this.traceRouteList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.traceRouteList.setSelectionMode(0);
        this.traceRouteList.setLayoutOrientation(1);
        this.traceRouteList.setPrototypeCellValue("1970-01-01   12:00:00 GMT");
        this.traceRouteList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TracerouteDisplay.this.traceRouteListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.traceRouteList);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.traceRouteDetails.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.traceRouteDetails);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING, -1, 539, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING, -1, 408, Short.MAX_VALUE));
    }

    private void traceRouteListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Traceroute traceroute = (Traceroute)this.traceRouteList.getSelectedValue();
        this.modelofTraceroute.setTraceroute(traceroute);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TracerouteTableModel
    extends AbstractEnumeratedTableModel<TracerouteColumns> {
        List<Traceroute.Hop> hops;

        public TracerouteTableModel() {
            super(TracerouteColumns.class);
            this.hops = new ArrayList<Traceroute.Hop>();
        }

        public void setTraceroute(Traceroute traceroute) {
            this.hops.clear();
            if (traceroute != null) {
                this.hops.addAll(traceroute.getHops());
            }
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n, TracerouteColumns tracerouteColumns) {
            try {
                if (n < this.hops.size() && n >= 0) {
                    switch (tracerouteColumns) {
                        case Address: {
                            return this.hops.get(n).getAddress();
                        }
                        case Hop: {
                            return this.hops.get(n).getHop();
                        }
                        case Time: {
                            return this.hops.get(n).getTime();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return null;
        }

        public int getRowCount() {
            return this.hops.size();
        }

        public String getColumnName(TracerouteColumns tracerouteColumns) {
            switch (tracerouteColumns) {
                case Address: {
                    return "Address";
                }
                case Hop: {
                    return "Hop";
                }
                case Time: {
                    return "Time (ms)";
                }
            }
            return super.getColumnName((Enum)tracerouteColumns);
        }

        public Class<?> getColumnClass(TracerouteColumns tracerouteColumns) {
            return tracerouteColumns.getClazz();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TracerouteColumns {
        Address(String.class),
        Hop(Integer.class),
        Time(Long.class);

        Class<?> clazz;

        private TracerouteColumns(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }
    }
}

