/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.monitor;

import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.monitor.MonitoredCommandOutput;
import ddb.dsz.plugin.monitor.OutputTableColumns;
import ddb.util.FrequentlyAppendedTableModel;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputTableModel
extends FrequentlyAppendedTableModel<OutputTableColumns, MonitoredCommandOutput> {
    public OutputTableModel(int n) {
        super(OutputTableColumns.class);
        super.setMaximum(n);
    }

    public Object getValueAt(int n, OutputTableColumns outputTableColumns) {
        MonitoredCommandOutput monitoredCommandOutput = (MonitoredCommandOutput)super.getRecord(n);
        if (monitoredCommandOutput == null) {
            return null;
        }
        switch (outputTableColumns) {
            case COMMAND: {
                return monitoredCommandOutput.getTask();
            }
            case WHEN: {
                return monitoredCommandOutput.getWhen();
            }
            case OUTPUT: {
                return monitoredCommandOutput.getCommandOutput();
            }
        }
        return null;
    }

    public Class<?> getColumnClass(OutputTableColumns outputTableColumns) {
        switch (outputTableColumns) {
            case COMMAND: {
                return Task.class;
            }
            case WHEN: {
                return Long.class;
            }
            case OUTPUT: {
                return String.class;
            }
        }
        return Object.class;
    }

    public String getColumnName(OutputTableColumns outputTableColumns) {
        switch (outputTableColumns) {
            case COMMAND: {
                return "Command";
            }
            case WHEN: {
                return "Time";
            }
            case OUTPUT: {
                return "Output";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MonitoredCommandOutput> getOutputsFor(Task task) {
        Vector<MonitoredCommandOutput> vector = new Vector<MonitoredCommandOutput>();
        if (task == null) {
            return vector;
        }
        super.readLock();
        try {
            for (int i = 0; i < this.getRowCount(); ++i) {
                MonitoredCommandOutput monitoredCommandOutput = (MonitoredCommandOutput)this.getRecord(i);
                if (!task.equals(monitoredCommandOutput.getTask())) continue;
                vector.add(monitoredCommandOutput);
            }
        }
        finally {
            super.readUnlock();
        }
        return vector;
    }
}

