/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel.filemodel;

import ddb.targetmodel.filemodel.Data;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarData
extends Data<Calendar> {
    public CalendarData(String string) {
        super(string);
    }

    @Override
    public void retreive(ResultSet resultSet, int n) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(n);
        if (timestamp == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        this.setValue(calendar, false);
    }

    @Override
    public void prepare(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.data != null) {
            preparedStatement.setTimestamp(n, new Timestamp(((Calendar)this.data).getTimeInMillis()), (Calendar)this.data);
        } else {
            preparedStatement.setNull(n, 93);
        }
    }

    @Override
    protected boolean isValid(Object object) {
        return object instanceof Calendar;
    }

    @Override
    public int compareTo(Data<Calendar> data) {
        if (this.data == null && data.data == null) {
            return 0;
        }
        if (this.data == null) {
            return 1;
        }
        if (data.data == null) {
            return -1;
        }
        return ((Calendar)this.data).compareTo((Calendar)data.data);
    }
}

