/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel.filemodel;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Data<E extends Comparable<?>>
implements Comparable<Data<E>> {
    private boolean modified = false;
    private String name = null;
    protected E data = null;

    public final String getName() {
        return this.name;
    }

    public final boolean isModified() {
        return this.modified && this.data != null;
    }

    public final void setModified(boolean bl) {
        this.modified = bl;
    }

    protected Data(String string) {
        this.name = string;
        this.modified = false;
    }

    public abstract void retreive(ResultSet var1, int var2) throws SQLException;

    public final boolean hasValue() {
        return this.data != null;
    }

    public final void setValue(Object object) {
        this.setValue(object, true);
    }

    public final void setValue(Object object, boolean bl) {
        if (object == null || this.isValid(object)) {
            this.data = (Comparable)object;
            if (bl) {
                this.modified = true;
            }
        } else {
            this.adapt(object, bl);
        }
    }

    public final E getValue() {
        return this.data;
    }

    protected abstract boolean isValid(Object var1);

    protected void adapt(Object object, boolean bl) {
    }

    public abstract void prepare(PreparedStatement var1, int var2) throws SQLException;

    public final String toString() {
        String string = "null";
        if (this.data != null) {
            string = this.data.toString();
        }
        return String.format("%s=%s", this.name, string);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Data data = (Data)object;
        return this.data == data.data || this.data != null && this.data.equals(data.data);
    }

    public int hashCode() {
        int n = 7;
        n = 67 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 67 * n + (this.data != null ? this.data.hashCode() : 0);
        return n;
    }
}

