/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel.filemodel;

import ddb.targetmodel.filemodel.Data;
import ddb.targetmodel.filemodel.DriveType;
import ddb.targetmodel.filemodel.FileObjectFields;
import ddb.targetmodel.filemodel.FileSystemModel;
import ddb.targetmodel.filemodel.LongData;
import ddb.targetmodel.filemodel.StringData;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileObject {
    private static final Data<?> NULL = new StringData("null");
    private static final String PENDING_FILE = DriveType.PENDING_FILE.getIcon();
    private static final String PENDING_DIR;
    private static final String PENDING_DRIVE;
    private FileSystemModel fileSystem;
    private long fileId = -1L;
    private String path = null;
    private boolean isDir = false;
    private boolean isDrive = false;
    private boolean isDiscard = false;
    private boolean pendingRequest = false;
    Data<?>[] dataFields = new Data[FileObjectFields.values().length];

    public static List<FileObject> getFiles(FileSystemModel fileSystemModel, ResultSet resultSet, String string) {
        return FileObject.getFiles(fileSystemModel, resultSet, string, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileObject> getFiles(FileSystemModel fileSystemModel, ResultSet resultSet, String string, int n) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        try {
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                while (resultSet.next() && n-- > 0) {
                    FileObject fileObject = new FileObject(fileSystemModel);
                    fileObject.fileId = resultSet.getInt("FileId");
                    fileObject.setPath(string);
                    fileObject.retrieve(resultSet, resultSetMetaData);
                    arrayList.add(fileObject);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger("dsz").log(Level.SEVERE, null, sQLException);
        }
        return arrayList;
    }

    public final void retrieve(ResultSet resultSet) throws SQLException {
        this.retrieve(resultSet, resultSet.getMetaData());
    }

    public final void retrieve(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
        Data<?> data;
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            data = this.getDataElement(resultSetMetaData.getColumnName(i), true);
            if (data == null || data == NULL) continue;
            data.retreive(resultSet, i);
        }
        Data<?> data2 = this.getDataElement(FileObjectFields.Dir_Id);
        data = this.getDataElement(FileObjectFields.Drive_Id);
        if (data2 != NULL) {
            if (data2.hasValue() && (Long)((LongData)LongData.class.cast(data2)).getValue() == this.fileId) {
                this.isDir = true;
            } else {
                data2.setValue(null);
            }
        }
        if (data != NULL) {
            if (data.hasValue() && (Long)((LongData)LongData.class.cast(data)).getValue() == this.fileId) {
                this.isDrive = true;
            } else {
                data.setValue(null);
            }
        }
    }

    public final String toString() {
        Data<?> data = this.getDataElement(FileObjectFields.File_Name);
        if (data != null && data != NULL) {
            return data.getValue().toString();
        }
        return "?";
    }

    public final String getIcon() {
        if (this.isPendingRequest()) {
            if (this.isDrive()) {
                return PENDING_DRIVE;
            }
            if (this.isDirectory()) {
                return PENDING_DIR;
            }
            return PENDING_FILE;
        }
        if (!this.isDirectory()) {
            Data<?> data = this.getDataElement(FileObjectFields.File_Name);
            if (data != NULL && data.hasValue()) {
                return DriveType.DOCUMENT.getIcon();
            }
            return DriveType.QUESTION.getIcon();
        }
        if (!this.isDrive()) {
            Data<?> data = this.getDataElement(FileObjectFields.Dir_AccessDenied);
            Data<?> data2 = this.getDataElement(FileObjectFields.File_Children);
            if (data != NULL && data.hasValue() && Boolean.TRUE.equals(data.getValue())) {
                return DriveType.ACCESS_DENIED_FOLDER.getIcon();
            }
            if (data2 == NULL || data2.getValue() == null || (Long)((LongData)LongData.class.cast(data2)).getValue() == 0L) {
                return DriveType.EMPTYFOLDER.getIcon();
            }
            return DriveType.FOLDER.getIcon();
        }
        Data<?> data = this.getDataElement(FileObjectFields.Drive_Type);
        if (data == NULL || !data.hasValue()) {
            return DriveType.DRIVE.getIcon();
        }
        return DriveType.values()[((Long)((LongData)LongData.class.cast(data)).getValue()).intValue()].getIcon();
    }

    public FileObject(FileSystemModel fileSystemModel) {
        this.fileSystem = fileSystemModel;
    }

    public FileObject(FileSystemModel fileSystemModel, long l) {
        this.fileSystem = fileSystemModel;
        this.fileId = l;
    }

    public final void setDataElement(String string, Object object) {
        if (string == null) {
            return;
        }
        Data<?> data = this.getDataElement(string, true);
        if (data == null || data == NULL) {
            return;
        }
        data.setValue(object);
    }

    public final void setDataElement(FileObjectFields fileObjectFields, Object object) {
        if (fileObjectFields == null) {
            return;
        }
        Data<?> data = this.getDataElement(fileObjectFields, true);
        if (data == null || data == NULL) {
            return;
        }
        data.setValue(object);
    }

    public final Data<?> getDataElement(String string) {
        return this.getDataElement(string, false);
    }

    public final Data<?> getDataElement(String string, boolean bl) {
        if (string == null) {
            return NULL;
        }
        return this.getDataElement(FileObjectFields.getField(string), bl);
    }

    public final Data<?> getDataElement(FileObjectFields fileObjectFields) {
        return this.getDataElement(fileObjectFields, false);
    }

    public final Data<?> getDataElement(FileObjectFields fileObjectFields, boolean bl) {
        if (fileObjectFields == null) {
            return NULL;
        }
        Data data = this.dataFields[fileObjectFields.ordinal()];
        if (data == null && bl) {
            try {
                this.dataFields[fileObjectFields.ordinal()] = data = fileObjectFields.getClazz().getConstructor(String.class).newInstance(fileObjectFields.getName());
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger(FileObject.class.getName()).log(Level.SEVERE, null, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(FileObject.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(FileObject.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(FileObject.class.getName()).log(Level.SEVERE, null, invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        if (data == null) {
            return NULL;
        }
        return data;
    }

    public final boolean isDirectory() {
        return this.isDir;
    }

    public final boolean isDrive() {
        return this.isDrive;
    }

    public final void forceDirectory() {
        if (this.isDirectory()) {
            return;
        }
        this.isDir = true;
        this.setDataElement(FileObjectFields.Dir_Id, (Object)this.fileId);
    }

    public final void setDirectory() {
        LongData longData = (LongData)this.getDataElement(FileObjectFields.Dir_Id, true);
        if (longData == null || longData == NULL) {
            return;
        }
        if (longData.hasValue() && (Long)longData.getValue() == this.fileId) {
            return;
        }
        this.isDir = true;
        if (this.fileId != -1L) {
            this.fileSystem.makeDirectory(this.fileId);
            longData.setValue(this.fileId, false);
            this.fileSystem.fireFileChanged(this);
        }
    }

    public final void setDrive() {
        LongData longData = (LongData)this.getDataElement(FileObjectFields.Drive_Id, true);
        if (longData == null || longData == NULL) {
            return;
        }
        if (longData.hasValue() && (Long)longData.getValue() == this.fileId) {
            return;
        }
        this.setDirectory();
        this.isDrive = true;
        if (this.fileId != -1L) {
            // empty if block
        }
        this.isDir = true;
        if (this.fileId != -1L) {
            this.fileSystem.makeDrive(this.fileId);
            longData.setValue(this.fileId, false);
            this.fileSystem.fireFileChanged(this);
        }
    }

    public final void save() {
        this.fileSystem.save(this);
    }

    public final boolean isModified() {
        for (Data<?> data : this.dataFields) {
            if (data == null || data == NULL || !data.isModified()) continue;
            return true;
        }
        return false;
    }

    public final Long getId() {
        return this.fileId;
    }

    public final Long getParent() {
        Data<?> data = this.getDataElement(FileObjectFields.File_Parent);
        if (data == null || data == NULL) {
            return -1L;
        }
        if (data.hasValue()) {
            return (Long)((LongData)LongData.class.cast(data)).getValue();
        }
        return -1L;
    }

    public final String getName() {
        StringData stringData = (StringData)this.getDataElement(FileObjectFields.File_Name);
        if (stringData == null) {
            return null;
        }
        return (String)stringData.getValue();
    }

    public final void setParent(long l) {
        LongData longData = (LongData)this.getDataElement(FileObjectFields.File_Parent, true);
        if (longData == null || longData == NULL) {
            return;
        }
        longData.setValue(l);
    }

    public final void setName(String string) {
        StringData stringData = (StringData)this.getDataElement(FileObjectFields.File_Name, true);
        if (stringData == null || stringData == NULL) {
            return;
        }
        stringData.setValue(string);
    }

    public final void setPath(String string) {
        this.path = string;
    }

    public final String getPath() {
        return this.path;
    }

    public final void setId(int n) {
        LongData longData;
        if (this.fileId != -1L) {
            return;
        }
        this.fileId = n;
        if (this.isDir && (longData = (LongData)this.getDataElement(FileObjectFields.Dir_Id, true)) != null && longData != NULL) {
            longData.setValue(n, false);
        }
        if (this.isDrive && (longData = (LongData)this.getDataElement(FileObjectFields.Drive_Id, true)) != null && longData != NULL) {
            longData.setValue(n, false);
        }
    }

    public final void setPendingRequest(boolean bl) {
        this.pendingRequest = bl;
    }

    public final boolean isPendingRequest() {
        return this.pendingRequest;
    }

    public final void discard() {
        this.isDiscard = true;
    }

    public final boolean isDiscard() {
        return this.isDiscard;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FileObject fileObject = (FileObject)object;
        if (!(this.fileSystem == fileObject.fileSystem || this.fileSystem != null && this.fileSystem.equals(fileObject.fileSystem))) {
            return false;
        }
        if (this.fileId != fileObject.fileId) {
            return false;
        }
        if (this.path == null ? fileObject.path != null : !this.path.equals(fileObject.path)) {
            return false;
        }
        return !(this.getName() == null ? fileObject.getName() != null : !this.getName().equals(fileObject.getName()));
    }

    public int hashCode() {
        int n = 3;
        n = 47 * n + (this.fileSystem != null ? this.fileSystem.hashCode() : 0);
        n = 47 * n + (int)(this.fileId ^ this.fileId >>> 32);
        n = 47 * n + (this.path != null ? this.path.hashCode() : 0);
        n = 47 * n + (this.getName() != null ? this.getName().hashCode() : 0);
        return n;
    }

    static {
        PENDING_DRIVE = PENDING_DIR = DriveType.PENDING_FOLDER.getIcon();
    }
}

