/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel.filemodel;

import ddb.targetmodel.filemodel.Data;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongData
extends Data<Long> {
    public LongData(String string) {
        super(string);
    }

    @Override
    protected void adapt(Object object, boolean bl) {
        if (object instanceof Integer) {
            long l = ((Integer)Integer.class.cast(object)).intValue();
            this.setValue(l, bl);
        }
    }

    @Override
    public void retreive(ResultSet resultSet, int n) throws SQLException {
        long l = resultSet.getLong(n);
        boolean bl = resultSet.wasNull();
        if (!bl) {
            this.setValue(l, false);
        }
    }

    @Override
    public void prepare(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setLong(n, (Long)this.data);
    }

    @Override
    protected boolean isValid(Object object) {
        return object instanceof Long;
    }

    @Override
    public int compareTo(Data<Long> data) {
        if (this.data == null && data.data == null) {
            return 0;
        }
        if (this.data == null) {
            return 1;
        }
        if (data.data == null) {
            return -1;
        }
        return ((Long)this.data).compareTo((Long)data.data);
    }
}

