/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel.filemodel.listeners;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.core.task.TaskId;
import ddb.predicate.PredicateClosure;
import ddb.predicate.PredicateClosureImpl;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileObjectFields;
import ddb.targetmodel.filemodel.FileSystemModel;
import ddb.targetmodel.filemodel.history.ActionType;
import ddb.targetmodel.filemodel.history.CommandType;
import ddb.util.GeneralUtilities;
import ddb.util.Guid;
import ddb.util.UtilityConstants;
import ddb.util.XmlCache;
import java.io.IOException;
import java.io.Reader;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.SAXParser;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DirCrawler
implements Observer {
    private final CoreController core;
    private final FileSystemModel model;
    private static final int THREAD_COUNT = 10;
    private static final BlockingQueue<Runnable> QUEUE = new PriorityBlockingQueue<Runnable>();
    private static final Executor exec = new ThreadPoolExecutor(10, 10, 1L, TimeUnit.MINUTES, QUEUE, UtilityConstants.createThreadFactory((String)"DirCrawler"));
    private static final SAXException EarlyFinish = new SAXException();
    private static final Object TASKING_LOCK = new Object();
    private static final List<TaskId> handledTasks = new Vector<TaskId>();
    private int pendingDirDataSections = 0;
    Map<Guid, TaskingInfo> TaskingMap = new HashMap<Guid, TaskingInfo>();

    public DirCrawler(CoreController coreController, FileSystemModel fileSystemModel) {
        this.core = coreController;
        this.model = fileSystemModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Task task) {
        List<TaskId> list = handledTasks;
        synchronized (list) {
            TaskId taskId = task.getId();
            int n = Collections.binarySearch(handledTasks, taskId);
            if (n >= 0) {
                return;
            }
            ++n;
            n = -n;
            handledTasks.add(n, taskId);
        }
        task.subscribe((Observer)this, true);
    }

    private void dataChanged() {
        this.model.setPendingData(this.pendingDirDataSections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable observable, Object object) {
        DirCrawler dirCrawler = this;
        synchronized (dirCrawler) {
            ++this.pendingDirDataSections;
        }
        exec.execute(new DelegateWrapper((TaskDataAccess)object));
        this.dataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TaskingInfo getTaskingInformation(Task task) {
        Object object = TASKING_LOCK;
        synchronized (object) {
            block24: {
                TaskingInfo taskingInfo;
                Reader reader;
                block23: {
                    TaskingInfo taskingInfo2 = this.TaskingMap.get(task.getTaskId());
                    if (taskingInfo2 != null) {
                        return taskingInfo2;
                    }
                    TaskingHandler taskingHandler = new TaskingHandler();
                    reader = task.getTaskingAccess().getReader();
                    try {
                        SAXParser sAXParser = XmlCache.getSAXParser();
                        if (sAXParser == null) {
                            taskingInfo = null;
                            break block23;
                        }
                        sAXParser.parse(new InputSource(reader), (DefaultHandler)taskingHandler);
                        break block24;
                    }
                    catch (Exception exception) {
                        if (exception == EarlyFinish) {
                            TaskingInfo taskingInfo3 = taskingHandler.tasking;
                            return taskingInfo3;
                        }
                        exception.printStackTrace();
                        break block24;
                    }
                }
                return taskingInfo;
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTaskDataAccess(TaskDataAccess taskDataAccess) {
        if (taskDataAccess == null) {
            return;
        }
        switch (taskDataAccess.getType()) {
            case DATA: {
                break;
            }
            default: {
                return;
            }
        }
        Task task = taskDataAccess.getTask();
        DataHandler dataHandler = new DataHandler(this.getTaskingInformation(task), task);
        Reader reader = taskDataAccess.getReader();
        SAXParser sAXParser = XmlCache.getSAXParser();
        try {
            if (sAXParser == null || reader == null) {
                return;
            }
            sAXParser.parse(new InputSource(reader), (DefaultHandler)dataHandler);
        }
        catch (Exception exception) {
            if (exception == EarlyFinish) {
                return;
            }
            exception.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
            XmlCache.releaseParser((SAXParser)sAXParser);
        }
    }

    private class DataHandler
    extends DefaultHandler {
        final TaskingInfo tasking;
        private final Task task;
        private StringBuilder sb = new StringBuilder();
        private FileObject currentDirectory = null;
        private FileObject currentFile = null;
        private Calendar timestamp;
        private final PredicateClosure[] StartElementClosure;
        private PredicateClosure[] EndElementClosure;
        private String currentHash = null;
        private final Predicate HasDirectory = new Predicate(){

            public boolean evaluate(Object object) {
                return DataHandler.this.currentDirectory != null;
            }
        };
        private final Predicate HasFile = new Predicate(){

            public boolean evaluate(Object object) {
                return DataHandler.this.currentFile != null;
            }
        };

        public DataHandler(TaskingInfo taskingInfo, Task task) {
            this.tasking = taskingInfo;
            this.task = task;
            this.StartElementClosure = new PredicateClosure[]{new PredicateClosureImpl(PredicateUtils.equalPredicate((Object)"Directory"), new Closure(){

                public void execute(Object object) {
                    Attributes attributes = (Attributes)object;
                    String string = attributes.getValue("path");
                    DataHandler.this.timestamp = GeneralUtilities.stringToCalendar((String)attributes.getValue("lptimestamp"), null);
                    DataHandler.this.currentDirectory = DirCrawler.this.model.getNodeForPath(string, true, CommandType.DIR, DataHandler.this.task.getId(), DataHandler.this.timestamp, true, null);
                    DirCrawler.this.model.addHistoryItem(DataHandler.this.currentDirectory, DataHandler.this.task.getId(), ActionType.INFO, CommandType.DIR, null);
                    if (DataHandler.this.currentDirectory != null) {
                        DataHandler.this.currentDirectory.setDirectory();
                        if (DataHandler.this.tasking.fullList) {
                            DataHandler.this.currentDirectory.setDataElement(FileObjectFields.Dir_LastFull, (Object)DataHandler.this.timestamp);
                        } else {
                            DataHandler.this.currentDirectory.setDataElement(FileObjectFields.Dir_LastPartial, (Object)DataHandler.this.timestamp);
                        }
                    }
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasDirectory, (Predicate)PredicateUtils.equalPredicate((Object)"File")), new Closure(){

                public void execute(Object object) {
                    Attributes attributes = (Attributes)object;
                    String string = attributes.getValue("name");
                    String string2 = attributes.getValue("altName");
                    if (string == null) {
                        DataHandler.this.currentFile = null;
                        return;
                    }
                    if (string.equals("..")) {
                        DataHandler.this.currentFile = null;
                        return;
                    }
                    if (string.equals(".")) {
                        DataHandler.this.currentFile = DataHandler.this.currentDirectory;
                        return;
                    }
                    DataHandler.this.currentFile = DirCrawler.this.model.getChildNode(DataHandler.this.currentDirectory, string, true, CommandType.DIR, DataHandler.this.task.getId(), DataHandler.this.timestamp, true, null);
                    DirCrawler.this.model.addHistoryItem(DataHandler.this.currentFile, DataHandler.this.task.getId(), ActionType.INFO, CommandType.DIR, null);
                    if (DataHandler.this.currentFile != null) {
                        DataHandler.this.currentFile.setDataElement(FileObjectFields.File_Name, (Object)string);
                        DataHandler.this.currentFile.setDataElement(FileObjectFields.File_Size, (Object)Long.parseLong(attributes.getValue("size")));
                        if (string2 != null && string2.length() > 0) {
                            DataHandler.this.currentFile.setDataElement(FileObjectFields.File_AlternateName, (Object)string2);
                        }
                    }
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)PredicateUtils.notPredicate((Predicate)this.HasDirectory), (Predicate)PredicateUtils.equalPredicate((Object)"File")), new Closure(){

                public void execute(Object object) {
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeArchive")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_Archive, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeDirectory")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDirectory();
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeSymbolicLink")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_SymbolicLink, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeAFUnixFamilySocket")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_UnixFamilySocket, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeBlockSpecialFile")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_BlockSpecialFile, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeCharacterSpecialFile")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_CharacterSpecialFile, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeNamedPipeFile")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_NamedPipe, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeCompressed")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_Compressed, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeEncrypted")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_Encrypted, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeHidden")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_Hidden, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeOffline")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_Offline, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeReadonly")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_ReadOnly, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeSystem")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_System, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeTemporary")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_Temporary, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeReparsePoint")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_ReparsePoint, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeSparseFile")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_SparseFile, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeVirtual")), new Closure(){

                public void execute(Object object) {
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeNotIndexed")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_NotContentIndexed, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"FileAttributeDevice")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.Attr_Device, (Object)Boolean.TRUE);
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"Hash")), new Closure(){

                public void execute(Object object) {
                    Attributes attributes = (Attributes)object;
                    DataHandler.this.currentHash = attributes.getValue("type");
                }
            })};
            this.EndElementClosure = new PredicateClosure[]{new PredicateClosureImpl(PredicateUtils.equalPredicate((Object)"Directory"), new Closure(){

                public void execute(Object object) {
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"File")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.save();
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"Modified")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.File_Modified, (Object)GeneralUtilities.stringToCalendar((String)object.toString(), null));
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"Created")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.File_Created, (Object)GeneralUtilities.stringToCalendar((String)object.toString(), null));
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"Accessed")), new Closure(){

                public void execute(Object object) {
                    DataHandler.this.currentFile.setDataElement(FileObjectFields.File_Accessed, (Object)GeneralUtilities.stringToCalendar((String)object.toString(), null));
                }
            }), new PredicateClosureImpl(PredicateUtils.andPredicate((Predicate)this.HasFile, (Predicate)PredicateUtils.equalPredicate((Object)"Hash")), new Closure(){

                public void execute(Object object) {
                    if (DataHandler.this.currentHash == null) {
                        return;
                    }
                    if (DataHandler.this.currentHash.equalsIgnoreCase("SHA1")) {
                        DataHandler.this.currentFile.setDataElement(FileObjectFields.Hash_Sha1, (Object)object.toString());
                    } else if (DataHandler.this.currentHash.equalsIgnoreCase("MD5")) {
                        DataHandler.this.currentFile.setDataElement(FileObjectFields.Hash_Md5, (Object)object.toString());
                    } else if (DataHandler.this.currentHash.equalsIgnoreCase("SHA256")) {
                        DataHandler.this.currentFile.setDataElement(FileObjectFields.Hash_Sha256, (Object)object.toString());
                    } else if (DataHandler.this.currentHash.equalsIgnoreCase("SHA512")) {
                        DataHandler.this.currentFile.setDataElement(FileObjectFields.Hash_Sha512, (Object)object.toString());
                    }
                }
            })};
        }

        public void startDocument() throws SAXException {
            super.startDocument();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            this.sb.setLength(0);
            for (PredicateClosure predicateClosure : this.StartElementClosure) {
                if (!predicateClosure.evaluate((Object)string3)) continue;
                predicateClosure.execute((Object)attributes);
                break;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (string3.equals("CommandData") || string3.equals("TaskResult")) {
                throw EarlyFinish;
            }
            for (PredicateClosure predicateClosure : this.EndElementClosure) {
                if (!predicateClosure.evaluate((Object)string3)) continue;
                predicateClosure.execute((Object)this.sb.toString());
                break;
            }
            this.sb.setLength(0);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            super.characters(cArray, n, n2);
            this.sb.append(new String(cArray, n, n2));
        }

        private void save() {
            if (this.currentFile != null) {
                this.currentFile.save();
                this.currentFile = null;
            }
        }
    }

    private class TaskingHandler
    extends DefaultHandler {
        public final TaskingInfo tasking;
        private String currentElement;
        private StringBuilder sb;

        private TaskingHandler() {
            this.tasking = new TaskingInfo();
            this.currentElement = "";
            this.sb = new StringBuilder();
        }

        public void startDocument() throws SAXException {
            super.startDocument();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            this.currentElement = string3;
            if (string3.equals("SearchAge")) {
                this.tasking.fullList = false;
                throw EarlyFinish;
            }
            if (string3.equals("SearchAfterDate")) {
                this.tasking.fullList = false;
                throw EarlyFinish;
            }
            if (string3.equals("SearchBeforeDate")) {
                this.tasking.fullList = false;
                throw EarlyFinish;
            }
            if (string3.equals("SearchMaxMatches")) {
                this.tasking.fullList = false;
                throw EarlyFinish;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.currentElement.equals("SearchMask") && !this.sb.toString().equals("*")) {
                this.tasking.fullList = false;
            }
            this.sb.setLength(0);
            if (!this.tasking.fullList || string3.equals("TaskingInfo") || string3.equals("CommandTasking")) {
                throw EarlyFinish;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            super.characters(cArray, n, n2);
            this.sb.append(new String(cArray, n, n2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegateWrapper
    implements Runnable,
    Comparable<DelegateWrapper> {
        TaskDataAccess tda;

        public DelegateWrapper(TaskDataAccess taskDataAccess) {
            this.tda = taskDataAccess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DirCrawler.this.handleTaskDataAccess(this.tda);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            DirCrawler dirCrawler = DirCrawler.this;
            synchronized (dirCrawler) {
                DirCrawler.this.pendingDirDataSections--;
            }
            DirCrawler.this.dataChanged();
            this.tda = null;
        }

        @Override
        public int compareTo(DelegateWrapper delegateWrapper) {
            if (this == delegateWrapper) {
                return 0;
            }
            if (delegateWrapper == null) {
                return -1;
            }
            if (this.tda == null && delegateWrapper.tda == null) {
                return 0;
            }
            if (this.tda == null) {
                return -1;
            }
            if (delegateWrapper.tda == null) {
                return 1;
            }
            return this.tda.getOrdinal() - delegateWrapper.tda.getOrdinal();
        }
    }

    private class TaskingInfo {
        boolean fullList = true;

        private TaskingInfo() {
        }
    }
}

