/*
 * Decompiled with CFR 0.152.
 */
package ds.core;

import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.util.JaxbCache;
import ds.jaxb.ipc.AddPrefixesType;
import ds.jaxb.ipc.CommandListType;
import ds.jaxb.ipc.CommandType;
import ds.jaxb.ipc.GetHelpType;
import ds.jaxb.ipc.GetStatisticsType;
import ds.jaxb.ipc.GuiCommandResponse;
import ds.jaxb.ipc.HelpType;
import ds.jaxb.ipc.InfoType;
import ds.jaxb.ipc.InterruptCommandType;
import ds.jaxb.ipc.ListCommandsType;
import ds.jaxb.ipc.Message;
import ds.jaxb.ipc.ObjectFactory;
import ds.jaxb.ipc.PingType;
import ds.jaxb.ipc.PongType;
import ds.jaxb.ipc.PromptStoppedType;
import ds.jaxb.ipc.RequestType;
import ds.jaxb.ipc.ResponseType;
import ds.jaxb.ipc.RestartOutputType;
import ds.jaxb.ipc.ShutdownType;
import ds.jaxb.ipc.StartCommandType;
import ds.jaxb.ipc.StartPromptType;
import ds.jaxb.ipc.StatisticsType;
import ds.jaxb.ipc.StopCommandType;
import ds.jaxb.ipc.StopOutputType;
import ds.jaxb.ipc.StopPromptType;
import ds.jaxb.ipc.UserEntryType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ChainedTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandFormatter {
    protected File schema;
    protected ObjectFactory objFact;
    protected JAXBContext jaxbContext;
    protected final Object MARSH_LOCK = new Object();
    protected Marshaller marshaller;
    protected final Object UNMARSH_LOCK = new Object();
    protected Unmarshaller unmarshaller;
    private int nextRequestId = 1;
    Transformer createMessage = new CreateMessage();
    Transformer createRequest = ChainedTransformer.getInstance((Transformer)new CreateRequest(), (Transformer)this.createMessage);
    Transformer commandListTransformer = ChainedTransformer.getInstance((Transformer)new CommandList(), (Transformer)this.createRequest);
    Transformer getStatisticsTransformer = ChainedTransformer.getInstance((Transformer)new GetStatistics(), (Transformer)this.createRequest);
    Transformer getPingTransformer = ChainedTransformer.getInstance((Transformer)new GetPing(), (Transformer)this.createRequest);
    Transformer createShutdown = ChainedTransformer.getInstance((Transformer)new CreateShutdown(), (Transformer)this.createMessage);
    Transformer createStartCommand = ChainedTransformer.getInstance((Transformer)new CreateStartCommand(), (Transformer)this.createMessage);
    Transformer createInterruptCommand = ChainedTransformer.getInstance((Transformer)new CreateInteruptCommand(), (Transformer)this.createMessage);
    Transformer createStopCommand = ChainedTransformer.getInstance((Transformer)new CreateStopCommand(), (Transformer)this.createMessage);
    Transformer createStopOutput = ChainedTransformer.getInstance((Transformer)new CreateStopOutput(), (Transformer)this.createMessage);
    Transformer createRestartOutput = ChainedTransformer.getInstance((Transformer)new CreateRestartOutput(), (Transformer)this.createMessage);
    Transformer createResponse = ChainedTransformer.getInstance((Transformer)new CreateResponse(), (Transformer)this.createMessage);

    public CommandFormatter(String string) throws JAXBException {
        this(new File(string));
    }

    public CommandFormatter(File file) throws JAXBException {
        this.schema = file;
        this.objFact = new ObjectFactory();
        this.jaxbContext = JaxbCache.getContext(ObjectFactory.class);
        this.marshaller = this.jaxbContext.createMarshaller();
        this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        this.unmarshaller = this.jaxbContext.createUnmarshaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] formatMessageAsByteArray(Message message) throws JAXBException {
        if (message == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Object object = this.MARSH_LOCK;
        synchronized (object) {
            this.marshaller.marshal((Object)message, (OutputStream)byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String formatMessageAsString(Message message) throws JAXBException {
        if (message == null) {
            return "";
        }
        byte[] byArray = this.formatMessageAsByteArray(message);
        return new String(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message unmarshallReceivedBytes(InputStream inputStream) throws JAXBException {
        Object object = this.UNMARSH_LOCK;
        synchronized (object) {
            return (Message)this.unmarshaller.unmarshal(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message unmarshallReceivedBytes(Reader reader) throws JAXBException {
        Object object = this.UNMARSH_LOCK;
        synchronized (object) {
            return (Message)this.unmarshaller.unmarshal(reader);
        }
    }

    public Message createStartCommand(Task task) {
        return (Message)this.createStartCommand.transform((Object)task);
    }

    public Message createStopCommand(TaskId taskId) {
        return (Message)this.createStopCommand.transform((Object)taskId);
    }

    public Message createGuiCommandResponse(int n, boolean bl) {
        GuiCommandResponse guiCommandResponse = new GuiCommandResponse();
        guiCommandResponse.setSuccess(bl);
        Message message = (Message)this.createResponse.transform((Object)guiCommandResponse);
        message.getRes().setReqId(n);
        return message;
    }

    public Message createInterruptCommand(TaskId taskId) {
        return (Message)this.createInterruptCommand.transform((Object)taskId);
    }

    public Message createStopOutput(TaskId taskId) {
        return (Message)this.createStopOutput.transform((Object)taskId);
    }

    public Message createRestartOutput(TaskId taskId) {
        return (Message)this.createRestartOutput.transform((Object)taskId);
    }

    public Message createAddPrefixes(TaskId taskId, List<String> list) {
        AddPrefixesType addPrefixesType = this.objFact.createAddPrefixesType();
        addPrefixesType.setCmdId(taskId.getId());
        addPrefixesType.getPrefix().addAll(list);
        CommandType commandType = this.objFact.createCommandType();
        commandType.setAddPrefixes(addPrefixesType);
        commandType.setCmdId(taskId.getId());
        return (Message)this.createMessage.transform((Object)commandType);
    }

    public Message createListCommands() {
        return (Message)this.commandListTransformer.transform(null);
    }

    public Message createGetStatistics() {
        return (Message)this.getStatisticsTransformer.transform(null);
    }

    public Message createShutdown() {
        return (Message)this.createShutdown.transform(null);
    }

    public Message createPing() {
        return (Message)this.getPingTransformer.transform(null);
    }

    public Message createGetHelp(String string, HostInfo hostInfo) {
        GetHelpType getHelpType = this.objFact.createGetHelpType();
        getHelpType.setValue(string);
        getHelpType.setTarget(hostInfo.getId());
        Message message = (Message)this.createRequest.transform((Object)getHelpType);
        return message;
    }

    public Message createUserEntry(int n, TaskId taskId, String string) {
        UserEntryType userEntryType = this.objFact.createUserEntryType();
        userEntryType.setCmdId(taskId.getId());
        userEntryType.setValue(string);
        ResponseType responseType = this.objFact.createResponseType();
        responseType.setUserEntry(userEntryType);
        responseType.setReqId(n);
        return (Message)this.createMessage.transform((Object)responseType);
    }

    public Message createPromptStopped(int n, TaskId taskId) {
        PromptStoppedType promptStoppedType = this.objFact.createPromptStoppedType();
        promptStoppedType.setCmdId(taskId.getId());
        promptStoppedType.setValue("");
        ResponseType responseType = this.objFact.createResponseType();
        responseType.setPromptStopped(promptStoppedType);
        responseType.setReqId(n);
        return (Message)this.createMessage.transform((Object)responseType);
    }

    private class CreateRestartOutput
    implements Transformer {
        private CreateRestartOutput() {
        }

        public Object transform(Object object) {
            RestartOutputType restartOutputType = CommandFormatter.this.objFact.createRestartOutputType();
            restartOutputType.setValue("");
            CommandType commandType = CommandFormatter.this.objFact.createCommandType();
            commandType.setRestartOutput(restartOutputType);
            if (object instanceof TaskId) {
                commandType.setCmdId(((TaskId)TaskId.class.cast(object)).getId());
            }
            return commandType;
        }
    }

    private class CreateStopOutput
    implements Transformer {
        private CreateStopOutput() {
        }

        public Object transform(Object object) {
            StopOutputType stopOutputType = CommandFormatter.this.objFact.createStopOutputType();
            stopOutputType.setValue("");
            CommandType commandType = CommandFormatter.this.objFact.createCommandType();
            commandType.setStopOutput(stopOutputType);
            if (object instanceof TaskId) {
                commandType.setCmdId(((TaskId)TaskId.class.cast(object)).getId());
            }
            return commandType;
        }
    }

    private class CreateInteruptCommand
    implements Transformer {
        private CreateInteruptCommand() {
        }

        public Object transform(Object object) {
            InterruptCommandType interruptCommandType = CommandFormatter.this.objFact.createInterruptCommandType();
            interruptCommandType.setValue("");
            CommandType commandType = CommandFormatter.this.objFact.createCommandType();
            commandType.setInterruptCommand(interruptCommandType);
            if (object instanceof TaskId) {
                commandType.setCmdId(((TaskId)TaskId.class.cast(object)).getId());
            }
            return commandType;
        }
    }

    private class CreateStopCommand
    implements Transformer {
        private CreateStopCommand() {
        }

        public Object transform(Object object) {
            StopCommandType stopCommandType = CommandFormatter.this.objFact.createStopCommandType();
            stopCommandType.setValue("");
            CommandType commandType = CommandFormatter.this.objFact.createCommandType();
            commandType.setStopCommand(stopCommandType);
            if (object instanceof TaskId) {
                commandType.setCmdId(((TaskId)TaskId.class.cast(object)).getId());
            }
            return commandType;
        }
    }

    private class CreateStartCommand
    implements Transformer {
        private CreateStartCommand() {
        }

        public Object transform(Object object) {
            Object object2;
            StartCommandType startCommandType = CommandFormatter.this.objFact.createStartCommandType();
            if (object instanceof Task) {
                object2 = (Task)Task.class.cast(object);
                startCommandType.setTmpId(object2.getTempId());
                startCommandType.setValue(object2.getTypedCommand());
                if (object2.getProspectiveHost() != null) {
                    startCommandType.setTarget(object2.getProspectiveHost().getId());
                }
            }
            object2 = CommandFormatter.this.objFact.createCommandType();
            ((CommandType)object2).setStartCommand(startCommandType);
            ((CommandType)object2).setCmdId(0);
            return object2;
        }
    }

    private class GetPing
    implements Transformer {
        private GetPing() {
        }

        public Object transform(Object object) {
            PingType pingType = CommandFormatter.this.objFact.createPingType();
            pingType.setValue("");
            return pingType;
        }
    }

    private class GetStatistics
    implements Transformer {
        private GetStatistics() {
        }

        public Object transform(Object object) {
            GetStatisticsType getStatisticsType = CommandFormatter.this.objFact.createGetStatisticsType();
            getStatisticsType.setValue("");
            return getStatisticsType;
        }
    }

    private class CommandList
    implements Transformer {
        private CommandList() {
        }

        public Object transform(Object object) {
            ListCommandsType listCommandsType = CommandFormatter.this.objFact.createListCommandsType();
            listCommandsType.setValue("");
            return listCommandsType;
        }
    }

    private class CreateResponse
    implements Transformer {
        private CreateResponse() {
        }

        public Object transform(Object object) {
            ResponseType responseType = CommandFormatter.this.objFact.createResponseType();
            if (object instanceof CommandListType) {
                responseType.setCommandList((CommandListType)CommandListType.class.cast(object));
            } else if (object instanceof GuiCommandResponse) {
                responseType.setGuiCommand((GuiCommandResponse)GuiCommandResponse.class.cast(object));
            } else if (object instanceof HelpType) {
                responseType.setHelp((HelpType)HelpType.class.cast(object));
            } else if (object instanceof PongType) {
                responseType.setPong((PongType)PongType.class.cast(object));
            } else if (object instanceof PromptStoppedType) {
                responseType.setPromptStopped((PromptStoppedType)PromptStoppedType.class.cast(object));
            } else if (object instanceof StatisticsType) {
                responseType.setStatistics((StatisticsType)StatisticsType.class.cast(object));
            } else if (object instanceof UserEntryType) {
                responseType.setUserEntry((UserEntryType)UserEntryType.class.cast(object));
            }
            return responseType;
        }
    }

    private class CreateRequest
    implements Transformer {
        private CreateRequest() {
        }

        public Object transform(Object object) {
            RequestType requestType = CommandFormatter.this.objFact.createRequestType();
            if (object instanceof GetHelpType) {
                requestType.setGetHelp((GetHelpType)GetHelpType.class.cast(object));
            } else if (object instanceof GetStatisticsType) {
                requestType.setGetStatistics((GetStatisticsType)GetStatisticsType.class.cast(object));
            } else if (object instanceof ListCommandsType) {
                requestType.setListCommands((ListCommandsType)ListCommandsType.class.cast(object));
            } else if (object instanceof PingType) {
                requestType.setPing((PingType)PingType.class.cast(object));
            } else if (object instanceof StartPromptType) {
                requestType.setStartPrompt((StartPromptType)StartPromptType.class.cast(object));
            } else if (object instanceof StopPromptType) {
                requestType.setStopPrompt((StopPromptType)StopPromptType.class.cast(object));
            }
            requestType.setReqId(CommandFormatter.this.nextRequestId++);
            return requestType;
        }
    }

    private class CreateMessage
    implements Transformer {
        private CreateMessage() {
        }

        public Object transform(Object object) {
            Message message = CommandFormatter.this.objFact.createMessage();
            if (object instanceof CommandType) {
                message.setCmd((CommandType)CommandType.class.cast(object));
            } else if (object instanceof InfoType) {
                message.setInfo((InfoType)InfoType.class.cast(object));
            } else if (object instanceof RequestType) {
                message.setReq((RequestType)RequestType.class.cast(object));
            } else if (object instanceof ResponseType) {
                message.setRes((ResponseType)ResponseType.class.cast(object));
            }
            return message;
        }
    }

    private class CreateShutdown
    implements Transformer {
        private CreateShutdown() {
        }

        public Object transform(Object object) {
            ShutdownType shutdownType = CommandFormatter.this.objFact.createShutdownType();
            shutdownType.setValue("");
            CommandType commandType = CommandFormatter.this.objFact.createCommandType();
            commandType.setShutdown(shutdownType);
            commandType.setCmdId(0);
            return commandType;
        }
    }
}

