/*
 * Decompiled with CFR 0.152.
 */
package ds.core;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.Plugin;
import ddb.util.JaxbCache;
import ds.core.DSConstants;
import ds.jaxb.configuration.ColorType;
import ds.jaxb.configuration.ConfigurationType;
import ds.jaxb.configuration.ObjectFactory;
import ds.jaxb.configuration.ObjectType;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationStore {
    private File root = null;
    private CoreController core;
    private Map<Class<? extends Plugin>, Map<String, Object>> classToOptions;

    public ConfigurationStore(String string, CoreController coreController) {
        this(new File(string), coreController);
    }

    public ConfigurationStore(File file, CoreController coreController) {
        Unmarshaller unmarshaller;
        this.core = coreController;
        this.classToOptions = new Hashtable<Class<? extends Plugin>, Map<String, Object>>();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            if (file.mkdir()) {
                this.root = file;
            }
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        this.root = file;
        try {
            JAXBContext jAXBContext = JaxbCache.getContext(ObjectFactory.class);
            unmarshaller = jAXBContext.createUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            this.core.logEvent(Level.WARNING, "Unable to load user configuration", (Throwable)jAXBException);
            return;
        }
        for (File file2 : this.root.listFiles(new XmlFileFilter())) {
            try {
                Object object;
                Object object2 = unmarshaller.unmarshal(file2);
                ConfigurationType configurationType = null;
                if (object2 instanceof JAXBElement) {
                    object = (JAXBElement)JAXBElement.class.cast(object2);
                    object2 = object.getValue();
                }
                if (object2 instanceof ConfigurationType) {
                    configurationType = (ConfigurationType)ConfigurationType.class.cast(object2);
                }
                if (configurationType == null) continue;
                object = Class.forName(configurationType.getClazz(), false, DSConstants.getClassLoader());
                Class<Plugin> clazz = ((Class)object).asSubclass(Plugin.class);
                Map<String, Object> map = this.classToOptions.get(clazz);
                if (map == null) {
                    map = new Hashtable<String, Object>();
                    this.classToOptions.put(clazz, map);
                }
                for (ObjectType objectType : configurationType.getObject()) {
                    if (objectType.getString() != null) {
                        map.put(objectType.getName(), objectType.getString());
                        continue;
                    }
                    if (objectType.getColor() != null) {
                        Color color = new Color(objectType.getColor().getRed().intValue(), objectType.getColor().getGreen().intValue(), objectType.getColor().getBlue().intValue());
                        map.put(objectType.getName(), color);
                        continue;
                    }
                    if (objectType.getData() != null) {
                        map.put(objectType.getName(), objectType.getData());
                        continue;
                    }
                    map.put(objectType.getName(), this.extractList(objectType));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Collection<Object> extractList(ObjectType objectType) {
        Vector<Object> vector = new Vector<Object>();
        for (ObjectType objectType2 : objectType.getObject()) {
            if (objectType2.getString() != null) {
                vector.add(objectType2.getString());
                continue;
            }
            if (objectType2.getColor() != null) {
                Color color = new Color(objectType2.getColor().getRed().intValue(), objectType2.getColor().getGreen().intValue(), objectType2.getColor().getBlue().intValue());
                vector.add(color);
                continue;
            }
            if (objectType2.getData() != null) {
                vector.add(objectType2.getData());
                continue;
            }
            vector.add(this.extractList(objectType2));
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitSettings() {
        ConfigurationStore configurationStore = this;
        synchronized (configurationStore) {
            Marshaller marshaller;
            ObjectFactory objectFactory;
            try {
                objectFactory = new ObjectFactory();
                JAXBContext jAXBContext = JaxbCache.getContext(ObjectFactory.class);
                marshaller = jAXBContext.createMarshaller();
            }
            catch (JAXBException jAXBException) {
                this.core.logEvent(Level.WARNING, "Unable to load user configuration", (Throwable)jAXBException);
                return;
            }
            for (Class<? extends Plugin> clazz : this.classToOptions.keySet()) {
                ConfigurationType configurationType = new ConfigurationType();
                configurationType.setClazz(clazz.getCanonicalName());
                Map<String, Object> map = this.classToOptions.get(clazz);
                for (String string : map.keySet()) {
                    ObjectType objectType = new ObjectType();
                    objectType.setName(string);
                    Object object = map.get(string);
                    if (object instanceof Collection) {
                        this.addListToObject((Collection)Collection.class.cast(object), objectType.getObject());
                    } else if (object instanceof Color) {
                        ColorType colorType = new ColorType();
                        Color color = (Color)Color.class.cast(object);
                        colorType.setRed(BigInteger.valueOf(color.getRed()));
                        colorType.setGreen(BigInteger.valueOf(color.getGreen()));
                        colorType.setBlue(BigInteger.valueOf(color.getBlue()));
                        objectType.setColor(colorType);
                    } else if (object instanceof byte[]) {
                        objectType.setData((byte[])byte[].class.cast(object));
                    } else {
                        objectType.setString(object.toString());
                    }
                    configurationType.getObject().add(objectType);
                }
                try {
                    marshaller.marshal(objectFactory.createConfiguration(configurationType), (OutputStream)new FileOutputStream(this.root.getAbsolutePath() + "/" + clazz.getSimpleName() + ".xml"));
                }
                catch (Throwable throwable) {
                    this.core.logEvent(Level.WARNING, "Unable to save configuration", throwable);
                }
            }
        }
    }

    private void addListToObject(Collection<?> collection, Collection<ObjectType> collection2) {
        for (Object obj : collection) {
            Object object;
            ObjectType objectType = new ObjectType();
            if (obj instanceof Collection) {
                object = (Collection)Collection.class.cast(obj);
                this.addListToObject((Collection<?>)object, (Collection<ObjectType>)objectType.getObject());
            } else if (obj instanceof Color) {
                object = new ColorType();
                Color color = (Color)Color.class.cast(obj);
                ((ColorType)object).setRed(BigInteger.valueOf(color.getRed()));
                ((ColorType)object).setGreen(BigInteger.valueOf(color.getGreen()));
                ((ColorType)object).setBlue(BigInteger.valueOf(color.getBlue()));
                objectType.setColor((ColorType)object);
            }
            if (obj instanceof byte[]) {
                objectType.setData((byte[])byte[].class.cast(obj));
            } else {
                objectType.setString(obj.toString());
            }
            collection2.add(objectType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOption(Class<? extends Plugin> clazz, String string, Object object) {
        ConfigurationStore configurationStore = this;
        synchronized (configurationStore) {
            Map<String, Object> map = this.classToOptions.get(clazz);
            if (map == null) {
                map = new Hashtable<String, Object>();
                this.classToOptions.put(clazz, map);
            }
            map.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOption(Class<? extends Plugin> clazz, String string) {
        ConfigurationStore configurationStore = this;
        synchronized (configurationStore) {
            Map<String, Object> map = this.classToOptions.get(clazz);
            if (map == null) {
                return null;
            }
            return map.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOption(Plugin plugin, String string, Object object) {
        ConfigurationStore configurationStore = this;
        synchronized (configurationStore) {
            this.setOption(plugin.getClass(), string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOption(Plugin plugin, String string) {
        ConfigurationStore configurationStore = this;
        synchronized (configurationStore) {
            return this.getOption(plugin.getClass(), string);
        }
    }

    private class XmlFileFilter
    implements FilenameFilter {
        private XmlFileFilter() {
        }

        public boolean accept(File file, String string) {
            return string.matches(".*\\.xml");
        }
    }
}

