/*
 * Decompiled with CFR 0.152.
 */
package ds.core;

import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import ddb.detach.Workbench;
import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.connection.ConnectionChangeEvent;
import ddb.dsz.core.connection.events.LpTerminatedEvent;
import ddb.dsz.core.connection.events.OperationChanged;
import ddb.dsz.core.connection.events.StatisticsEvent;
import ddb.dsz.core.connection.events.ThrottleEvent;
import ddb.dsz.core.controller.CommandSet;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.Plugin;
import ddb.imagemanager.ImageManager;
import ddb.splash.SplashScreen3;
import ddb.util.GeneralUtilities;
import ddb.util.JaxbCache;
import ddb.util.LogFileManager;
import ddb.util.LpConfigWriter;
import ddb.util.PluginInitInfo;
import ddb.util.StartupConfigParser;
import ddb.util.jar.JarFileClassInspector;
import ds.core.ConfirmExit;
import ds.core.ConnectionEstablisher;
import ds.core.DSConstants;
import ds.core.StartupException;
import ds.core.StatusBar;
import ds.core.controller.AbstractCoreController;
import ds.core.controller.MutableCoreController;
import ds.core.impl.HostInfoImpl;
import ds.gui.PluginWorkbench;
import ds.gui.QuitAction;
import ds.jaxb.guiconfig.GuiConfig;
import ds.jaxb.guiconfig.ObjectFactory;
import ds.jaxb.ipc.ConnectionInfoType;
import ds.jaxb.ipc.HostInfoType;
import ds.jaxb.ipc.Message;
import ds.jaxb.ipc.ThrottleInfoType;
import ds.plugin.peer.Peer;
import ds.plugin.peer.PeerServer;
import ds.plugin.replay.ReplayTableModel;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSClient
extends AbstractCoreController
implements CoreController,
MutableCoreController {
    Runnable Repaint = new Runnable(){

        public void run() {
        }
    };
    private CommandSet commands = new CommandSet();
    private LogFileManager logManager;
    private int dispatcherPort;
    private SplashScreen3 splash;
    private int remoteAddress = -1;
    private Operation liveOperation;
    private Thread connectionThread = null;
    private ConnectionEstablisher establisher = null;
    private boolean quitHappened = false;
    private JCheckBoxMenuItem debugItem;
    private JCheckBoxMenuItem autoFocus;
    private CoreController.OperationState opState = CoreController.OperationState.NotConnected;
    private final ButtonGroup lnfButtons = new ButtonGroup();
    private final int SPLASH_MAJOR_STAGES = 5;
    private int SPLASH_MAJOR_CURRENT = 0;
    private int SPLASH_MINOR_STAGES = 0;
    private int SPLASH_MINOR_CURRENT = 0;
    private boolean startedDirectoryMonitor = false;
    private WindowListener windowListener = new WindowAdapter(){

        public void windowOpened(WindowEvent windowEvent) {
            DSClient.this.setFocusOnDefaultElement();
        }

        public void windowClosing(WindowEvent windowEvent) {
            DSClient.this.requestShutdown();
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (DSClient.this.autoFocus != null && DSClient.this.autoFocus.isSelected()) {
                DSClient.this.setFocusOnDefaultElement();
            }
        }
    };
    static final AtomicBoolean success = new AtomicBoolean(false);

    public DSClient(SplashScreen3 splashScreen3, String[] stringArray) {
        super(stringArray);
        Object object;
        Object object2;
        Object object3;
        FileHandler fileHandler;
        Calendar calendar;
        this.splash = splashScreen3;
        splashScreen3.setDisplayedText("Initializing internal data");
        splashScreen3.setMajorProgress(0, 5, this.SPLASH_MAJOR_CURRENT++);
        splashScreen3.setStageIcon(DSConstants.StageIcon.INTERNAL_DATA.getPath());
        this.systemLogger = Logger.getLogger("ds.core");
        this.systemLogger.setLevel(Level.ALL);
        this.systemLogger.setUseParentHandlers(false);
        File file = new File(this.getLogDir(), "GuiSystemLog");
        file.mkdirs();
        try {
            calendar = Calendar.getInstance();
            fileHandler = new FileHandler(String.format("%s/%s-%%u.xml", file.getAbsolutePath(), GeneralUtilities.CalendarToStringFile((Calendar)Calendar.getInstance())));
            fileHandler.setLevel(Level.WARNING);
            this.systemLogger.addHandler(fileHandler);
        }
        catch (Exception exception) {
            this.logEvent(Level.WARNING, exception.getMessage(), exception);
        }
        if (this.isDebugMode()) {
            try {
                calendar = Calendar.getInstance();
                fileHandler = new FileHandler(String.format("%s/%s-%%u.all.xml", file.getAbsolutePath(), GeneralUtilities.CalendarToStringFile((Calendar)Calendar.getInstance())));
                fileHandler.setLevel(Level.ALL);
                this.systemLogger.addHandler(fileHandler);
            }
            catch (Exception exception) {
                this.logEvent(Level.WARNING, exception.getMessage(), exception);
            }
        }
        this.logManager = new LogFileManager(this.getLogDir() + "/Logs/", "dsz", this.systemLogger);
        splashScreen3.setDisplayedText("Loading GUI configuration");
        splashScreen3.setMajorProgress(0, 5, this.SPLASH_MAJOR_CURRENT++);
        splashScreen3.setStageIcon(DSConstants.StageIcon.STARTUP_CONFIG.getPath());
        calendar = JaxbCache.getContext(ObjectFactory.class);
        if (calendar != null) {
            try {
                object3 = calendar.createUnmarshaller();
                for (String string : object2 = new String[]{"Ops", "Dsz", "."}) {
                    File file2 = new File(String.format("%s/%s/Gui/Config/guiConfig.xml", this.getResourceDirectory(), string));
                    if (!file2.exists()) continue;
                    Object object4 = object3.unmarshal(file2);
                    if (object4 instanceof JAXBElement) {
                        object4 = ((JAXBElement)JAXBElement.class.cast(object4)).getValue();
                    }
                    if (!(object4 instanceof GuiConfig)) continue;
                    GuiConfig guiConfig = (GuiConfig)GuiConfig.class.cast(object4);
                    DSConstants.WINDOW_WIDTH = guiConfig.getWindowSize().getWidth().intValue();
                    DSConstants.WINDOW_HEIGHT = guiConfig.getWindowSize().getHeight().intValue();
                    DSConstants.FRAME_WIDTH = guiConfig.getFrameSize().getWidth().intValue();
                    DSConstants.FRAME_HEIGHT = guiConfig.getFrameSize().getHeight().intValue();
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        splashScreen3.setDisplayedText("Loading plugin configuration");
        splashScreen3.setMajorProgress(0, 5, this.SPLASH_MAJOR_CURRENT++);
        splashScreen3.setStageIcon(DSConstants.StageIcon.PLUGIN.getPath());
        object3 = DSConstants.getStartupConfigurationFiles(new File(this.getResourceDirectory()), "systemStartup");
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (File)object2.next();
            try {
                this.autoloadPlugins.addAll(StartupConfigParser.parse(new FileInputStream((File)object), this.getLogDir(), String.format("%s/%s", this.getResourceDirectory(), this.getDefaultPackage()), this.getBuildType()));
            }
            catch (Exception exception) {
                this.logEvent(Level.SEVERE, String.format("Exception while parsing config XML file\n%s\n%s", ((File)object).getAbsolutePath(), exception.getMessage()), exception);
                return;
            }
        }
        splashScreen3.setDisplayedText("Creating socket for dispatcher IPC");
        splashScreen3.setMajorProgress(0, 5, this.SPLASH_MAJOR_CURRENT++);
        splashScreen3.setStageIcon(DSConstants.StageIcon.SOCKET.getPath());
        object2 = null;
        try {
            object2 = new ServerSocket(0);
        }
        catch (Exception exception) {
            this.logEvent(Level.SEVERE, exception.getMessage(), exception);
            return;
        }
        this.dispatcherPort = ((ServerSocket)object2).getLocalPort();
        this.establisher = new ConnectionEstablisher((ServerSocket)object2, this);
        this.connectionThread = this.newThread(this.establisher);
        this.connectionThread.start();
        object = new File(this.getLogDir(), "config.xml");
        ((File)object).getParentFile().mkdirs();
        try {
            if (this.remoteAddress > -1) {
                LpConfigWriter.writeConfig(this.dispatcherPort, this.getLogDir(), String.format("%s/%s", this.getResourceDirectory(), this.getDefaultPackage()), this.remoteAddress, (File)object, this.getLocalhostAddress());
            } else {
                LpConfigWriter.writeConfig(this.dispatcherPort, this.getLogDir(), String.format("%s/%s", this.getResourceDirectory(), this.getDefaultPackage()), (File)object, this.getLocalhostAddress());
            }
        }
        catch (Exception exception) {
            this.logEvent(Level.SEVERE, exception.getMessage(), exception);
            return;
        }
    }

    @Override
    public void initialize2() {
        this.getWorkbench().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                StatusBar statusBar = DSClient.this.getStatusBar();
                PluginWorkbench pluginWorkbench = DSClient.this.getWorkbench();
                if (statusBar != null && pluginWorkbench != null) {
                    statusBar.setStatus(pluginWorkbench.getStatus());
                }
                DSClient.this.addConnectionChangeListener(statusBar);
            }
        });
        this.logEvent(Level.INFO, "logDir = " + this.getLogDir());
        this.logEvent(Level.INFO, "resourceDir = " + this.getResourceDirectory());
        this.setupMenuBar();
        this.getWorkbench().setTabPlacement(DSConstants.MAIN_TAB_ALIGNMENT);
        this.splash.setMajorProgress(0, 5, this.SPLASH_MAJOR_CURRENT++);
        this.SPLASH_MINOR_STAGES = this.autoloadPlugins.size();
        EventQueue.invokeLater(new InitializeStep(this.autoloadPlugins));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establishConnection() {
        this.splash.setMajorProgress(0, 5, this.SPLASH_MAJOR_CURRENT++);
        this.splash.setStageIcon(DSConstants.StageIcon.WAITING.getPath());
        try {
            Socket socket;
            String string = "Waiting for connection";
            int n = 15;
            for (int i = 0; i < n; ++i) {
                this.splash.setDisplayedText(String.format("%s:  %d seconds left", string, n - i));
                this.splash.setMinorProgress(0, n, i);
                try {
                    this.connectionThread.join(TimeUnit.SECONDS.toMillis(1L));
                    if (this.connectionThread.isAlive()) continue;
                    success.set(true);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!success.get()) {
                this.splash.setMajorProgress(0, 5, this.SPLASH_MAJOR_CURRENT++);
                this.splash.setDisplayedText(String.format("Press 'skip' to continue", new Object[0]));
                this.splash.setMinorIndeterminate(true);
                this.splash.showSkip(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        success.set(true);
                    }
                });
                while (!success.get()) {
                    try {
                        this.connectionThread.join(TimeUnit.SECONDS.toMillis(1L));
                        if (this.connectionThread.isAlive()) continue;
                        success.set(true);
                    }
                    catch (Exception exception) {}
                }
            }
            if ((socket = this.establisher.getConnection()) == null) {
                String string2 = "No connection established with LP dispatcher";
                StartupException startupException = new StartupException(string2);
                startupException.fillInStackTrace();
                throw startupException;
            }
            this.dispatcherClient.addLiveCommandDispatcher(socket);
        }
        catch (Exception exception) {
            this.logEvent(Level.SEVERE, exception.getMessage(), exception);
            return;
        }
        finally {
            this.establisher = null;
            this.connectionThread = null;
        }
    }

    @Override
    protected void parseArg(String string, String string2) {
        if (string.equals("-build")) {
            super.setBuildType(string2);
        } else if (string.equals("-remoteAddress")) {
            this.remoteAddress = Integer.parseInt(string2);
        } else if (string.equals("-loadPrevious")) {
            ReplayTableModel.getReplayModel().setAutoLoad(Boolean.parseBoolean(string2));
        } else {
            super.parseArg(string, string2);
        }
    }

    public void setupMaintenanceTasks() {
        this.scheduleWithFixedDelay(new Runnable(){
            boolean failed = false;

            public void run() {
                if (this.failed) {
                    return;
                }
                if (CoreController.OperationState.Inactive.equals((Object)DSClient.this.getOperationState())) {
                    this.failed = true;
                    return;
                }
                try {
                    DSClient.this.dispatcherClient.requestCommandListUpdate();
                }
                catch (Exception exception) {
                    DSClient.this.logEvent(Level.WARNING, "commandListUpdateTask exception", exception);
                    this.failed = true;
                }
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void updateConnectionInfo(Message message) {
        ThrottleInfoType throttleInfoType;
        ConnectionInfoType connectionInfoType = message.getInfo().getConnectionInfo();
        if (connectionInfoType != null) {
            throttleInfoType = TaskId.GenerateTaskId((int)message.getInfo().getCmdId(), (Operation)this.getOperation());
            for (HostInfoType hostInfoType : connectionInfoType.getHost()) {
                this.handleHostInfo(hostInfoType, (TaskId)throttleInfoType);
            }
            try {
                this.dispatcherClient.requestCommandListUpdate();
            }
            catch (Exception exception) {
                this.logEvent(Level.SEVERE, "Unable to update command list", exception);
            }
        }
        if ((throttleInfoType = message.getInfo().getThrottleInfo()) != null) {
            this.fireConnectionChangeEvent((ConnectionChangeEvent)new ThrottleEvent((Object)this, throttleInfoType.getAddress(), throttleInfoType.getBytesPerSecond()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHostInfo(HostInfoType hostInfoType, TaskId taskId) {
        if (hostInfoType == null) {
            return;
        }
        HostInfoImpl hostInfoImpl = new HostInfoImpl(hostInfoType.getAddress(), hostInfoType.getHostname(), hostInfoType.getVersion(), hostInfoType.getArch(), hostInfoType.getPlatform(), hostInfoType.getImplantType(), hostInfoType.isLocal(), hostInfoType.isConnected());
        boolean bl = false;
        List list = this.hosts;
        synchronized (list) {
            for (HostInfo hostInfo : this.hosts) {
                if (!hostInfo.sameHost((HostInfo)hostInfoImpl)) continue;
                hostInfo.copyFromHost((HostInfo)hostInfoImpl);
                hostInfoImpl = hostInfo;
                bl = true;
                break;
            }
        }
        hostInfoImpl.setTask(taskId);
        if (!bl) {
            this.hosts.add(hostInfoImpl);
        }
        if (hostInfoImpl.isConnected()) {
            this.fireConnectionNewHost((HostInfo)hostInfoImpl);
        } else {
            this.fireDisconnectedHost((HostInfo)hostInfoImpl);
        }
        if (!this.startedDirectoryMonitor) {
            this.createDirectoryMonitor();
        }
    }

    @Override
    public void updateStatistics(StatisticsEvent statisticsEvent) {
        this.fireStatisticsChanged(statisticsEvent);
    }

    @Override
    public void setOwningFrame(JFrame jFrame) {
        super.setOwningFrame(jFrame);
        jFrame.addWindowListener(this.windowListener);
    }

    @Override
    public final void setTitle(String string) {
        super.setTitle(string);
        if (this.mPeer != null) {
            string = String.format("%d: %s", ((PeerServer)PeerServer.class.cast(this.mPeer)).getServerPort(), string);
        }
        this.title = string;
        EventQueue.invokeLater(new Title());
    }

    private void setupMenuBar() {
        JMenu jMenu = new JMenu("File");
        ImageIcon imageIcon = ImageManager.getIcon((String)DSConstants.Icon.QUIT.getPath(), (Dimension)ImageManager.SIZE22);
        JMenuItem jMenuItem = new JMenuItem("Quit", imageIcon);
        JMenuItem jMenuItem2 = new JMenuItem("Show Running Plugins");
        JMenuItem jMenuItem3 = new JMenuItem("Rename Window");
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        jMenu.add(jMenuItem);
        this.getMenuBar().add(jMenu);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(DSClient.this.getOwningFrame(), "Enter new title", "Rename Window", 3);
                if (string != null) {
                    EventQueue.invokeLater(new Title());
                    DSClient.this.userTitle = string;
                }
            }
        });
        JMenu jMenu2 = new JMenu("Options");
        this.autoFocus = new JCheckBoxMenuItem("Focus On Activation");
        this.autoFocus.setSelected(true);
        this.debugItem = new JCheckBoxMenuItem("Debug mode", ImageManager.getIcon((String)DSConstants.Icon.DEBUG.getPath(), (Dimension)this.getLabelImageSize()), false);
        this.debugItem.setSelected(super.isDebugMode());
        jMenu2.add(this.autoFocus);
        jMenu2.addSeparator();
        jMenu2.add(this.debugItem);
        this.getMenuBar().add(jMenu2);
        jMenuItem.addActionListener(new QuitAction(this));
        jMenuItem2.addActionListener(new ShowRunningPluginsListAction());
        if (this.isDebugMode()) {
            final JMenu jMenu3 = new JMenu("Look And Feel");
            this.getMenuBar().add(jMenu3);
            SwingWorker<List<Class<? extends LookAndFeel>>, Void> swingWorker = new SwingWorker<List<Class<? extends LookAndFeel>>, Void>(){

                @Override
                protected List<Class<? extends LookAndFeel>> doInBackground() throws Exception {
                    Vector<Class<? extends LookAndFeel>> vector = new Vector<Class<? extends LookAndFeel>>();
                    vector.add(NimbusLookAndFeel.class);
                    vector.add(MotifLookAndFeel.class);
                    vector.add(WindowsLookAndFeel.class);
                    vector.add(MetalLookAndFeel.class);
                    vector.add(BasicLookAndFeel.class);
                    vector.add(SynthLookAndFeel.class);
                    for (JarFileClassInspector jarFileClassInspector : JarFileClassInspector.getInspectors((ClassLoader)DSClient.class.getClassLoader())) {
                        try {
                            System.out.println(jarFileClassInspector.toString());
                            vector.addAll(jarFileClassInspector.getAllClassesExtendingClass(LookAndFeel.class));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    return vector;
                }

                @Override
                protected void done() {
                    try {
                        List list = (List)this.get();
                        for (Class clazz : list) {
                            JMenuItem jMenuItem = DSClient.this.createLookAndFeelSelector(clazz);
                            if (jMenuItem == null) continue;
                            jMenu3.add(jMenuItem);
                        }
                    }
                    catch (Throwable throwable) {
                        Logger.getLogger(DSClient.class.getName()).log(Level.SEVERE, null, throwable);
                        throwable.printStackTrace();
                    }
                }
            };
            swingWorker.execute();
        }
    }

    private JMenuItem createLookAndFeelSelector(final Class<? extends LookAndFeel> clazz) {
        Object object;
        String string = clazz.getSimpleName();
        try {
            object = clazz.newInstance();
            string = ((LookAndFeel)object).getName();
            if (!((LookAndFeel)object).isSupportedLookAndFeel()) {
                return null;
            }
        }
        catch (Exception exception) {
            System.err.printf("Cannot create %s:  %s\n", clazz.getSimpleName(), exception.getMessage());
            return null;
        }
        object = new JRadioButtonMenuItem(string);
        this.lnfButtons.add((AbstractButton)object);
        if (clazz.equals(UIManager.getLookAndFeel().getClass())) {
            ((AbstractButton)object).setSelected(true);
        }
        ((AbstractButton)object).addActionListener(new ActionListener((JRadioButtonMenuItem)object){
            final /* synthetic */ JRadioButtonMenuItem val$item;
            {
                this.val$item = jRadioButtonMenuItem;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UIManager.setLookAndFeel(clazz.getName());
                    SwingUtilities.updateComponentTreeUI(DSClient.this.getOwningFrame());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    DSClient.this.logEvent(Level.SEVERE, exception.getMessage(), exception);
                }
                this.val$item.setSelected(true);
            }
        });
        return object;
    }

    public String getSystemLoggerName() {
        return "ds.core";
    }

    public CommandSet getCommandSet() {
        return this.commands;
    }

    public Logger getSystemLogger() {
        return this.systemLogger;
    }

    public void processCommandLine(String string, IdCallback idCallback, Object object, HostInfo hostInfo) throws DispatcherException {
        try {
            this.getDispatcherClient().startCommand(string, idCallback, object, hostInfo);
        }
        catch (DispatcherException dispatcherException) {
            this.logEvent(Level.SEVERE, "DispatcherException caught while formatting outgoing command", dispatcherException);
            throw dispatcherException;
        }
        catch (JAXBException jAXBException) {
            this.logEvent(Level.SEVERE, "JAXBException caught while formatting outgoing command", jAXBException);
            throw new DispatcherException("XML message formatting failed");
        }
        catch (IOException iOException) {
            this.logEvent(Level.SEVERE, "IOException caught while sending command", iOException);
            throw new DispatcherException("I/O exception");
        }
    }

    public String disconnect() {
        this.dispatcherClient.disconnect();
        return "Disconnecting...\n";
    }

    public void requestShutdown() {
        ConfirmExit confirmExit;
        if (this.isConnected() && !(confirmExit = new ConfirmExit((Frame)this.getOwningFrame(), true, this.executor)).query()) {
            return;
        }
        this.fullStop = true;
        try {
            this.dispatcherClient.sendShutdownNotification();
        }
        catch (DispatcherException dispatcherException) {
            this.shutdown(true);
        }
        catch (Exception exception) {
            this.logEvent(Level.WARNING, "Exception while notifying Lp of shutdown\n" + exception.getMessage(), exception);
        }
    }

    @Override
    public void shutdown(boolean bl) {
        this.quitHappened = true;
        if (!bl) {
            this.setTitle(String.format("%s (Unexpected termination)", "DanderSpritz"));
        }
        if (this.fullStop) {
            this.execute(new DoFullQuit());
        }
        super.stop();
    }

    public String status() {
        String string = this.dispatcherClient.isConnected() ? "Connected to " + this.dispatcherClient.toString() + "\n" : "Not connected\n";
        return string;
    }

    public void addPrefixesToTask(TaskId taskId, List<String> list) throws DispatcherException {
        try {
            this.dispatcherClient.addPrefixes(taskId, list);
        }
        catch (DispatcherException dispatcherException) {
            throw dispatcherException;
        }
        catch (JAXBException jAXBException) {
            throw new DispatcherException("Command formatting error while trying to add prefixes to task " + taskId);
        }
        catch (IOException iOException) {
            throw new DispatcherException("I/O Error while trying to add prefixes to task " + taskId);
        }
    }

    public void stopCommandOutput(Task task) throws DispatcherException {
        try {
            this.dispatcherClient.stopCommandOutput(task.getId());
        }
        catch (DispatcherException dispatcherException) {
            throw dispatcherException;
        }
        catch (JAXBException jAXBException) {
            throw new DispatcherException("Command formatting error while trying to stop task " + task.getId());
        }
        catch (IOException iOException) {
            throw new DispatcherException("I/O Error while trying to stop command " + task.getId());
        }
    }

    public void restartCommandOutput(Task task) throws DispatcherException {
        try {
            this.dispatcherClient.restartCommandOutput(task.getId());
        }
        catch (DispatcherException dispatcherException) {
            throw dispatcherException;
        }
        catch (JAXBException jAXBException) {
            throw new DispatcherException("Command formatting error while trying to stop task " + task.getId());
        }
        catch (IOException iOException) {
            throw new DispatcherException("I/O Error while trying to stop command " + task.getId());
        }
    }

    public void killCommand(Task task) throws DispatcherException {
        this.killOrInterruptCommand(task, true);
    }

    public void interruptCommand(Task task) throws DispatcherException {
        this.killOrInterruptCommand(task, false);
    }

    public void killOrInterruptCommand(Task task, boolean bl) throws DispatcherException {
        try {
            if (bl) {
                this.dispatcherClient.stopCommand(task.getId());
            } else {
                this.dispatcherClient.interruptCommand(task.getId());
            }
        }
        catch (DispatcherException dispatcherException) {
            throw dispatcherException;
        }
        catch (JAXBException jAXBException) {
            throw new DispatcherException("Command formatting error while trying to kill or interrupt task " + task.getId());
        }
        catch (IOException iOException) {
            throw new DispatcherException("I/O Error while trying to kill or interrupt command " + task.getId());
        }
    }

    public void startCommand(String string, IdCallback idCallback, Object object, HostInfo hostInfo) throws DispatcherException {
        while (this.hosts.size() == 0) {
            try {
                TimeUnit.MILLISECONDS.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger("ds.core").log(Level.SEVERE, null, interruptedException);
            }
        }
        this.processCommandLine(string, idCallback, object, hostInfo);
    }

    public void sendPromptReply(int n, TaskId taskId, String string) {
        try {
            this.dispatcherClient.sendPromptReply(n, taskId, string);
        }
        catch (DispatcherException dispatcherException) {
            this.logEvent(Level.WARNING, "DispatcherException caught while replying to prompt", dispatcherException);
        }
        catch (IOException iOException) {
            this.logEvent(Level.WARNING, "DispatcherException caught while replying to prompt", iOException);
        }
        catch (JAXBException jAXBException) {
            this.logEvent(Level.WARNING, "DispatcherException caught while replying to prompt", jAXBException);
        }
    }

    public void requestHelpStatement(String string, HostInfo hostInfo) throws DispatcherException {
        try {
            this.dispatcherClient.requestHelpStatement(string, hostInfo);
        }
        catch (JAXBException jAXBException) {
            throw new DispatcherException("Unable to create XML message for IPC with dispatcher");
        }
        catch (IOException iOException) {
            throw new DispatcherException("Request for command help caused IOException");
        }
    }

    public File createLogFile(String string) {
        return this.logManager.createLogFile(string);
    }

    public boolean isLiveOperation() {
        return true;
    }

    @Override
    public void exceptionOccurredInPlugin(Plugin plugin) {
        this.logEvent(Level.SEVERE, "Fatal error in plugin: " + plugin.toString());
        this.getWorkbench().enqueAction(PluginWorkbench.PluginWorkbenchAction.STOPPLUGIN, new Object[]{plugin});
    }

    @Override
    public <E extends Serializable> E getObject(Class<? extends Plugin> clazz, String string, Class<? extends E> clazz2) {
        return null;
    }

    @Override
    public void lpConnectionTerminated() {
        super.lpConnectionTerminated();
    }

    @Override
    public Operation getOperation() {
        return this.liveOperation;
    }

    @Override
    public void offerOperation(Operation operation) {
        this.liveOperation = operation;
        this.fireConnectionChangeEvent((ConnectionChangeEvent)new OperationChanged((Object)this, operation));
    }

    @Override
    public void applicationEnded(String string) {
        if (!this.quitHappened) {
            JOptionPane.showMessageDialog(super.getOwningFrame(), "Command " + string + " prematurely terminated.\nYou can expect no more output.", "Command terminated", 2);
            this.setTitle(String.format("%s (LP Prematurely Terminated)", "DanderSpritz"));
        }
        this.opState = CoreController.OperationState.Inactive;
        this.fireConnectionChangeEvent((ConnectionChangeEvent)new LpTerminatedEvent((Object)this));
    }

    @Override
    public Class<? extends Peer> getPeer() {
        return PeerServer.class;
    }

    @Override
    public int getDispatcherPort() {
        return this.dispatcherPort;
    }

    @Override
    public boolean isDebugMode() {
        if (this.debugItem != null) {
            return this.debugItem.isSelected();
        }
        return false;
    }

    @Override
    public void setDebugMode(boolean bl) {
        if (this.debugItem != null) {
            this.debugItem.setSelected(bl);
        }
    }

    @Override
    public CoreController.OperationState getOperationState() {
        return this.opState;
    }

    @Override
    public void disconnected(String string) {
    }

    @Override
    public void setCommandEnvironmentVariable(String string, String string2, HostInfo hostInfo) {
        String string3 = "-default";
        if (hostInfo != null) {
            string3 = String.format("-destination %s", hostInfo.getId());
        }
        try {
            this.startCommand(String.format("lpsetenv -name \"_GUI_%s\" -value \"%s\" %s", string.toUpperCase(), string2, string3), null, null, this.getHostById("localhost"));
        }
        catch (Exception exception) {
            this.logEvent(Level.SEVERE, "Unable to set environment variable", exception);
        }
    }

    private class DoFullQuit
    implements Runnable {
        private DoFullQuit() {
        }

        public void run() {
            Handler[] handlerArray;
            DSClient.this.getWorkbench().stopAllPlugins();
            DSClient.this.saveUserConfig();
            for (Handler handler : handlerArray = DSClient.this.systemLogger.getHandlers()) {
                DSClient.this.systemLogger.removeHandler(handler);
                handler.flush();
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DSClient.this.getMainWidget().setVisible(false);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitializeStep
    implements Runnable {
        List<PluginInitInfo> plugins;

        InitializeStep(List<PluginInitInfo> list) {
            this.plugins = list;
            if (list != null && list.size() > 0) {
                DSClient.this.splash.setDisplayedText(String.format("Starting %s", list.get(0).getInstanceName()));
                DSClient.this.splash.setMinorProgress(0, DSClient.this.SPLASH_MINOR_STAGES, DSClient.this.SPLASH_MINOR_CURRENT++);
                DSClient.this.splash.setStageIcon(list.get(0).getIcon());
            } else {
                DSClient.this.splash.setDisplayedText("Final Setup");
                DSClient.this.splash.setMinorProgress(0, DSClient.this.SPLASH_MINOR_STAGES, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.plugins == null || this.plugins.size() == 0) {
                DSClient.this.getWorkbench().enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDINDEX, new Object[]{0});
                DSClient.this.setupMaintenanceTasks();
                DSClient dSClient = DSClient.this;
                synchronized (dSClient) {
                    DSClient.this.notifyAll();
                }
            } else {
                DSClient.this.instantiatePlugin(this.plugins.get(0));
                EventQueue.invokeLater(new InitializeStep(this.plugins.subList(1, this.plugins.size())));
            }
        }
    }

    public class Title
    implements Runnable {
        public void run() {
            JFrame jFrame = DSClient.this.getOwningFrame();
            String string = DSClient.this.getTitle();
            DSClient.this.logEvent(Level.INFO, String.format("Setting title to '%s'", string));
            if (jFrame != null) {
                jFrame.setTitle(string);
            } else {
                DSClient.this.logEvent(Level.SEVERE, String.format("Somehow owning frame is null?!  ('%s')", string));
            }
            DSClient.this.getWorkbench().titleChanged();
        }
    }

    private final class ShowRunningPluginsListAction
    implements ActionListener {
        private ShowRunningPluginsListAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DSClient.this.getWorkbench().showRunningPluginsList();
        }
    }
}

