/*
 * Decompiled with CFR 0.152.
 */
package ds.core;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.task.Task;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class PopupPromptWindow
extends JFrame {
    CoreController core;
    Task task;
    int promptId;
    private JButton bOkay;
    private JTextField input;
    private JLabel prompt;

    private PopupPromptWindow() {
        this.initComponents();
    }

    public PopupPromptWindow(CoreController coreController, Task task, int n, String string) {
        this();
        this.core = coreController;
        this.task = task;
        this.promptId = n;
        this.setTitle(String.format("%d: %s", task.getId().getId(), task.getTypedCommand()));
        this.prompt.setText(String.format("<html>%s</html>", string));
        this.pack();
    }

    public PopupPromptWindow(CoreController coreController, Task task, CommandEvent commandEvent) {
        this(coreController, task, commandEvent.getReqId(), commandEvent.getText());
    }

    private void initComponents() {
        this.prompt = new JLabel();
        this.input = new JTextField();
        this.bOkay = new JButton();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.prompt.setText("<html>blah<br/>blah</html>");
        this.input.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                PopupPromptWindow.this.inputKeyPressed(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                PopupPromptWindow.this.inputKeyTyped(keyEvent);
            }
        });
        this.bOkay.setText("Submit");
        this.bOkay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupPromptWindow.this.bOkayActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.bOkay).add(10, 10, 10)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.prompt, -1, 380, Short.MAX_VALUE).add((Component)this.input, -1, 380, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.prompt, -1, 32, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.input, -2, -1, -2).addPreferredGap(0).add((Component)this.bOkay).addContainerGap()));
        this.pack();
    }

    private void inputKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.doSend();
        }
    }

    private void inputKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.doSend();
        }
    }

    private void bOkayActionPerformed(ActionEvent actionEvent) {
        this.doSend();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PopupPromptWindow().setVisible(true);
            }
        });
    }

    private void doSend() {
        try {
            this.core.sendPromptReply(this.promptId, this.task.getId(), this.input.getText());
            this.input.setText("");
        }
        catch (DispatcherException dispatcherException) {
            this.done();
        }
    }

    private void done() {
        this.setVisible(false);
        this.dispose();
    }

    public String getPromptText() {
        return this.prompt.getText();
    }
}

