/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.CommandEventListener;
import ddb.dsz.core.command.CommandEventManager;
import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.util.UtilityConstants;
import ds.core.commanddispatcher.CommandDispatcher;
import ds.core.commanddispatcher.DirectoryMonitoringCommandDispatcher;
import ds.core.commanddispatcher.EventPublisher;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.core.commanddispatcher.ReplayCommandDispatcher;
import ds.core.commandevents.CommandEventImpl;
import ds.core.controller.MutableCoreController;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.event.EventListenerList;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleCommandDispatcherClient
implements EventPublisher,
CommandEventManager {
    protected ExecutorService executor = Executors.newSingleThreadExecutor(UtilityConstants.createThreadFactory((String)"MultipleCommandDispatcher"));
    protected MutableCoreController mutableCore;
    protected EventListenerList commandEventListenerList;
    protected Map<Operation, CommandDispatcher> operationToDispatcher;
    protected Collection<CommandDispatcher> dispatchers;
    protected LiveCommandDispatcher liveConnection;
    final Object LOCK = new Object();

    public MultipleCommandDispatcherClient(MutableCoreController mutableCoreController) {
        this.mutableCore = mutableCoreController;
        this.operationToDispatcher = new HashMap<Operation, CommandDispatcher>();
        this.dispatchers = new Vector<CommandDispatcher>();
        this.commandEventListenerList = new EventListenerList();
    }

    @Override
    public void publish(CommandEvent commandEvent) {
        this.executor.submit(new DispatchEvent(commandEvent));
    }

    public boolean isEventThreadInterested(CommandEventListener commandEventListener, CommandEvent commandEvent) {
        if (commandEventListener == null) {
            return false;
        }
        return this.isEventCurrentOperation(commandEvent) || commandEventListener.caresAboutRepeatedEvents();
    }

    public void addCommandEventListener(CommandEventListener commandEventListener) {
        this.commandEventListenerList.add(CommandEventListener.class, commandEventListener);
    }

    public void removeCommandEventListener(CommandEventListener commandEventListener) {
        this.commandEventListenerList.remove(CommandEventListener.class, commandEventListener);
    }

    public void addLiveCommandDispatcher(Socket socket) throws IOException, JAXBException {
        LiveCommandDispatcher liveCommandDispatcher = new LiveCommandDispatcher(this, this.mutableCore, socket, new ObtainedOperationCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean obtainedOperation(Operation operation, CommandDispatcher commandDispatcher) {
                MultipleCommandDispatcherClient multipleCommandDispatcherClient = MultipleCommandDispatcherClient.this;
                synchronized (multipleCommandDispatcherClient) {
                    if (MultipleCommandDispatcherClient.this.operationToDispatcher.get(operation) != null) {
                        MultipleCommandDispatcherClient.this.operationToDispatcher.get(operation).stop();
                    }
                    MultipleCommandDispatcherClient.this.operationToDispatcher.put(operation, commandDispatcher);
                    MultipleCommandDispatcherClient.this.mutableCore.offerOperation(operation);
                    return true;
                }
            }
        });
        this.dispatchers.add(liveCommandDispatcher);
        this.liveConnection = liveCommandDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addReplayCommandDispatcher(File file) {
        ReplayCommandDispatcher replayCommandDispatcher = new ReplayCommandDispatcher(this, this.mutableCore, file);
        Object object = this.LOCK;
        synchronized (object) {
            if (Operation.NULL.equals(replayCommandDispatcher.getOperation())) {
                return false;
            }
            if (this.operationToDispatcher.get(replayCommandDispatcher.getOperation()) != null) {
                return false;
            }
            this.operationToDispatcher.put(replayCommandDispatcher.getOperation(), replayCommandDispatcher);
            this.dispatchers.add(replayCommandDispatcher);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addReplayCommandDispatcher(ReplayCommandDispatcher replayCommandDispatcher) {
        Object object = this.LOCK;
        synchronized (object) {
            if (replayCommandDispatcher == null) {
                return false;
            }
            if (Operation.NULL.equals(replayCommandDispatcher.getOperation())) {
                return false;
            }
            if (this.operationToDispatcher.get(replayCommandDispatcher.getOperation()) != null) {
                return false;
            }
            if (this.liveConnection != null && this.liveConnection.getOperation().equals(replayCommandDispatcher.getOperation())) {
                return false;
            }
            this.operationToDispatcher.put(replayCommandDispatcher.getOperation(), replayCommandDispatcher);
            this.dispatchers.add(replayCommandDispatcher);
        }
        return true;
    }

    public void addDirectoryMonitor(File file) {
        this.dispatchers.add(new DirectoryMonitoringCommandDispatcher(this, this.mutableCore, file, this));
    }

    public void requestCommandListUpdate() throws JAXBException, IOException, DispatcherException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.requestCommandListUpdate();
    }

    public void requestHelpStatement(String string, HostInfo hostInfo) throws JAXBException, IOException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.requestHelpStatement(string, hostInfo);
    }

    public void restartCommandOutput(TaskId taskId) throws JAXBException, IOException, DispatcherException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.restartCommandOutput(taskId);
    }

    public void sendPing() throws JAXBException, IOException, DispatcherException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.sendPing();
    }

    public void sendPromptReply(int n, TaskId taskId, String string) throws IOException, JAXBException, DispatcherException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.sendPromptReply(n, taskId, string);
    }

    public void sendPromptStopped(TaskId taskId, int n) throws JAXBException, IOException, DispatcherException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.sendPromptStopped(taskId, n);
    }

    public void sendShutdownNotification() throws JAXBException, IOException, DispatcherException {
        if (this.liveConnection == null) {
            this.mutableCore.shutdown(true);
            return;
        }
        this.liveConnection.sendShutdownNotification();
    }

    public void setUseHelpCache(boolean bl) {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.setUseHelpCache(bl);
    }

    public void startCommand(String string, IdCallback idCallback, Object object, HostInfo hostInfo) throws JAXBException, IOException, DispatcherException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.startCommand(string, idCallback, object, hostInfo);
    }

    public void stopCommand(TaskId taskId) throws JAXBException, IOException, DispatcherException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.stopCommand(taskId);
    }

    public void stopCommandOutput(TaskId taskId) throws JAXBException, IOException, DispatcherException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.stopCommandOutput(taskId);
    }

    public void disconnect() {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.disconnect();
    }

    public boolean isConnected() {
        if (this.liveConnection == null) {
            return false;
        }
        return this.liveConnection.isConnected();
    }

    public void addPrefixes(TaskId taskId, List<String> list) throws DispatcherException, IOException, JAXBException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.addPrefixes(taskId, list);
    }

    public void interruptCommand(TaskId taskId) throws JAXBException, IOException {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.interruptCommand(taskId);
    }

    public void repeatTasks(CommandEventListener commandEventListener) {
        if (commandEventListener == null) {
            return;
        }
        Vector vector = new Vector();
        vector.addAll(this.mutableCore.getTaskList());
        for (Task task : vector) {
            CommandEventImpl commandEventImpl = new CommandEventImpl(this, CommandEvent.CommandEventType.INFO, task);
            commandEventImpl.setCurrentOperation(this.isTaskCurrentOperation(task));
            if (!this.isEventThreadInterested(commandEventListener, commandEventImpl)) continue;
            commandEventListener.commandEventReceived((CommandEvent)commandEventImpl);
        }
    }

    private boolean isTaskCurrentOperation(Task task) {
        if (this.liveConnection == null) {
            return false;
        }
        return this.liveConnection.getOperation().equals(task.getId().getOperation());
    }

    private boolean isEventCurrentOperation(CommandEvent commandEvent) {
        if (this.liveConnection == null) {
            return false;
        }
        return this.liveConnection.getOperation().equals(commandEvent.getId().getOperation());
    }

    public int requestStatistics() throws JAXBException, IOException {
        if (this.liveConnection == null) {
            return -1;
        }
        return this.liveConnection.requestStatistics();
    }

    public void sendGuiCommandResponse(int n, boolean bl) {
        if (this.liveConnection == null) {
            return;
        }
        this.liveConnection.sendGuiCommandResponse(n, bl);
    }

    public static interface ObtainedOperationCallback {
        public boolean obtainedOperation(Operation var1, CommandDispatcher var2);
    }

    private class DispatchEvent
    implements Runnable {
        CommandEvent event;

        DispatchEvent(CommandEvent commandEvent) {
            this.event = commandEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CommandEventListener[] commandEventListenerArray = (CommandEventListener[])MultipleCommandDispatcherClient.this.commandEventListenerList.getListeners(CommandEventListener.class);
            Task task = MultipleCommandDispatcherClient.this.mutableCore.getTaskById(this.event.getId());
            if (CommandEvent.CommandEventType.START_PROMPT.equals((Object)this.event.getType())) {
                boolean bl = false;
                Object object = MultipleCommandDispatcherClient.this.LOCK;
                synchronized (object) {
                    for (CommandEventListener commandEventListener : commandEventListenerArray) {
                        if (!commandEventListener.handlesPromptsForTask(task, this.event.getReqId())) continue;
                        bl = true;
                    }
                }
                if (!bl) {
                    MultipleCommandDispatcherClient.this.mutableCore.showPrompt(task, this.event.getReqId(), this.event.getText());
                }
            }
            if (CommandEvent.CommandEventType.STOP_PROMPT.equals((Object)this.event.getType())) {
                MultipleCommandDispatcherClient.this.mutableCore.stopPrompt(task);
            }
            if (CommandEvent.CommandEventType.ENDED.equals((Object)this.event.getType())) {
                MultipleCommandDispatcherClient.this.mutableCore.taskEnded(task);
            }
            for (CommandEventListener commandEventListener : commandEventListenerArray) {
                if (!MultipleCommandDispatcherClient.this.isEventThreadInterested(commandEventListener, this.event)) continue;
                commandEventListener.commandEventReceived(this.event);
            }
        }
    }
}

