/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher.live;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.core.task.TaskId;
import ddb.util.Guid;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.core.commanddispatcher.live.MessageClosure;
import ds.core.commandevents.CommandEventImpl;
import ds.core.impl.task.FileAccess;
import ds.jaxb.ipc.CommandInfoType;
import ds.jaxb.ipc.Message;
import java.io.File;
import java.util.logging.Level;

public class CommandInfoClosure
extends MessageClosure {
    public CommandInfoClosure(LiveCommandDispatcher liveCommandDispatcher) {
        super(liveCommandDispatcher);
    }

    protected boolean evaluateMessage(Message message) {
        if (message.getInfo() == null) {
            return false;
        }
        CommandInfoType commandInfoType = message.getInfo().getCommandInfo();
        return commandInfoType != null;
    }

    protected void handleMessage(Message message) {
        CommandInfoType commandInfoType = message.getInfo().getCommandInfo();
        if (this.live.getMainSystem().isDebugMode()) {
            this.live.getMainSystem().logEvent(Level.FINEST, "Recieved command info message");
        }
        TaskId taskId = this.createTaskId(message.getInfo().getCmdId());
        String string = commandInfoType.getDisplayTransform();
        String string2 = commandInfoType.getStorageTransform();
        String string3 = commandInfoType.getLog();
        String string4 = commandInfoType.getScreenLog();
        String string5 = commandInfoType.getTargetAddress();
        String string6 = commandInfoType.getResourceDirectory();
        MutableTask mutableTask = this.getTaskById(taskId);
        if (mutableTask == null) {
            this.live.getMainSystem().logEvent(Level.WARNING, "Command info received for unknown command\n LogFile: " + string3);
            return;
        }
        mutableTask.setHost(this.live.getMainSystem().getHostById(string5));
        mutableTask.setTaskingInformation((TaskDataAccess)new FileAccess((Task)mutableTask, TaskDataAccess.DataType.TASKING, new File(this.live.getMainSystem().getLogDirectory(), string3), string3, mutableTask.getNextOrdinal()));
        if (string4 != null) {
            mutableTask.setTaskLog((TaskDataAccess)new FileAccess((Task)mutableTask, TaskDataAccess.DataType.LOG, new File(this.live.getMainSystem().getLogDirectory(), string4), string4, -1));
        }
        mutableTask.setDisplayTransform(string);
        mutableTask.setStorageTransform(string2);
        if (string6 != null) {
            mutableTask.setResourceDirectory(string6);
        }
        mutableTask.setTaskId(Guid.GenerateGuid((String)commandInfoType.getTaskId()));
        this.registerTaskId(mutableTask);
        mutableTask.notifyObservers();
        CommandEventImpl commandEventImpl = new CommandEventImpl(this, CommandEvent.CommandEventType.INFO, mutableTask.getCommandName(), "Info received", taskId, mutableTask.getParentId(), mutableTask.getTargetId());
        commandEventImpl.setCurrentOperation(true);
        commandEventImpl.setTargetAddress(mutableTask.getTargetId());
        this.live.publishEvent(commandEventImpl);
    }
}

