/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher.live;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.core.task.TaskState;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.core.commanddispatcher.live.MessageClosure;
import ds.core.commandevents.CommandEventImpl;
import ds.jaxb.ipc.CommandResultType;
import ds.jaxb.ipc.InfoType;
import ds.jaxb.ipc.Message;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;

public class CommandResultClosure
extends MessageClosure {
    public CommandResultClosure(LiveCommandDispatcher liveCommandDispatcher) {
        super(liveCommandDispatcher);
    }

    protected boolean evaluateMessage(Message message) {
        if (message.getInfo() == null) {
            return false;
        }
        return message.getInfo().getCommandResult() != null;
    }

    protected void handleMessage(Message message) {
        TaskId taskId;
        MutableTask mutableTask;
        InfoType infoType = message.getInfo();
        if (this.live.getMainSystem().isDebugMode()) {
            this.live.getMainSystem().logEvent(Level.FINEST, "Recieved command result message");
        }
        if ((mutableTask = this.getTaskById(taskId = this.createTaskId(infoType.getCmdId()))) == null) {
            try {
                this.live.getMainSystem().logEvent(Level.WARNING, "Command result received for unknown command" + this.live.getFormatter().formatMessageAsString(message));
            }
            catch (JAXBException jAXBException) {
                this.live.getMainSystem().logEvent(Level.WARNING, jAXBException.getMessage(), jAXBException);
            }
            return;
        }
        CommandResultType commandResultType = infoType.getCommandResult();
        mutableTask.setResultString(commandResultType.getValue());
        mutableTask.setState(TaskState.parseResult((String)commandResultType.getValue()));
        String string = mutableTask.getCommandName();
        String string2 = commandResultType.getValue();
        TaskId taskId2 = mutableTask.getParentId();
        CommandEventImpl commandEventImpl = new CommandEventImpl(this, CommandEvent.CommandEventType.ENDED, string, string2, taskId, taskId2, mutableTask.getTargetId());
        commandEventImpl.setCurrentOperation(true);
        commandEventImpl.setTargetAddress(mutableTask.getTargetId());
        this.live.publishEvent(commandEventImpl);
        mutableTask.notifyObservers();
    }
}

